/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockPoint3D;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Point3D;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.server.location.World;
import org.kingdoms.server.location.WorldContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001aJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u001bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0002J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J \u0010#\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001aH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/kingdoms/server/location/Vector3Location;", "Lorg/kingdoms/server/location/WorldContainer;", "Lorg/kingdoms/server/location/Point3D;", "world", "Lorg/kingdoms/server/location/World;", "x", "", "y", "z", "<init>", "(Lorg/kingdoms/server/location/World;DDD)V", "getWorld", "()Lorg/kingdoms/server/location/World;", "getX", "()D", "getY", "getZ", "hashCode", "", "equals", "", "other", "", "toString", "", "add", "", "Lorg/kingdoms/server/location/BlockPoint3D;", "subtract", "toBlockLocation", "Lorg/kingdoms/server/location/BlockLocation3;", "toBlockVector", "Lorg/kingdoms/server/location/BlockVector3;", "toVector", "Lorg/kingdoms/server/location/Vector3;", "simpleAdd", "Companion", "shared"})
public final class Vector3Location
implements WorldContainer,
Point3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final double x;
    private final double y;
    private final double z;

    public Vector3Location(@NotNull World world, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.world;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Vector3Location)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getWorld(), (Object)((Vector3Location)other).getWorld()) && this.getX() == ((Vector3Location)other).getX() && this.getY() == ((Vector3Location)other).getY() && this.getZ() == ((Vector3Location)other).getZ();
    }

    @NotNull
    public String toString() {
        return "Vector3Location(world=" + this.getWorld() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ')';
    }

    @NotNull
    public final Vector3Location add(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return this.simpleAdd(x, y, z);
    }

    @NotNull
    public final Vector3Location add(@NotNull BlockPoint3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Vector3Location add(@NotNull Point3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Vector3Location subtract(@NotNull BlockPoint3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.subtract(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Vector3Location subtract(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return this.simpleAdd(-x.doubleValue(), -y.doubleValue(), -z.doubleValue());
    }

    @NotNull
    public final BlockLocation3 toBlockLocation() {
        return BlockLocation3.Companion.of(this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ());
    }

    @NotNull
    public final BlockVector3 toBlockVector() {
        return BlockVector3.Companion.of((int)this.getX(), (int)this.getY(), (int)this.getZ());
    }

    @NotNull
    public final Vector3 toVector() {
        return Vector3.Companion.of(this.getX(), this.getY(), this.getZ());
    }

    private final Vector3Location simpleAdd(Number x, Number y, Number z) {
        return Companion.of(this.getWorld(), this.getX() + x.doubleValue(), this.getY() + y.doubleValue(), this.getZ() + z.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Void modify() {
        return Companion.modify();
    }

    @JvmStatic
    @NotNull
    public static final Vector3Location of(@NotNull World world, double x, double y, double z) {
        return Companion.of(world, x, y, z);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\u0004\u001a\u00020\u0005H\u0087\bJ(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/server/location/Vector3Location$Companion;", "", "<init>", "()V", "modify", "", "of", "Lorg/kingdoms/server/location/Vector3Location;", "world", "Lorg/kingdoms/server/location/World;", "x", "", "y", "z", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Void modify() {
            boolean $i$f$modify = false;
            throw new UnsupportedOperationException("Cannot modify immutable location");
        }

        @JvmStatic
        @NotNull
        public final Vector3Location of(@NotNull World world, double x, double y, double z) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return new Vector3Location(world, x, y, z);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

