/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import java.util.Collection;
import java.util.Map;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.Directional;
import org.kingdoms.server.location.LocationUtils;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.utils.internal.enumeration.Enums;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 62\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u000256B)\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0012\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u0012\u0006\u0010\f\u001a\u00020\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u0011\u00102\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b3\u00104j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u00067"}, d2={"Lorg/kingdoms/server/location/Direction;", "Lorg/kingdoms/server/location/Directional;", "", "modX", "", "modY", "modZ", "type", "Lorg/kingdoms/server/location/Direction$Type;", "<init>", "(Ljava/lang/String;IIIILorg/kingdoms/server/location/Direction$Type;)V", "face1", "face2", "(Ljava/lang/String;ILorg/kingdoms/server/location/Direction;Lorg/kingdoms/server/location/Direction;Lorg/kingdoms/server/location/Direction$Type;)V", "NORTH", "EAST", "SOUTH", "WEST", "UP", "DOWN", "NORTH_EAST", "NORTH_WEST", "SOUTH_EAST", "SOUTH_WEST", "WEST_NORTH_WEST", "NORTH_NORTH_WEST", "NORTH_NORTH_EAST", "EAST_NORTH_EAST", "EAST_SOUTH_EAST", "SOUTH_SOUTH_EAST", "SOUTH_SOUTH_WEST", "WEST_SOUTH_WEST", "getType", "()Lorg/kingdoms/server/location/Direction$Type;", "x", "getX", "()I", "y", "getY", "z", "getZ", "yaw", "", "getYaw", "()F", "pitch", "getPitch", "isCartesian", "", "()Z", "oppositeFace", "getOppositeFace", "()Lorg/kingdoms/server/location/Direction;", "Type", "Companion", "shared"})
public final class Direction
extends Enum<Direction>
implements Directional {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Type type;
    private final int x;
    private final int y;
    private final int z;
    private final float yaw;
    private final float pitch;
    @JvmField
    @NotNull
    public static final Direction[] VALUES;
    private static final Map<String, Direction> MAPPINGS;
    public static final /* enum */ Direction NORTH;
    public static final /* enum */ Direction EAST;
    public static final /* enum */ Direction SOUTH;
    public static final /* enum */ Direction WEST;
    public static final /* enum */ Direction UP;
    public static final /* enum */ Direction DOWN;
    public static final /* enum */ Direction NORTH_EAST;
    public static final /* enum */ Direction NORTH_WEST;
    public static final /* enum */ Direction SOUTH_EAST;
    public static final /* enum */ Direction SOUTH_WEST;
    public static final /* enum */ Direction WEST_NORTH_WEST;
    public static final /* enum */ Direction NORTH_NORTH_WEST;
    public static final /* enum */ Direction NORTH_NORTH_EAST;
    public static final /* enum */ Direction EAST_NORTH_EAST;
    public static final /* enum */ Direction EAST_SOUTH_EAST;
    public static final /* enum */ Direction SOUTH_SOUTH_EAST;
    public static final /* enum */ Direction SOUTH_SOUTH_WEST;
    public static final /* enum */ Direction WEST_SOUTH_WEST;
    private static final /* synthetic */ Direction[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    private Direction(int modX, int modY, int modZ, Type type) {
        this.x = modX;
        this.y = modY;
        this.z = modZ;
        this.type = type;
        Directional directional = LocationUtils.INSTANCE.fromDirection(Vector3.Companion.of(modX, modY, modZ));
        if (modX == 0 && modZ == 0) {
            this.yaw = 0.0f;
            this.pitch = directional.getPitch();
        } else if (modY == 0) {
            this.yaw = (directional.getYaw() + 180.0f) % (float)360;
            this.pitch = 0.0f;
        } else {
            this.yaw = (directional.getYaw() + 180.0f) % (float)360;
            this.pitch = directional.getPitch();
        }
    }

    private Direction(Direction face1, Direction face2, Type type) {
        this(face1.x + face2.x, face1.y + face2.y, face1.z + face2.z, type);
    }

    public final boolean isCartesian() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Direction getOppositeFace() {
        Direction direction;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                direction = SOUTH;
                break;
            }
            case 3: {
                direction = NORTH;
                break;
            }
            case 2: {
                direction = WEST;
                break;
            }
            case 4: {
                direction = EAST;
                break;
            }
            case 5: {
                direction = DOWN;
                break;
            }
            case 6: {
                direction = UP;
                break;
            }
            case 7: {
                direction = SOUTH_WEST;
                break;
            }
            case 8: {
                direction = SOUTH_EAST;
                break;
            }
            case 9: {
                direction = NORTH_WEST;
                break;
            }
            case 10: {
                direction = NORTH_EAST;
                break;
            }
            case 11: {
                direction = EAST_SOUTH_EAST;
                break;
            }
            case 12: {
                direction = SOUTH_SOUTH_EAST;
                break;
            }
            case 13: {
                direction = SOUTH_SOUTH_WEST;
                break;
            }
            case 14: {
                direction = WEST_SOUTH_WEST;
                break;
            }
            case 15: {
                direction = WEST_NORTH_WEST;
                break;
            }
            case 16: {
                direction = NORTH_NORTH_WEST;
                break;
            }
            case 17: {
                direction = NORTH_NORTH_EAST;
                break;
            }
            case 18: {
                direction = EAST_NORTH_EAST;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return direction;
    }

    public static Direction[] values() {
        return (Direction[])$VALUES.clone();
    }

    public static Direction valueOf(String value) {
        return Enum.valueOf(Direction.class, value);
    }

    @NotNull
    public static EnumEntries<Direction> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @Nullable
    public static final Direction fromString(@NotNull String name) {
        return Companion.fromString(name);
    }

    @JvmStatic
    @Nullable
    public static final Direction findClosest(@NotNull Vector3 immutableVector, @NotNull Collection<? extends Type> allowedTypes) {
        return Companion.findClosest(immutableVector, allowedTypes);
    }

    @JvmStatic
    public static final float normalizeMinecraftYaw(float yaw) {
        return Companion.normalizeMinecraftYaw(yaw);
    }

    @JvmStatic
    @NotNull
    public static final Direction getPitchDirection(float pitch) {
        return Companion.getPitchDirection(pitch);
    }

    @JvmStatic
    @NotNull
    public static final Direction cardinalDirectionFromYaw(float yaw) {
        return Companion.cardinalDirectionFromYaw(yaw);
    }

    @JvmStatic
    @NotNull
    public static final Direction fromYaw(float yaw) {
        return Companion.fromYaw(yaw);
    }

    static {
        NORTH = new Direction(0, 0, -1, Type.CARDINAL);
        EAST = new Direction(1, 0, 0, Type.CARDINAL);
        SOUTH = new Direction(0, 0, 1, Type.CARDINAL);
        WEST = new Direction(-1, 0, 0, Type.CARDINAL);
        UP = new Direction(0, 1, 0, Type.VERTICAL);
        DOWN = new Direction(0, -1, 0, Type.VERTICAL);
        NORTH_EAST = new Direction(NORTH, EAST, Type.ORDINAL);
        NORTH_WEST = new Direction(NORTH, WEST, Type.ORDINAL);
        SOUTH_EAST = new Direction(SOUTH, EAST, Type.ORDINAL);
        SOUTH_WEST = new Direction(SOUTH, WEST, Type.ORDINAL);
        WEST_NORTH_WEST = new Direction(WEST, NORTH_WEST, Type.SECONDARY_ORDINAL);
        NORTH_NORTH_WEST = new Direction(NORTH, NORTH_WEST, Type.SECONDARY_ORDINAL);
        NORTH_NORTH_EAST = new Direction(NORTH, NORTH_EAST, Type.SECONDARY_ORDINAL);
        EAST_NORTH_EAST = new Direction(EAST, NORTH_EAST, Type.SECONDARY_ORDINAL);
        EAST_SOUTH_EAST = new Direction(EAST, SOUTH_EAST, Type.SECONDARY_ORDINAL);
        SOUTH_SOUTH_EAST = new Direction(SOUTH, SOUTH_EAST, Type.SECONDARY_ORDINAL);
        SOUTH_SOUTH_WEST = new Direction(SOUTH, SOUTH_WEST, Type.SECONDARY_ORDINAL);
        WEST_SOUTH_WEST = new Direction(WEST, SOUTH_WEST, Type.SECONDARY_ORDINAL);
        $VALUES = directionArray = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN, Direction.NORTH_EAST, Direction.NORTH_WEST, Direction.SOUTH_EAST, Direction.SOUTH_WEST, Direction.WEST_NORTH_WEST, Direction.NORTH_NORTH_WEST, Direction.NORTH_NORTH_EAST, Direction.EAST_NORTH_EAST, Direction.EAST_SOUTH_EAST, Direction.SOUTH_SOUTH_EAST, Direction.SOUTH_SOUTH_WEST, Direction.WEST_SOUTH_WEST};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        VALUES = Direction.values();
        MAPPINGS = Enums.createMapping((Enum[])VALUES);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0007J \u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0007J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0017H\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0007J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0007R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007RP\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00060\u0006 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/server/location/Direction$Companion;", "", "<init>", "()V", "VALUES", "", "Lorg/kingdoms/server/location/Direction;", "[Lorg/kingdoms/server/location/Direction;", "MAPPINGS", "", "", "org.kingdoms.libs.kotlin.jvm.PlatformType", "", "Ljava/util/Map;", "fromString", "name", "findClosest", "immutableVector", "Lorg/kingdoms/server/location/Vector3;", "allowedTypes", "", "Lorg/kingdoms/server/location/Direction$Type;", "normalizeMinecraftYaw", "", "yaw", "getPitchDirection", "pitch", "cardinalDirectionFromYaw", "fromYaw", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Direction fromString(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return (Direction)MAPPINGS.get(name);
        }

        @JvmStatic
        @Nullable
        public final Direction findClosest(@NotNull Vector3 immutableVector, @NotNull Collection<? extends Type> allowedTypes) {
            Intrinsics.checkNotNullParameter((Object)immutableVector, (String)"immutableVector");
            Intrinsics.checkNotNullParameter(allowedTypes, (String)"allowedTypes");
            Vector3 vector = immutableVector;
            if (allowedTypes.contains((Object)Type.VERTICAL)) {
                vector = vector.withY(0.0);
            }
            vector = vector.normalize();
            Direction closest = null;
            double closestDot = -2.0;
            for (Direction direction : Direction.values()) {
                if (!allowedTypes.contains((Object)direction.getType())) continue;
            }
            return closest;
        }

        @JvmStatic
        public final float normalizeMinecraftYaw(float yaw) {
            float yaw2 = (yaw + 180.0f) % (float)360;
            return yaw2 < 0.0f ? yaw2 + (float)360 : yaw2;
        }

        @JvmStatic
        @NotNull
        public final Direction getPitchDirection(float pitch) {
            Direction direction;
            float f = pitch;
            boolean bl = -90.0f <= f ? f <= 0.0f : false;
            if (bl) {
                direction = DOWN;
            } else {
                boolean bl2 = 0.0f <= f ? f <= 90.0f : false;
                if (bl2) {
                    direction = UP;
                } else {
                    throw new IllegalArgumentException("Unknown Minecraft pitch value: " + pitch);
                }
            }
            return direction;
        }

        @JvmStatic
        @NotNull
        public final Direction cardinalDirectionFromYaw(float yaw) {
            Direction direction;
            float transformedYaw = this.normalizeMinecraftYaw(yaw);
            boolean bl = 0.0f <= transformedYaw ? transformedYaw <= 45.0f : false;
            if (bl) {
                direction = NORTH;
            } else {
                boolean bl2 = 45.0f <= transformedYaw ? transformedYaw <= 135.0f : false;
                if (bl2) {
                    direction = EAST;
                } else {
                    boolean bl3 = 135.0f <= transformedYaw ? transformedYaw <= 225.0f : false;
                    if (bl3) {
                        direction = SOUTH;
                    } else {
                        boolean bl4 = 225.0f <= transformedYaw ? transformedYaw <= 315.0f : false;
                        if (bl4) {
                            direction = WEST;
                        } else {
                            boolean bl5 = 315.0f <= transformedYaw ? transformedYaw <= 360.0f : false;
                            if (bl5) {
                                direction = NORTH;
                            } else {
                                throw new AssertionError((Object)("Unexpected yaw for cardinal direction: " + yaw + " -> " + transformedYaw));
                            }
                        }
                    }
                }
            }
            return direction;
        }

        @JvmStatic
        @NotNull
        public final Direction fromYaw(float yaw) {
            Direction direction;
            float f;
            float yaw2 = yaw;
            if ((yaw2 %= 360.0f) < 0.0f) {
                yaw2 += 360.0f;
            }
            boolean bl = 337.5f <= (f = yaw2) ? f <= 360.0f : false;
            if (bl) {
                direction = SOUTH;
            } else {
                boolean bl2 = 292.5f <= f ? f <= 337.5f : false;
                if (bl2) {
                    direction = NORTH_EAST;
                } else {
                    boolean bl3 = 247.5f <= f ? f <= 292.5f : false;
                    if (bl3) {
                        direction = EAST;
                    } else {
                        boolean bl4 = 202.5f <= f ? f <= 247.5f : false;
                        if (bl4) {
                            direction = SOUTH_EAST;
                        } else {
                            boolean bl5 = 157.5f <= f ? f <= 202.5f : false;
                            if (bl5) {
                                direction = NORTH;
                            } else {
                                boolean bl6 = 112.5f <= f ? f <= 157.5f : false;
                                if (bl6) {
                                    direction = NORTH_WEST;
                                } else {
                                    boolean bl7 = 67.5f <= f ? f <= 112.5f : false;
                                    if (bl7) {
                                        direction = WEST;
                                    } else {
                                        boolean bl8 = 22.5f <= f ? f <= 67.5f : false;
                                        if (bl8) {
                                            direction = SOUTH_WEST;
                                        } else {
                                            boolean bl9 = 0.0f <= f ? f <= 22.5f : false;
                                            if (bl9) {
                                                direction = SOUTH;
                                            } else {
                                                throw new AssertionError((Object)("Unexpected yaw for direction: " + yaw2));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return direction;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/server/location/Direction$Type;", "", "<init>", "(Ljava/lang/String;I)V", "CARDINAL", "ORDINAL", "SECONDARY_ORDINAL", "VERTICAL", "shared"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type CARDINAL = new Type();
        public static final /* enum */ Type ORDINAL = new Type();
        public static final /* enum */ Type SECONDARY_ORDINAL = new Type();
        public static final /* enum */ Type VERTICAL = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.CARDINAL, Type.ORDINAL, Type.SECONDARY_ORDINAL, Type.VERTICAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH_EAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH_WEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH_EAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH_WEST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST_NORTH_WEST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH_NORTH_WEST.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH_NORTH_EAST.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST_NORTH_EAST.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST_SOUTH_EAST.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH_SOUTH_EAST.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH_SOUTH_WEST.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST_SOUTH_WEST.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

