/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockPoint3D;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.server.location.World;
import org.kingdoms.utils.internal.string.CommaDataSplitStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0012J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0001J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0001J\u001e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0019J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000J\u0013\u0010'\u001a\u00020!2\b\u0010\u0013\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\u0004H\u0016J\b\u0010*\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006,"}, d2={"Lorg/kingdoms/server/location/BlockVector3;", "Lorg/kingdoms/server/location/BlockPoint3D;", "Lorg/kingdoms/constants/DataStringRepresentation;", "x", "", "y", "z", "<init>", "(III)V", "getX", "()I", "getY", "getZ", "asDataString", "", "getChunkLocation", "Lorg/kingdoms/server/location/BlockVector2;", "add", "", "other", "subtract", "divide", "Lorg/kingdoms/server/location/Vector3;", "by", "length", "", "toVector", "inWorld", "Lorg/kingdoms/server/location/BlockLocation3;", "world", "Lorg/kingdoms/server/location/World;", "lengthSq", "containedWithin", "", "min", "max", "getMinimum", "v2", "getMaximum", "equals", "", "hashCode", "toString", "Companion", "shared"})
public final class BlockVector3
implements BlockPoint3D,
DataStringRepresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final int z;

    public BlockVector3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    @NotNull
    public String asDataString() {
        Object[] objectArray = new Object[]{this.getX(), this.getY(), this.getZ()};
        String string = CommaDataSplitStrategy.toString(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final BlockVector2 getChunkLocation() {
        return BlockVector2.Companion.of(this.getX() >> 4, this.getZ() >> 4);
    }

    @NotNull
    public final BlockVector3 add(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return Companion.of(this.getX() + x.intValue(), this.getY() + y.intValue(), this.getZ() + z.intValue());
    }

    @NotNull
    public final BlockVector3 add(@NotNull BlockPoint3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final BlockVector3 subtract(@NotNull BlockPoint3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.subtract(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final BlockVector3 subtract(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return Companion.of(this.getX() - x.intValue(), this.getY() - y.intValue(), this.getZ() - z.intValue());
    }

    @NotNull
    public final Vector3 divide(@NotNull Number by) {
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        return Vector3.Companion.of(this.getX() / by.intValue(), this.getY() / by.intValue(), this.getZ() / by.intValue());
    }

    public final double length() {
        return Math.sqrt(this.lengthSq());
    }

    @NotNull
    public final Vector3 toVector() {
        return Vector3.Companion.of(this.getX(), this.getY(), this.getZ());
    }

    @NotNull
    public final BlockLocation3 inWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return BlockLocation3.Companion.of(world, this.getX(), this.getY(), this.getZ());
    }

    public final double lengthSq() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public final boolean containedWithin(@NotNull BlockVector3 min, @NotNull BlockVector3 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        return this.getX() >= min.getX() && this.getX() <= max.getX() && this.getY() >= min.getY() && this.getY() <= max.getY() && this.getZ() >= min.getZ() && this.getZ() <= max.getZ();
    }

    @NotNull
    public final BlockVector3 getMinimum(@NotNull BlockVector3 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return Companion.of(Math.min(this.getX(), v2.getX()), Math.min(this.getY(), v2.getY()), Math.min(this.getZ(), v2.getZ()));
    }

    @NotNull
    public final BlockVector3 getMaximum(@NotNull BlockVector3 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return Companion.of(Math.max(this.getX(), v2.getX()), Math.max(this.getY(), v2.getY()), Math.max(this.getZ(), v2.getZ()));
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BlockVector3)) {
            return false;
        }
        return this.getX() == ((BlockVector3)other).getX() && this.getY() == ((BlockVector3)other).getY() && this.getZ() == ((BlockVector3)other).getZ();
    }

    public int hashCode() {
        int prime = 31;
        int result = 14;
        result = prime * result + this.getX();
        result = prime * result + this.getY();
        result = prime * result + this.getZ();
        return result;
    }

    @NotNull
    public String toString() {
        return "BlockVector3(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ')';
    }

    @JvmStatic
    @NotNull
    public static final BlockVector3 of(int x, int y, int z) {
        return Companion.of(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final BlockVector3 of(@NotNull BlockPoint3D other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final BlockVector3 fromString(@NotNull String str) {
        return Companion.fromString(str);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/server/location/BlockVector3$Companion;", "", "<init>", "()V", "of", "Lorg/kingdoms/server/location/BlockVector3;", "x", "", "y", "z", "other", "Lorg/kingdoms/server/location/BlockPoint3D;", "fromString", "str", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BlockVector3 of(int x, int y, int z) {
            return new BlockVector3(x, y, z);
        }

        @JvmStatic
        @NotNull
        public final BlockVector3 of(@NotNull BlockPoint3D other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.of(other.getX(), other.getY(), other.getZ());
        }

        @JvmStatic
        @NotNull
        public final BlockVector3 fromString(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            CommaDataSplitStrategy $this$fromString_u24lambda_u240 = new CommaDataSplitStrategy(str, 3);
            boolean bl = false;
            return new BlockVector3($this$fromString_u24lambda_u240.nextInt(), $this$fromString_u24lambda_u240.nextInt(), $this$fromString_u24lambda_u240.nextInt());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

