/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.BlockPoint2D;
import org.kingdoms.utils.internal.string.CommaDataSplitStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/server/location/BlockVector2;", "Lorg/kingdoms/server/location/BlockPoint2D;", "Lorg/kingdoms/constants/DataStringRepresentation;", "x", "", "z", "<init>", "(II)V", "getX", "()I", "getZ", "asDataString", "", "hashCode", "equals", "", "obj", "", "toString", "Companion", "shared"})
public final class BlockVector2
implements BlockPoint2D,
DataStringRepresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int z;
    public static final int CHUNK_SHIFTS = 4;
    public static final int CHUNK_SHIFTS_Y = 8;

    public BlockVector2(int x, int z) {
        this.x = x;
        this.z = z;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    @NotNull
    public String asDataString() {
        Object[] objectArray = new Object[]{this.getX(), this.getZ()};
        String string = CommaDataSplitStrategy.toString(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        return this.getZ() << 16 ^ this.getX();
    }

    public boolean equals(@Nullable Object obj) {
        BlockPoint2D blockPoint2D = obj instanceof BlockPoint2D ? (BlockPoint2D)obj : null;
        if (blockPoint2D == null) {
            return false;
        }
        BlockPoint2D other = blockPoint2D;
        return this.getX() == other.getX() && this.getZ() == other.getZ();
    }

    @NotNull
    public String toString() {
        return "BlockVector2(" + this.getX() + ", " + this.getZ() + ')';
    }

    @JvmStatic
    @NotNull
    public static final BlockVector2 of(@NotNull BlockPoint2D other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final BlockVector2 of(int x, int z) {
        return Companion.of(x, z);
    }

    @JvmStatic
    @NotNull
    public static final BlockVector2 fromString(@NotNull String str) {
        return Companion.fromString(str);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/server/location/BlockVector2$Companion;", "", "<init>", "()V", "CHUNK_SHIFTS", "", "CHUNK_SHIFTS_Y", "of", "Lorg/kingdoms/server/location/BlockVector2;", "other", "Lorg/kingdoms/server/location/BlockPoint2D;", "x", "z", "fromString", "str", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BlockVector2 of(@NotNull BlockPoint2D other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.of(other.getX(), other.getZ());
        }

        @JvmStatic
        @NotNull
        public final BlockVector2 of(int x, int z) {
            return new BlockVector2(x, z);
        }

        @JvmStatic
        @NotNull
        public final BlockVector2 fromString(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            CommaDataSplitStrategy $this$fromString_u24lambda_u240 = new CommaDataSplitStrategy(str, 2);
            boolean bl = false;
            return new BlockVector2($this$fromString_u24lambda_u240.nextInt(), $this$fromString_u24lambda_u240.nextInt());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

