/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.core.Server;
import org.kingdoms.server.location.BlockPoint3D;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.World;
import org.kingdoms.server.location.WorldContainer;
import org.kingdoms.server.location.WorldRegistry;
import org.kingdoms.utils.internal.string.CommaDataSplitStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/kingdoms/server/location/BlockLocation3;", "Lorg/kingdoms/server/location/BlockPoint3D;", "Lorg/kingdoms/server/location/WorldContainer;", "Lorg/kingdoms/constants/DataStringRepresentation;", "world", "Lorg/kingdoms/server/location/World;", "x", "", "y", "z", "<init>", "(Lorg/kingdoms/server/location/World;III)V", "getWorld", "()Lorg/kingdoms/server/location/World;", "getX", "()I", "getY", "getZ", "asDataString", "", "add", "", "subtract", "toVector", "Lorg/kingdoms/server/location/BlockVector3;", "hashCode", "equals", "", "other", "", "toString", "Companion", "shared"})
public final class BlockLocation3
implements BlockPoint3D,
WorldContainer,
DataStringRepresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final int x;
    private final int y;
    private final int z;

    public BlockLocation3(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.world;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    @NotNull
    public String asDataString() {
        Object[] objectArray = new Object[]{this.getWorld().getName(), this.getX(), this.getY(), this.getZ()};
        String string = CommaDataSplitStrategy.toString(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final BlockLocation3 add(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return Companion.of(this.getWorld(), this.getX() + x.intValue(), this.getY() + y.intValue(), this.getZ() + z.intValue());
    }

    @NotNull
    public final BlockLocation3 subtract(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return this.add(-x.intValue(), -y.intValue(), -z.intValue());
    }

    @NotNull
    public final BlockVector3 toVector() {
        return BlockVector3.Companion.of(this.getX(), this.getY(), this.getZ());
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String toString() {
        return "BlockLocation3(" + this.getWorld() + ", " + this.getX() + ", " + this.getY() + ", " + this.getZ() + ')';
    }

    @JvmStatic
    @NotNull
    public static final BlockLocation3 of(@NotNull World world, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        return Companion.of(world, x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final BlockLocation3 of(@NotNull World world, @NotNull BlockPoint3D other) {
        return Companion.of(world, other);
    }

    @JvmStatic
    @NotNull
    public static final BlockLocation3 fromString(@NotNull String str) {
        return Companion.fromString(str);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/server/location/BlockLocation3$Companion;", "", "<init>", "()V", "of", "Lorg/kingdoms/server/location/BlockLocation3;", "world", "Lorg/kingdoms/server/location/World;", "x", "", "y", "z", "other", "Lorg/kingdoms/server/location/BlockPoint3D;", "fromString", "str", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BlockLocation3 of(@NotNull World world, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Intrinsics.checkNotNullParameter((Object)z, (String)"z");
            return new BlockLocation3(world, x.intValue(), y.intValue(), z.intValue());
        }

        @JvmStatic
        @NotNull
        public final BlockLocation3 of(@NotNull World world, @NotNull BlockPoint3D other) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.of(world, other.getX(), other.getY(), other.getZ());
        }

        @JvmStatic
        @NotNull
        public final BlockLocation3 fromString(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            CommaDataSplitStrategy $this$fromString_u24lambda_u240 = new CommaDataSplitStrategy(str, 4);
            boolean bl = false;
            String worldName = $this$fromString_u24lambda_u240.nextString();
            WorldRegistry worldRegistry = Server.get().getWorldRegistry();
            Intrinsics.checkNotNull((Object)worldName);
            World world = worldRegistry.getWorld(worldName);
            if (world == null) {
                throw new IllegalArgumentException("Cannot find world " + worldName + " in string '" + str + '\'');
            }
            return new BlockLocation3(world, $this$fromString_u24lambda_u240.nextInt(), $this$fromString_u24lambda_u240.nextInt(), $this$fromString_u24lambda_u240.nextInt());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

