/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.inventory;

import java.util.Arrays;

public interface InventorySlot {
    public int[] getSlots();

    default public int getSlot() {
        int[] slots = this.getSlots();
        if (slots.length != 1) {
            throw new UnsupportedOperationException("Not a single slot: " + this);
        }
        return slots[0];
    }

    public static int[] inherit(InventorySlot ... slots) {
        return Arrays.stream(slots).flatMapToInt(x -> Arrays.stream(x.getSlots())).toArray();
    }

    public static int[] range(int min, int max) {
        int[] slots = new int[max - min];
        int index = 0;
        int i = min;
        while (i < max) {
            slots[index++] = i++;
        }
        return slots;
    }

    public static enum Player implements InventorySlot
    {
        HELMET(39),
        CHESTPLATE(38),
        LEGGINGS(37),
        BOOTS(36),
        UPPER_STORAGE(9, 35),
        ARMOR(HELMET, CHESTPLATE, LEGGINGS, BOOTS),
        HOTBAR(0, 8),
        OFFHAND(40);

        private final int[] slots;

        private Player(int[] slots) {
            this.slots = slots;
        }

        private Player(Player ... slots) {
            this.slots = InventorySlot.inherit(slots);
        }

        private Player(int min, int max) {
            this.slots = InventorySlot.range(min, max);
        }

        private Player(int slot) {
            this.slots = new int[]{slot};
        }

        @Override
        public int[] getSlots() {
            return this.slots;
        }
    }
}

