/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.scheduler;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kingdoms.utils.internal.arrays.ArrayUtils;

public final class TracedRunnable
implements Runnable {
    private final StackTraceElement[] trace = new Throwable().getStackTrace();
    private final Runnable original;

    public TracedRunnable(Runnable original) {
        this.original = Objects.requireNonNull(original);
    }

    @Override
    public void run() {
        try {
            this.original.run();
        }
        catch (Throwable ex) {
            try {
                StackTraceElement[] base = (StackTraceElement[])Arrays.stream(this.trace).skip(1L).toArray(StackTraceElement[]::new);
                ex.setStackTrace(ArrayUtils.merge(ex.getStackTrace(), base));
            }
            catch (Throwable fatalEx) {
                IllegalStateException finalEx = new IllegalStateException("Fatal exception", fatalEx);
                finalEx.addSuppressed(ex);
                throw finalEx;
            }
            throw ex;
        }
    }

    public String toString() {
        return "TracedRunnable(" + this.original + ", " + Arrays.stream(this.trace).map(StackTraceElement::toString).collect(Collectors.joining("\n")) + ')';
    }
}

