/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.scheduler;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.scheduler.DelayedRepeatingTask;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.scheduler.Task;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH&J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH&J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\b\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/scheduler/TaskScheduler;", "", "getExecutionContextType", "Lorg/kingdoms/scheduler/Task$ExecutionContextType;", "getExecutor", "Ljava/util/concurrent/Executor;", "execute", "Lorg/kingdoms/scheduler/Task;", "runnable", "Ljava/lang/Runnable;", "delayed", "Lorg/kingdoms/scheduler/DelayedTask;", "delay", "Ljava/time/Duration;", "repeating", "Lorg/kingdoms/scheduler/DelayedRepeatingTask;", "initialDelay", "intervalDelays", "supplyFuture", "Ljava/util/concurrent/CompletableFuture;", "T", "callable", "Ljava/util/concurrent/Callable;", "runFuture", "Ljava/lang/Void;", "core"})
public interface TaskScheduler {
    @NotNull
    public Task.ExecutionContextType getExecutionContextType();

    @NotNull
    public Executor getExecutor();

    @NotNull
    public Task execute(@NotNull Runnable var1);

    @NotNull
    public DelayedTask delayed(@NotNull Duration var1, @NotNull Runnable var2);

    @NotNull
    public DelayedRepeatingTask repeating(@NotNull Duration var1, @NotNull Duration var2, @NotNull Runnable var3);

    @NotNull
    default public <T> CompletableFuture<T> supplyFuture(@NotNull Callable<T> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> TaskScheduler.supplyFuture$lambda$0(callable), this.getExecutor());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    default public CompletableFuture<Void> runFuture(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable, this.getExecutor());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    private static Object supplyFuture$lambda$0(Callable $callable) {
        try {
            return $callable.call();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw e;
            }
            throw new CompletionException(e);
        }
    }
}

