/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.scheduler;

import org.kingdoms.scheduler.TaskScheduler;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.server.core.Server;

public interface TaskScheduleProvider {
    public TaskScheduler async();

    public TaskScheduler sync();

    default public void run(TaskThreadType threadType, Runnable runnable) {
        boolean async;
        if (threadType == TaskThreadType.ANY) {
            runnable.run();
            return;
        }
        boolean isMainThread = Server.get().isMainThread();
        if (isMainThread == !(async = threadType == TaskThreadType.ASYNC)) {
            runnable.run();
            return;
        }
        TaskScheduler scheduler = async ? this.async() : this.sync();
        scheduler.execute(runnable);
    }

    public boolean isShutdown();

    public void shutdown();
}

