/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.scheduler;

import java.time.Duration;
import java.util.concurrent.Executor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.scheduler.AbstractDelayedRepeatingTask;
import org.kingdoms.scheduler.AbstractDelayedTask;
import org.kingdoms.scheduler.AbstractTask;
import org.kingdoms.scheduler.DelayedRepeatingTask;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.scheduler.Task;
import org.kingdoms.scheduler.TaskScheduler;

public class InstantTaskScheduler
implements TaskScheduler {
    public static final InstantTaskScheduler INSTANCE = new InstantTaskScheduler();

    protected InstantTaskScheduler() {
    }

    @Override
    @NotNull
    public Task.ExecutionContextType getExecutionContextType() {
        return Task.ExecutionContextType.SYNC;
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        throw new UnsupportedOperationException();
    }

    private static void checkDuration(Duration duration, String fieldName) {
        if (!duration.isZero()) {
            throw new IllegalArgumentException("Instant task scheduler cannot run task with " + fieldName + " of " + duration);
        }
    }

    @Override
    @NotNull
    public Task execute(@NotNull Runnable runnable) {
        return new AbstractTask(this.getExecutionContextType(), runnable);
    }

    @Override
    @NotNull
    public DelayedTask delayed(@NotNull Duration delay, @NotNull Runnable runnable) {
        InstantTaskScheduler.checkDuration(delay, "delay");
        return new AbstractDelayedTask(runnable, delay, this.getExecutionContextType()){

            @Override
            public boolean cancel() {
                return super.cancel();
            }
        };
    }

    @Override
    @NotNull
    public DelayedRepeatingTask repeating(@NotNull Duration initialDelay, @NotNull Duration intervalDelays, @NotNull Runnable runnable) {
        InstantTaskScheduler.checkDuration(initialDelay, "initialDelay");
        InstantTaskScheduler.checkDuration(intervalDelays, "intervalDelays");
        return new AbstractDelayedRepeatingTask(runnable, initialDelay, intervalDelays, this.getExecutionContextType()){

            @Override
            public boolean cancel() {
                return super.cancel();
            }
        };
    }
}

