/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.platform.bukkit.adapters;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftClassHandle;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.nbt.NBTConverter;
import org.kingdoms.nbt.NBTTagConverterRegistry;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.reflection.Reflect;

public final class BukkitNBTAdapter {
    public static void registerAll() {
        List<NBTConverter> list = Arrays.asList(new BukkitNBTCompound(), new NBTTagList(), new NBTTagString(), new NBTTagByte(), new NBTTagShort(), new NBTTagInt(), new NBTTagFloat(), new NBTTagLong(), new NBTTagDouble(), new NBTTagIntArray(), new NBTTagByteArray(), new NBTTagLongArray(), new NBTTagEnd());
        for (NBTConverter converter : list) {
            NBTTagConverterRegistry.INSTANCE.register(converter);
        }
    }

    private static Class<?> getNBTBaseClass() {
        MinecraftClassHandle base = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.SPIGOT, "NBTBase");
        if (XReflection.SUPPORTED_MAPPINGS.contains(MinecraftMapping.MOJANG)) {
            base.map(MinecraftMapping.MOJANG, "Tag");
        }
        return (Class)base.unreflect();
    }

    @Nullable
    private static Class<?> getNBTClass(NBTTagId type) {
        String typeName = Arrays.stream(type.name().split("_")).map(t -> t.charAt(0) + t.substring(1).toLowerCase()).collect(Collectors.joining(""));
        return (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.MOJANG, typeName + "Tag").map(MinecraftMapping.SPIGOT, "NBTTag" + typeName).reflectOrNull();
    }

    private static final class BukkitNBTCompound
    implements NBTConverter<NBTTagCompound, Object> {
        private static final MethodHandle NBT_TAG_COMPOUND_CONSTRUCTOR;
        private static final MethodHandle GET_COMPOUND_MAP;
        private static final MethodHandle SET_COMPOUND_MAP;

        private BukkitNBTCompound() {
        }

        public static Map<String, Object> getRawMap(Object nbtObject) {
            try {
                return GET_COMPOUND_MAP.invoke(nbtObject);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        @NotNull
        public NBTTagType<NBTTagCompound> getType() {
            return NBTTagType.COMPOUND;
        }

        @Override
        @NotNull
        public NBTTagCompound fromNBT(Object tag) {
            try {
                NBTTagCompound builder = NBTTagCompound.empty();
                Map<String, Object> baseMap = BukkitNBTCompound.getRawMap(tag);
                for (Map.Entry<String, Object> base : baseMap.entrySet()) {
                    NBTConverter<NBTTag<?>, ?> converter = NBTTagConverterRegistry.INSTANCE.get(NBTTagId.fromClassNameOfObject(base.getValue()));
                    builder.set(base.getKey(), converter.fromNBT(Fn.cast(base.getValue())));
                }
                return builder;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull NBTTagCompound tag) {
            try {
                Object compound;
                HashMap map = new HashMap(tag.value().size());
                for (Map.Entry entry : tag.value().entrySet()) {
                    if (entry.getValue() == tag) {
                        throw new IllegalStateException("Recursive NBT");
                    }
                    NBTConverter<NBTTag<?>, ?> converter = NBTTagConverterRegistry.INSTANCE.get(((NBTTag)entry.getValue()).type().id());
                    map.put((String)entry.getKey(), converter.toNBT((NBTTag)entry.getValue()));
                }
                if (XReflection.supports((int)15)) {
                    compound = NBT_TAG_COMPOUND_CONSTRUCTOR.invoke(map);
                } else {
                    compound = NBT_TAG_COMPOUND_CONSTRUCTOR.invoke();
                    SET_COMPOUND_MAP.invoke(compound, map);
                }
                return compound;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class nbtCompound = BukkitNBTAdapter.getNBTClass(NBTTagId.COMPOUND);
            MethodHandle handler = null;
            MethodHandle getMap = null;
            MethodHandle setMap = null;
            try {
                Field field = Reflect.getDeclaredField(nbtCompound, "x", "map");
                field.setAccessible(true);
                getMap = lookup.unreflectGetter(field);
                if (XReflection.supports((int)15)) {
                    Constructor ctor = nbtCompound.getDeclaredConstructor(Map.class);
                    ctor.setAccessible(true);
                    handler = lookup.unreflectConstructor(ctor);
                } else {
                    handler = lookup.findConstructor(nbtCompound, MethodType.methodType(Void.TYPE));
                    setMap = lookup.unreflectSetter(field);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            NBT_TAG_COMPOUND_CONSTRUCTOR = handler;
            GET_COMPOUND_MAP = getMap;
            SET_COMPOUND_MAP = setMap;
        }
    }

    private static final class NBTTagList<T extends NBTTag<?>>
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagList<T>, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle GET_DATA;
        private static final MethodHandle SET_DATA;
        private static final MethodHandle GET_TYPE_ID;

        private NBTTagList() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagList<T>> getType() {
            return NBTTagType.listOf();
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagList<T> fromNBT(Object tag) {
            List nbtList;
            try {
                nbtList = GET_DATA.invoke(tag);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            ArrayList converted = new ArrayList();
            NBTTagType type = null;
            for (Object element : nbtList) {
                if (type == null) {
                    type = NBTTagType.fromId(NBTTagId.fromClassNameOfObject(element));
                }
                converted.add(BukkitAdapter.adapt(type, element));
            }
            return org.kingdoms.nbt.tag.NBTTagList.of(type, converted);
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagList<T> tag) {
            try {
                ArrayList<Object> array = new ArrayList<Object>(tag.value().size());
                Iterator iterator = tag.value().iterator();
                while (iterator.hasNext()) {
                    NBTTag base = (NBTTag)iterator.next();
                    array.add(BukkitAdapter.adapt(base));
                }
                if (XReflection.supports((int)15)) {
                    byte typeId = array.isEmpty() ? (byte)0 : GET_TYPE_ID.invoke(array.get(0));
                    return CONSTRUCTOR.invoke(array, typeId);
                }
                Object nbtList = CONSTRUCTOR.invoke();
                SET_DATA.invoke(nbtList, array);
                return nbtList;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.LIST);
            Class nbtBase = BukkitNBTAdapter.getNBTBaseClass();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle getData = null;
            MethodHandle setData = null;
            MethodHandle getTypeId = null;
            try {
                Field field = Reflect.getDeclaredField(clazz, "c", "list");
                field.setAccessible(true);
                getData = lookup.unreflectGetter(field);
                if (XReflection.supports((int)15)) {
                    Constructor ctor = clazz.getDeclaredConstructor(List.class, Byte.TYPE);
                    ctor.setAccessible(true);
                    handler = lookup.unreflectConstructor(ctor);
                } else {
                    handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
                    setData = lookup.unreflectSetter(field);
                }
                getTypeId = lookup.findVirtual(nbtBase, (String)XReflection.v((int)19, (Object)"b").v(18, (Object)"a").orElse((Object)"getTypeId"), MethodType.methodType(Byte.TYPE));
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            GET_DATA = getData;
            SET_DATA = setData;
            GET_TYPE_ID = getTypeId;
        }
    }

    private static final class NBTTagString
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagString, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagString() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagString> getType() {
            return NBTTagType.STRING;
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagString tag) {
            try {
                return CONSTRUCTOR.invoke(tag.value());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagString fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagString.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.STRING);
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XReflection.supports((int)15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, String.class)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, String.class));
                Field field = Reflect.getDeclaredField(clazz, "A", "data");
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagByte
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagByte, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagByte() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagByte> getType() {
            return NBTTagType.BYTE;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagByte fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagByte.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagByte tag) {
            try {
                return CONSTRUCTOR.invoke(tag.valueAsByte());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.BYTE);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XReflection.supports((int)15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Byte.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Byte.TYPE));
                Field field = Reflect.getDeclaredField(clazz, "x", "data");
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagShort
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagShort, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagShort() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagShort> getType() {
            return NBTTagType.SHORT;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagShort fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagShort.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagShort tag) {
            try {
                return CONSTRUCTOR.invoke(tag.valueAsShort());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.SHORT);
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XReflection.supports((int)15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Short.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Short.TYPE));
                Field field = Reflect.getDeclaredField(clazz, "c", "data");
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagInt
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagInt, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagInt() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagInt> getType() {
            return NBTTagType.INT;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagInt fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagInt.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagInt tag) {
            try {
                return CONSTRUCTOR.invoke(tag.valueAsInt());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.INT);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XReflection.supports((int)15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Integer.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Integer.TYPE));
                Field field = Reflect.getDeclaredField(clazz, "c", "data");
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagFloat
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagFloat, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagFloat() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagFloat> getType() {
            return NBTTagType.FLOAT;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagFloat fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagFloat.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagFloat tag) {
            try {
                return CONSTRUCTOR.invoke(tag.valueAsFloat());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.FLOAT);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XReflection.supports((int)15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Float.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Float.TYPE));
                Field field = Reflect.getDeclaredField(clazz, "w", "data");
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagLong
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagLong, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagLong() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagLong> getType() {
            return NBTTagType.LONG;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagLong fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagLong.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagLong tag) {
            try {
                return CONSTRUCTOR.invoke(tag.valueAsLong());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.LONG);
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XReflection.supports((int)15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Long.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Long.TYPE));
                Field field = Reflect.getDeclaredField(clazz, "c", "data");
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagDouble
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagDouble, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagDouble() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagDouble> getType() {
            return NBTTagType.DOUBLE;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagDouble fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagDouble.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagDouble tag) {
            try {
                return CONSTRUCTOR.invoke(tag.valueAsDouble());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.DOUBLE);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XReflection.supports((int)15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Double.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Double.TYPE));
                Field field = Reflect.getDeclaredField(clazz, "w", "data");
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagIntArray
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagIntArray, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagIntArray() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagIntArray> getType() {
            return NBTTagType.INT_ARRAY;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagIntArray fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagIntArray.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagIntArray tag) {
            try {
                return CONSTRUCTOR.invoke(tag.value());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.INT_ARRAY);
            MethodHandle handler = null;
            MethodHandle data = null;
            if (clazz != null) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                try {
                    handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, int[].class));
                    Field field = Reflect.getDeclaredField(clazz, "c", "data");
                    field.setAccessible(true);
                    data = lookup.unreflectGetter(field);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagByteArray
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagByteArray, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagByteArray() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagByteArray> getType() {
            return NBTTagType.BYTE_ARRAY;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagByteArray fromNBT(Object tag) {
            try {
                return tag == null ? org.kingdoms.nbt.tag.NBTTagByteArray.of(new byte[0]) : org.kingdoms.nbt.tag.NBTTagByteArray.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagByteArray tag) {
            try {
                return CONSTRUCTOR.invoke(tag.value());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.BYTE_ARRAY);
            MethodHandle handler = null;
            MethodHandle data = null;
            if (clazz != null) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                try {
                    handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, byte[].class));
                    Field field = Reflect.getDeclaredField(clazz, "c", "data");
                    field.setAccessible(true);
                    data = lookup.unreflectGetter(field);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagLongArray
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagLongArray, Object> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        private NBTTagLongArray() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagLongArray> getType() {
            return NBTTagType.LONG_ARRAY;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagLongArray fromNBT(Object tag) {
            try {
                return org.kingdoms.nbt.tag.NBTTagLongArray.of(NBT_DATA.invoke(tag));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagLongArray tag) {
            try {
                return CONSTRUCTOR.invoke(tag.value());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            MethodHandle data;
            MethodHandle handler;
            block3: {
                Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.LONG_ARRAY);
                handler = null;
                data = null;
                if (clazz != null) {
                    MethodHandles.Lookup lookup = MethodHandles.lookup();
                    try {
                        handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, long[].class));
                        data = (MethodHandle)XReflection.of((Class)clazz).field("private long[] data;").getter().named(new String[]{"c", "b"}).unreflect();
                    }
                    catch (IllegalAccessException | NoSuchMethodException ex) {
                        if (!XReflection.supports((int)13)) break block3;
                        ex.printStackTrace();
                    }
                }
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    private static final class NBTTagEnd
    implements NBTConverter<org.kingdoms.nbt.tag.NBTTagEnd, Object> {
        private static final Object INSTANCE;

        private NBTTagEnd() {
        }

        @Override
        @NotNull
        public NBTTagType<org.kingdoms.nbt.tag.NBTTagEnd> getType() {
            return NBTTagType.END;
        }

        @Override
        @NotNull
        public org.kingdoms.nbt.tag.NBTTagEnd fromNBT(Object tag) {
            return org.kingdoms.nbt.tag.NBTTagEnd.instance();
        }

        @Override
        public Object toNBT(@NotNull org.kingdoms.nbt.tag.NBTTagEnd tag) {
            return INSTANCE;
        }

        static {
            Object instance;
            block3: {
                Class clazz = BukkitNBTAdapter.getNBTClass(NBTTagId.END);
                instance = null;
                if (clazz != null) {
                    MethodHandles.Lookup lookup = MethodHandles.lookup();
                    try {
                        instance = lookup.findStaticGetter(clazz, "b", clazz).invoke();
                    }
                    catch (Throwable e) {
                        if (!XReflection.supports((int)13)) break block3;
                        e.printStackTrace();
                    }
                }
            }
            INSTANCE = instance;
        }
    }
}

