/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.platform.bukkit.adapters;

import java.awt.Color;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.NBTConverter;
import org.kingdoms.nbt.NBTTagConverterRegistry;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.location.BukkitWorld;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Direction;
import org.kingdoms.server.location.Location;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J1\u0010\u0004\u001a\u0002H\b\"\f\b\u0000\u0010\b*\u0006\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0004\u001a\u00020\u00012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J\u0010\u0010\u0004\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0004\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0004\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0007J\u0018\u0010\u0004\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0007J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0007J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0017H\u0007J\u0010\u0010\u0004\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u0004\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u001bH\u0007\u00a8\u0006\u001f"}, d2={"Lorg/kingdoms/platform/bukkit/adapters/BukkitAdapter;", "", "<init>", "()V", "adapt", "Lorg/bukkit/block/BlockFace;", "direction", "Lorg/kingdoms/server/location/Direction;", "T", "Lorg/kingdoms/nbt/tag/NBTTag;", "type", "Lorg/kingdoms/nbt/tag/NBTTagType;", "nbt", "(Lorg/kingdoms/nbt/tag/NBTTagType;Ljava/lang/Object;)Lorg/kingdoms/nbt/tag/NBTTag;", "Lorg/bukkit/Color;", "color", "Ljava/awt/Color;", "Lorg/kingdoms/server/location/World;", "world", "Lorg/bukkit/World;", "Lorg/bukkit/Location;", "location", "Lorg/kingdoms/server/location/Vector3;", "Lorg/kingdoms/server/location/Location;", "adaptBlockLocation", "Lorg/kingdoms/server/location/BlockLocation3;", "adaptVector", "Lorg/kingdoms/server/location/BlockVector3;", "block", "Lorg/bukkit/block/Block;", "adaptLocation", "bukkit"})
public final class BukkitAdapter {
    @NotNull
    public static final BukkitAdapter INSTANCE = new BukkitAdapter();

    private BukkitAdapter() {
    }

    @JvmStatic
    @NotNull
    public static final BlockFace adapt(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return BlockFace.valueOf((String)direction.name());
    }

    @JvmStatic
    @NotNull
    public static final Direction adapt(@NotNull BlockFace direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return Direction.valueOf(direction.name());
    }

    @JvmStatic
    @NotNull
    public static final <T extends NBTTag<?>> T adapt(@NotNull NBTTagType<T> type, @NotNull Object nbt) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        NBTConverter<NBTTag<?>, ?> nBTConverter = NBTTagConverterRegistry.INSTANCE.get(type.id());
        Intrinsics.checkNotNull(nBTConverter);
        NBTConverter<NBTTag<?>, ?> converter = nBTConverter;
        Object t = Fn.cast(converter.fromNBT(Fn.cast(nbt)));
        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
        return (T)((NBTTag)t);
    }

    @JvmStatic
    @NotNull
    public static final Object adapt(@NotNull NBTTag<?> nbt) {
        Intrinsics.checkNotNullParameter(nbt, (String)"nbt");
        NBTConverter<NBTTag<?>, ?> nBTConverter = NBTTagConverterRegistry.INSTANCE.get(nbt.type().id());
        Intrinsics.checkNotNull(nBTConverter);
        NBTConverter<NBTTag<?>, ?> converter = nBTConverter;
        Object obj = converter.toNBT(nbt);
        Intrinsics.checkNotNull(obj);
        return obj;
    }

    @JvmStatic
    @NotNull
    public static final org.bukkit.Color adapt(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        org.bukkit.Color color2 = org.bukkit.Color.fromARGB((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"fromARGB(...)");
        return color2;
    }

    @JvmStatic
    @NotNull
    public static final org.kingdoms.server.location.World adapt(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new BukkitWorld(world);
    }

    @JvmStatic
    @NotNull
    public static final World adapt(@NotNull org.kingdoms.server.location.World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return ((BukkitWorld)world).getWorld();
    }

    @JvmStatic
    @NotNull
    public static final org.bukkit.Location adapt(@NotNull World world, @NotNull Vector3 location) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new org.bukkit.Location(world, location.getX(), location.getY(), location.getZ());
    }

    @JvmStatic
    @Nullable
    public static final Location adapt(@Nullable org.bukkit.Location location) {
        Location location2;
        org.bukkit.Location location3 = location;
        if (location3 != null) {
            org.bukkit.Location $this$adapt_u24lambda_u240 = location3;
            boolean bl = false;
            World world = $this$adapt_u24lambda_u240.getWorld();
            Intrinsics.checkNotNull((Object)world);
            location2 = new Location(BukkitAdapter.adapt(world), $this$adapt_u24lambda_u240.getX(), $this$adapt_u24lambda_u240.getY(), $this$adapt_u24lambda_u240.getZ(), $this$adapt_u24lambda_u240.getYaw(), $this$adapt_u24lambda_u240.getPitch());
        } else {
            location2 = null;
        }
        return location2;
    }

    @JvmStatic
    @Nullable
    public static final BlockLocation3 adaptBlockLocation(@Nullable org.bukkit.Location location) {
        BlockLocation3 blockLocation3;
        org.bukkit.Location location2 = location;
        if (location2 != null) {
            org.bukkit.Location $this$adaptBlockLocation_u24lambda_u241 = location2;
            boolean bl = false;
            World world = $this$adaptBlockLocation_u24lambda_u241.getWorld();
            Intrinsics.checkNotNull((Object)world);
            blockLocation3 = new BlockLocation3(BukkitAdapter.adapt(world), $this$adaptBlockLocation_u24lambda_u241.getBlockX(), $this$adaptBlockLocation_u24lambda_u241.getBlockY(), $this$adaptBlockLocation_u24lambda_u241.getBlockZ());
        } else {
            blockLocation3 = null;
        }
        return blockLocation3;
    }

    @JvmStatic
    @Nullable
    public static final org.bukkit.Location adapt(@Nullable Location location) {
        org.bukkit.Location location2;
        Location location3 = location;
        if (location3 != null) {
            Location $this$adapt_u24lambda_u242 = location3;
            boolean bl = false;
            location2 = new org.bukkit.Location(BukkitAdapter.adapt($this$adapt_u24lambda_u242.getWorld()), $this$adapt_u24lambda_u242.getX(), $this$adapt_u24lambda_u242.getY(), $this$adapt_u24lambda_u242.getZ(), $this$adapt_u24lambda_u242.getYaw(), $this$adapt_u24lambda_u242.getPitch());
        } else {
            location2 = null;
        }
        return location2;
    }

    @JvmStatic
    @NotNull
    public static final org.bukkit.Location adapt(@NotNull BlockLocation3 location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        BlockLocation3 $this$adapt_u24lambda_u243 = location;
        boolean bl = false;
        return new org.bukkit.Location(BukkitAdapter.adapt($this$adapt_u24lambda_u243.getWorld()), (double)$this$adapt_u24lambda_u243.getX(), (double)$this$adapt_u24lambda_u243.getY(), (double)$this$adapt_u24lambda_u243.getZ(), 0.0f, 0.0f);
    }

    @JvmStatic
    @NotNull
    public static final BlockVector3 adaptVector(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        org.bukkit.Location $this$adaptVector_u24lambda_u244 = block.getLocation();
        boolean bl = false;
        return BlockVector3.Companion.of($this$adaptVector_u24lambda_u244.getBlockX(), $this$adaptVector_u24lambda_u244.getBlockY(), $this$adaptVector_u24lambda_u244.getBlockZ());
    }

    @JvmStatic
    @NotNull
    public static final BlockLocation3 adaptLocation(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        org.bukkit.Location $this$adaptLocation_u24lambda_u245 = block.getLocation();
        boolean bl = false;
        World world = $this$adaptLocation_u24lambda_u245.getWorld();
        Intrinsics.checkNotNull((Object)world);
        return BlockLocation3.Companion.of(BukkitAdapter.adapt(world), $this$adaptLocation_u24lambda_u245.getBlockX(), $this$adaptLocation_u24lambda_u245.getBlockY(), $this$adaptLocation_u24lambda_u245.getBlockZ());
    }

    @JvmStatic
    @NotNull
    public static final org.bukkit.Location adapt(@NotNull World world, @NotNull BlockVector3 location) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new org.bukkit.Location(world, (double)location.getX(), (double)location.getY(), (double)location.getZ());
    }
}

