/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.permissions.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.permissions.Permission;
import org.kingdoms.permissions.registry.BukkitPermissionRegistry;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\bf\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00042\u00020\u0004:\u0001\u0017J\u0015\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00022\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/permissions/registry/PermissionRegistry;", "AbstractPermission", "Lorg/kingdoms/permissions/Permission;", "SystematicPermission", "", "Player", "convert", "permission", "(Lorg/kingdoms/permissions/Permission;)Lorg/kingdoms/permissions/Permission;", "(Ljava/lang/Object;)Lorg/kingdoms/permissions/Permission;", "(Lorg/kingdoms/permissions/Permission;)Ljava/lang/Object;", "register", "", "(Lorg/kingdoms/permissions/Permission;)V", "unregister", "getRegistered", "hasPermission", "", "player", "(Ljava/lang/Object;Lorg/kingdoms/permissions/Permission;)Z", "getAllPermissions", "", "(Ljava/lang/Object;)Ljava/util/List;", "Companion", "core"})
public interface PermissionRegistry<AbstractPermission extends Permission, SystematicPermission, Player> {
    @NotNull
    public static final Companion Companion = org.kingdoms.permissions.registry.PermissionRegistry$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final Map<Class<PermissionRegistry<?, ?, ?>>, PermissionRegistry<?, ?, ?>> REGISTRIES = new HashMap();

    @NotNull
    public AbstractPermission convert(@NotNull Permission var1);

    @NotNull
    public AbstractPermission convert(@NotNull SystematicPermission var1);

    @NotNull
    public SystematicPermission convert(@NotNull AbstractPermission var1);

    public void register(@NotNull AbstractPermission var1);

    public void unregister(@NotNull AbstractPermission var1);

    @Nullable
    public AbstractPermission getRegistered(@NotNull Permission var1);

    public boolean hasPermission(@NotNull Player var1, @NotNull AbstractPermission var2);

    @NotNull
    public List<Permission> getAllPermissions(@NotNull Player var1);

    @JvmStatic
    public static void registerAllRegistries() {
        Companion.registerAllRegistries();
    }

    @JvmStatic
    public static <AbstractPermission extends Permission, SystematicPermission, Player> void registerRegistry(@NotNull PermissionRegistry<AbstractPermission, SystematicPermission, Player> registry) {
        Companion.registerRegistry(registry);
    }

    @JvmStatic
    public static void registerToAllRegistries(@NotNull Permission permission, boolean force) {
        Companion.registerToAllRegistries(permission, force);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J@\u0010\n\u001a\u00020\t\"\b\b\u0003\u0010\u000b*\u00020\f\"\b\b\u0004\u0010\r*\u00020\u0001\"\b\b\u0005\u0010\u000e*\u00020\u00012\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J0\u0010\u0014\u001a\u00020\t\"\b\b\u0003\u0010\u0015*\u00020\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u0002H\u0015\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0002R=\u0010\u0004\u001a,\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/permissions/registry/PermissionRegistry$Companion;", "", "<init>", "()V", "REGISTRIES", "", "Ljava/lang/Class;", "Lorg/kingdoms/permissions/registry/PermissionRegistry;", "registerAllRegistries", "", "registerRegistry", "AbstractPermission", "Lorg/kingdoms/permissions/Permission;", "SystematicPermission", "Player", "registry", "registerToAllRegistries", "permission", "force", "", "register", "T", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        public final void registerAllRegistries() {
            this.registerRegistry(BukkitPermissionRegistry.INSTANCE);
        }

        @JvmStatic
        public final <AbstractPermission extends Permission, SystematicPermission, Player> void registerRegistry(@NotNull PermissionRegistry<AbstractPermission, SystematicPermission, Player> registry) {
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            REGISTRIES.put(registry.getClass(), registry);
        }

        @JvmStatic
        public final void registerToAllRegistries(@NotNull Permission permission, boolean force) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            for (PermissionRegistry<?, ?, ?> registry : REGISTRIES.values()) {
                Object registered = registry.getRegistered(permission);
                if (registered != null) {
                    if (force) {
                        Object t = Fn.cast(registered);
                        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
                        registry.unregister((Permission)t);
                    } else {
                        permission.getSystematicObjects().put((Class<? extends Permission>)registered.getClass(), (Permission)registered);
                        continue;
                    }
                }
                this.register(registry, permission);
            }
        }

        private final <T extends Permission> void register(PermissionRegistry<T, ?, ?> registry, Permission permission) {
            Object abstractPerm = registry.convert((T)permission);
            permission.getSystematicObjects().put((Class<? extends Permission>)abstractPerm.getClass(), (Permission)abstractPerm);
            registry.register(abstractPerm);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

