/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.permissions;

import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.permissions.BukkitPermission;
import org.kingdoms.permissions.KingdomsPluginPermission;
import org.kingdoms.permissions.Permission;
import org.kingdoms.permissions.registry.PermissionRegistry;
import org.kingdoms.server.permission.PermissionDefaultValue;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public enum KingdomsDefaultPluginPermission implements KingdomsPluginPermission
{
    DEBUG,
    UPDATES,
    STRUCTURES_WARPPAD_BYPASS_COUNTDOWN,
    COMMAND_EXTRACTOR_OTHERS,
    COMMAND_INVENTORY_OTHERS,
    COMMAND_CREATE_BYPASS_COST,
    COMMAND_RENAME_BYPASS_COST,
    COMMAND_TAG_BYPASS_COST,
    COMMAND_VAULT_OTHERS,
    COMMAND_PVP_OTHERS,
    COMMAND_SEAK_OTHERS,
    COMMAND_HOME_OTHERS(PermissionDefaultValue.EVERYONE),
    COMMAND_NATION_HOME_OTHERS,
    COMMAND_FLY_OTHERS,
    COMMAND_HOME_BYPASS_TIMER,
    COMMAND_SNEAK_OTHERS,
    COMMAND_TELEPORT_BYPASS_TIMER,
    COMMAND_NATION_HOME_BYPASS_TIMER,
    COMMAND_UPDATES_FORCE,
    COMMAND_UPDATES_DOWNLOAD,
    COMMAND_CLAIM_AUTO_OTHERS,
    COMMAND_UNCLAIM_AUTO_OTHERS,
    PROTECTION$SIGNS_USE(PermissionDefaultValue.EVERYONE),
    PROTECTION$SIGNS_USE_CREATIVE,
    PROTECTION$SIGNS_OPEN,
    PROTECTION$SIGNS_BREAK,
    TELEPORT_TO_CLAIMS,
    CREATIVE_PICKUP,
    INVENTORY_BYPASS,
    NEXUS_REMOVE,
    CHAT_COLORS,
    CHAT_TAG,
    LAND_INTERACT,
    LAND_BUILD_BREAK,
    LAND_BUILD_PLACE,
    LAND_BYPASS_CREATIVE,
    COMMAND_VISUALIZE_DETAILS,
    COMMAND_SHOW_ADMIN,
    COMMAND_SHOW_OTHERS(PermissionDefaultValue.EVERYONE),
    COMMAND_SHOW_SEE_VANISHED,
    COMMAND_NATION_SHOW_OTHERS,
    COMMAND_NATION_SHOW_ADMIN,
    COMMAND_CLAIM_CHUNK(PermissionDefaultValue.EVERYONE),
    COMMAND_CLAIM_LIST_OTHERS,
    COMMAND_UNCLAIM_CHUNK(PermissionDefaultValue.EVERYONE),
    COMMAND_ABOUT_ALL,
    CHAT_BYPASS_RANGED(PermissionDefaultValue.EVERYONE),
    TURRETS_INTERACT,
    TURRETS_BUILD_PLACE,
    TURRETS_BUILD_BREAK,
    STRUCTURES_INTERACT,
    STRUCTURES_BUILD_PLACE,
    STRUCTURES_BUILD_BREAK,
    SHOW_HIDDEN_GROUPS,
    WORLDEDIT_BYPASS_EDIT$PROTECTION,
    FLIGHT_LANDS,
    FLIGHT_DAMAGE,
    FLIGHT_NEARBY$ENEMIES,
    FLIGHT_BYPASS_CHARGES,
    GUIS_BYPASS_CREATIVE,
    SEE_OTHERS_HOLOGRAMS,
    SILENT_JOIN(PermissionDefaultValue.NO_ONE),
    SILENT_LEAVE(PermissionDefaultValue.NO_ONE);

    private final String[] name;
    private final PermissionDefaultValue defaultValue;
    private final Map<Class<? extends Permission>, Permission> systematicObjects = new NonNullMap<Class<? extends Permission>, Permission>();

    private KingdomsDefaultPluginPermission() {
        this(PermissionDefaultValue.OP);
    }

    private KingdomsDefaultPluginPermission(PermissionDefaultValue defaultValue) {
        this.defaultValue = defaultValue;
        this.name = Permission.keyFromEnum(this);
        PermissionRegistry.registerToAllRegistries(this, true);
    }

    public static void init() {
    }

    public boolean hasPermission(CommandSender sender, boolean checkAdminMode) {
        if (sender.hasPermission(this.getSystematicObject(BukkitPermission.class).getSystematicObject())) {
            return true;
        }
        if (!checkAdminMode) {
            return false;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        return KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)sender)).isAdmin();
    }

    public boolean hasPermission(CommandSender sender) {
        return this.hasPermission(sender, false);
    }

    @Override
    @NotNull
    public String[] getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PermissionDefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Map<Class<? extends Permission>, Permission> getSystematicObjects() {
        return this.systematicObjects;
    }
}

