/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagBool;
import org.kingdoms.nbt.tag.NBTTagByte;
import org.kingdoms.nbt.tag.NBTTagByteArray;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagDouble;
import org.kingdoms.nbt.tag.NBTTagEnd;
import org.kingdoms.nbt.tag.NBTTagFloat;
import org.kingdoms.nbt.tag.NBTTagInt;
import org.kingdoms.nbt.tag.NBTTagIntArray;
import org.kingdoms.nbt.tag.NBTTagList;
import org.kingdoms.nbt.tag.NBTTagLong;
import org.kingdoms.nbt.tag.NBTTagLongArray;
import org.kingdoms.nbt.tag.NBTTagShort;
import org.kingdoms.nbt.tag.NBTTagString;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001a*\u000e\b\u0000\u0010\u0001*\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u00020\u0003:\u0001\u001aB3\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0004\u001a\u00020\u0005J\u0017\u0010\u000e\u001a\u00028\u00002\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kingdoms/nbt/tag/NBTTagType;", "T", "Lorg/kingdoms/nbt/tag/NBTTag;", "", "id", "Lorg/kingdoms/nbt/NBTTagId;", "javaType", "Ljava/lang/Class;", "ctor", "Ljava/util/function/Function;", "<init>", "(Lorg/kingdoms/nbt/NBTTagId;Ljava/lang/Class;Ljava/util/function/Function;)V", "name", "", "cast", "tag", "(Lorg/kingdoms/nbt/tag/NBTTag;)Lorg/kingdoms/nbt/tag/NBTTag;", "construct", "obj", "(Ljava/lang/Object;)Lorg/kingdoms/nbt/tag/NBTTag;", "equals", "", "o", "hashCode", "", "toString", "Companion", "nbt"})
@SourceDebugExtension(value={"SMAP\nNBTTagType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NBTTagType.kt\norg/kingdoms/nbt/tag/NBTTagType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,130:1\n1#2:131\n37#3:132\n36#3,3:133\n*S KotlinDebug\n*F\n+ 1 NBTTagType.kt\norg/kingdoms/nbt/tag/NBTTagType\n*L\n110#1:132\n110#1:133,3\n*E\n"})
public final class NBTTagType<T extends NBTTag<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NBTTagId id;
    @NotNull
    private final Class<T> javaType;
    @NotNull
    private final Function<Object, T> ctor;
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagEnd> END = new NBTTagType<NBTTagEnd>(NBTTagId.END, NBTTagEnd.class, NBTTagType::END$lambda$1);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagBool> BOOL = new NBTTagType<NBTTagBool>(NBTTagId.BYTE, NBTTagBool.class, NBTTagType::BOOL$lambda$2);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagByte> BYTE = new NBTTagType<NBTTagByte>(NBTTagId.BYTE, NBTTagByte.class, NBTTagType::BYTE$lambda$3);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagShort> SHORT = new NBTTagType<NBTTagShort>(NBTTagId.SHORT, NBTTagShort.class, NBTTagType::SHORT$lambda$4);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagInt> INT = new NBTTagType<NBTTagInt>(NBTTagId.INT, NBTTagInt.class, NBTTagType::INT$lambda$5);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagLong> LONG = new NBTTagType<NBTTagLong>(NBTTagId.LONG, NBTTagLong.class, NBTTagType::LONG$lambda$6);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagFloat> FLOAT = new NBTTagType<NBTTagFloat>(NBTTagId.FLOAT, NBTTagFloat.class, NBTTagType::FLOAT$lambda$7);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagDouble> DOUBLE = new NBTTagType<NBTTagDouble>(NBTTagId.DOUBLE, NBTTagDouble.class, NBTTagType::DOUBLE$lambda$8);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagByteArray> BYTE_ARRAY = new NBTTagType<NBTTagByteArray>(NBTTagId.BYTE_ARRAY, NBTTagByteArray.class, NBTTagType::BYTE_ARRAY$lambda$9);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagIntArray> INT_ARRAY = new NBTTagType<NBTTagIntArray>(NBTTagId.INT_ARRAY, NBTTagIntArray.class, NBTTagType::INT_ARRAY$lambda$10);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagLongArray> LONG_ARRAY = new NBTTagType<NBTTagLongArray>(NBTTagId.LONG_ARRAY, NBTTagLongArray.class, NBTTagType::LONG_ARRAY$lambda$11);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagString> STRING = new NBTTagType<NBTTagString>(NBTTagId.STRING, NBTTagString.class, NBTTagType::STRING$lambda$12);
    @JvmField
    @NotNull
    public static final NBTTagType<?> LIST = new NBTTagType<NBTTagList>(NBTTagId.LIST, NBTTagList.class, NBTTagType::LIST$lambda$13);
    @JvmField
    @NotNull
    public static final NBTTagType<NBTTagCompound> COMPOUND = new NBTTagType<NBTTagCompound>(NBTTagId.COMPOUND, NBTTagCompound.class, NBTTagType::COMPOUND$lambda$14);
    @NotNull
    private static final Map<Class<?>, NBTTagType<?>> JAVA_TO_NBT;
    @NotNull
    private static final NBTTagType<?>[] TAG_TYPES;

    private NBTTagType(NBTTagId id, Class<T> javaType, Function<Object, T> ctor) {
        this.id = id;
        this.javaType = javaType;
        this.ctor = ctor;
    }

    @NotNull
    public final String name() {
        return this.id.name();
    }

    @NotNull
    public final NBTTagId id() {
        return this.id;
    }

    public final T cast(@NotNull NBTTag<?> tag) {
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        if (!(tag.type() == this)) {
            boolean bl = false;
            String string = "Tag is a " + tag.type().name() + ", not a " + this.name();
            throw new IllegalArgumentException(string.toString());
        }
        return (T)((NBTTag)this.javaType.cast(tag));
    }

    public final T construct(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return (T)((NBTTag)this.ctor.apply(obj));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        NBTTagType that = (NBTTagType)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public String toString() {
        return this.id.toString();
    }

    private static final NBTTagEnd END$lambda$1(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagEnd.instance();
    }

    private static final NBTTagBool BOOL$lambda$2(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagBool.of((Boolean)it);
    }

    private static final NBTTagByte BYTE$lambda$3(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagByte.of((Byte)it);
    }

    private static final NBTTagShort SHORT$lambda$4(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagShort.of((Short)it);
    }

    private static final NBTTagInt INT$lambda$5(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagInt.of((Integer)it);
    }

    private static final NBTTagLong LONG$lambda$6(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagLong.of((Long)it);
    }

    private static final NBTTagFloat FLOAT$lambda$7(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagFloat.of(((Float)it).floatValue());
    }

    private static final NBTTagDouble DOUBLE$lambda$8(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagDouble.of((Double)it);
    }

    private static final NBTTagByteArray BYTE_ARRAY$lambda$9(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        byte[] byArray = (byte[])it;
        return NBTTagByteArray.of(Arrays.copyOf(byArray, byArray.length));
    }

    private static final NBTTagIntArray INT_ARRAY$lambda$10(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int[] nArray = (int[])it;
        return NBTTagIntArray.of(Arrays.copyOf(nArray, nArray.length));
    }

    private static final NBTTagLongArray LONG_ARRAY$lambda$11(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long[] lArray = (long[])it;
        return NBTTagLongArray.of(Arrays.copyOf(lArray, lArray.length));
    }

    private static final NBTTagString STRING$lambda$12(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagString.of((String)it);
    }

    private static final NBTTagList LIST$lambda$13(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagList.ofUnknown((List)it);
    }

    private static final NBTTagCompound COMPOUND$lambda$14(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NBTTagCompound.of((Map)Companion.castAs((Map)it));
    }

    private static final NBTTagId TAG_TYPES$lambda$15(NBTTagType obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.id();
    }

    private static final NBTTagId TAG_TYPES$lambda$16(Function1 $tmp0, Object p0) {
        return (NBTTagId)((Object)$tmp0.invoke(p0));
    }

    @JvmStatic
    public static final <T> T castAs(@NotNull Object obj) {
        return Companion.castAs(obj);
    }

    @JvmStatic
    @NotNull
    public static final <T extends NBTTag<?>> NBTTagType<NBTTagList<T>> listOf() {
        return Companion.listOf();
    }

    @JvmStatic
    @NotNull
    public static final <T extends NBTTag<?>> NBTTagType<T> fromId(@NotNull NBTTagId id) {
        return Companion.fromId(id);
    }

    @JvmStatic
    @NotNull
    public static final NBTTagType<?> fromJava(@NotNull Object obj) {
        return Companion.fromJava(obj);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to(Short.TYPE, SHORT), TuplesKt.to(Byte.TYPE, BYTE), TuplesKt.to(Integer.class, INT), TuplesKt.to(Long.TYPE, LONG), TuplesKt.to(Float.TYPE, FLOAT), TuplesKt.to(Double.TYPE, DOUBLE), TuplesKt.to(byte[].class, BYTE_ARRAY), TuplesKt.to(int[].class, INT_ARRAY), TuplesKt.to(long[].class, LONG_ARRAY), TuplesKt.to(Boolean.TYPE, BOOL), TuplesKt.to(NBTTagCompound.class, COMPOUND), TuplesKt.to(Collection.class, LIST)};
        JAVA_TO_NBT = MapsKt.hashMapOf((Pair[])objectArray);
        objectArray = new NBTTagType[]{END, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, BYTE_ARRAY, STRING, LIST, COMPOUND, INT_ARRAY, LONG_ARRAY};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> NBTTagType.TAG_TYPES$lambda$16(NBTTagType::TAG_TYPES$lambda$15, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TAG_TYPES = thisCollection$iv.toArray(new NBTTagType[0]);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0007J$\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050%0\t\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0002\b\u0003\u0018\u00010&H\u0007J&\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0002\b\u0003\u0018\u00010&2\u0006\u00100\u001a\u000201H\u0007J\u0014\u00102\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0006\u001a\u00020\u0001H\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u0006\u0012\u0002\b\u00030\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R*\u0010'\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0(8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010\u0003R\"\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0,8\u0002X\u0083\u0004\u00a2\u0006\n\n\u0002\u0010.\u0012\u0004\b-\u0010\u0003\u00a8\u00063"}, d2={"Lorg/kingdoms/nbt/tag/NBTTagType$Companion;", "", "<init>", "()V", "castAs", "T", "obj", "(Ljava/lang/Object;)Ljava/lang/Object;", "END", "Lorg/kingdoms/nbt/tag/NBTTagType;", "Lorg/kingdoms/nbt/tag/NBTTagEnd;", "BOOL", "Lorg/kingdoms/nbt/tag/NBTTagBool;", "BYTE", "Lorg/kingdoms/nbt/tag/NBTTagByte;", "SHORT", "Lorg/kingdoms/nbt/tag/NBTTagShort;", "INT", "Lorg/kingdoms/nbt/tag/NBTTagInt;", "LONG", "Lorg/kingdoms/nbt/tag/NBTTagLong;", "FLOAT", "Lorg/kingdoms/nbt/tag/NBTTagFloat;", "DOUBLE", "Lorg/kingdoms/nbt/tag/NBTTagDouble;", "BYTE_ARRAY", "Lorg/kingdoms/nbt/tag/NBTTagByteArray;", "INT_ARRAY", "Lorg/kingdoms/nbt/tag/NBTTagIntArray;", "LONG_ARRAY", "Lorg/kingdoms/nbt/tag/NBTTagLongArray;", "STRING", "Lorg/kingdoms/nbt/tag/NBTTagString;", "LIST", "COMPOUND", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "listOf", "Lorg/kingdoms/nbt/tag/NBTTagList;", "Lorg/kingdoms/nbt/tag/NBTTag;", "JAVA_TO_NBT", "", "Ljava/lang/Class;", "getJAVA_TO_NBT$annotations", "TAG_TYPES", "", "getTAG_TYPES$annotations", "[Lorg/kingdoms/nbt/tag/NBTTagType;", "fromId", "id", "Lorg/kingdoms/nbt/NBTTagId;", "fromJava", "nbt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final <T> T castAs(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return (T)obj;
        }

        @JvmStatic
        @NotNull
        public final <T extends NBTTag<?>> NBTTagType<NBTTagList<T>> listOf() {
            NBTTagType<NBTTagList<T>> nBTTagType = LIST;
            Intrinsics.checkNotNull(nBTTagType, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagType<org.kingdoms.nbt.tag.NBTTagList<T of org.kingdoms.nbt.tag.NBTTagType.Companion.listOf>>");
            return nBTTagType;
        }

        @JvmStatic
        private static /* synthetic */ void getJAVA_TO_NBT$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getTAG_TYPES$annotations() {
        }

        @JvmStatic
        @NotNull
        public final <T extends NBTTag<?>> NBTTagType<T> fromId(@NotNull NBTTagId id) {
            Intrinsics.checkNotNullParameter((Object)((Object)id), (String)"id");
            NBTTagType nBTTagType = TAG_TYPES[id.id()];
            Intrinsics.checkNotNull((Object)nBTTagType, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagType<T of org.kingdoms.nbt.tag.NBTTagType.Companion.fromId>");
            return nBTTagType;
        }

        @JvmStatic
        @NotNull
        public final NBTTagType<?> fromJava(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            NBTTagType nBTTagType = (NBTTagType)JAVA_TO_NBT.get(obj.getClass());
            if (nBTTagType == null) {
                throw new IllegalArgumentException("No NBT type could be detected for object: " + obj + " (" + obj.getClass());
            }
            return nBTTagType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

