/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.util.Objects;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagType;

public class NBTTagString
extends NBTTag<String> {
    private String value;

    @NotNull
    public static NBTTagString of(@NotNull String value) {
        return new NBTTagString(value);
    }

    private NBTTagString(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @Override
    @NotNull
    public NBTTagType<NBTTagString> type() {
        return NBTTagType.STRING;
    }

    @Override
    @NotNull
    public String value() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return NBTStream.of((NBTToken)new NBTToken.String(this.value));
    }
}

