/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.exception.NBTParseException;
import org.kingdoms.nbt.stream.internal.SurroundingNBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTRootEntry;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagByte;
import org.kingdoms.nbt.tag.NBTTagByteArray;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagDouble;
import org.kingdoms.nbt.tag.NBTTagFloat;
import org.kingdoms.nbt.tag.NBTTagInt;
import org.kingdoms.nbt.tag.NBTTagIntArray;
import org.kingdoms.nbt.tag.NBTTagList;
import org.kingdoms.nbt.tag.NBTTagLong;
import org.kingdoms.nbt.tag.NBTTagLongArray;
import org.kingdoms.nbt.tag.NBTTagShort;
import org.kingdoms.nbt.tag.NBTTagString;
import org.kingdoms.nbt.tag.NBTTagType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\u000e\b\u0000\u0010\u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J5\u0010\u0014\u001a\u0002H\u0012\"\u000e\b\u0000\u0010\u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\u0012\u0018\u00010\u0016H\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/nbt/tag/NBTTagReader;", "", "<init>", "()V", "readRoot", "Lorg/kingdoms/nbt/tag/NBTRootEntry;", "tokens", "Lorg/kingdoms/nbt/stream/NBTStream;", "readCompound", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "readByteArray", "Lorg/kingdoms/nbt/tag/NBTTagByteArray;", "readIntArray", "Lorg/kingdoms/nbt/tag/NBTTagIntArray;", "readLongArray", "Lorg/kingdoms/nbt/tag/NBTTagLongArray;", "readList", "Lorg/kingdoms/nbt/tag/NBTTagList;", "T", "Lorg/kingdoms/nbt/tag/NBTTag;", "readValue", "id", "Lorg/kingdoms/nbt/tag/NBTTagType;", "(Lorg/kingdoms/nbt/stream/NBTStream;Lorg/kingdoms/nbt/tag/NBTTagType;)Lorg/kingdoms/nbt/tag/NBTTag;", "requireNextToken", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "nbt"})
public final class NBTTagReader {
    @NotNull
    public static final NBTTagReader INSTANCE = new NBTTagReader();

    private NBTTagReader() {
    }

    @JvmStatic
    @NotNull
    public static final NBTRootEntry readRoot(@NotNull NBTStream tokens) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        NBTStream tokens2 = tokens;
        tokens2 = tokens2.calculateOptionalInfo();
        NBTToken name = tokens2.nextOrNull();
        if (!(name instanceof NBTToken.Name)) {
            throw new NBTParseException("Expected root name");
        }
        if (((NBTToken.Name)name).getId().orElseThrow(NBTTagReader::readRoot$lambda$0) != NBTTagId.COMPOUND) {
            throw new NBTParseException("Expected compound tag for root tag");
        }
        NBTTagCompound tag = NBTTagReader.readCompound(tokens2);
        return new NBTRootEntry(((NBTToken.Name)name).getName(), tag);
    }

    @JvmStatic
    @NotNull
    public static final NBTTagCompound readCompound(@NotNull NBTStream tokens) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        NBTStream tokens2 = tokens.calculateOptionalInfo();
        if (!(tokens2.nextOrNull() instanceof NBTToken.CompoundStart)) {
            throw new NBTParseException("Expected compound start");
        }
        NBTTagCompound nBTTagCompound = NBTTagCompound.empty();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"empty(...)");
        NBTTagCompound builder = nBTTagCompound;
        while (tokens2.nextOrNull() != null) {
            Object value;
            NBTToken token;
            if (token instanceof NBTToken.CompoundEnd) {
                return builder;
            }
            if (!(token instanceof NBTToken.Name)) {
                throw new NBTParseException("Expected name, got " + token);
            }
            Intrinsics.checkNotNull((Object)tokens2);
            Intrinsics.checkNotNull(NBTTagReader.readValue(tokens2, ((NBTToken.Name)token).getId().map(arg_0 -> NBTTagReader.readCompound$lambda$2(NBTTagReader::readCompound$lambda$1, arg_0)).orElse(null)));
            builder.set(((NBTToken.Name)token).getName(), value);
        }
        throw new NBTParseException("Expected compound end");
    }

    @JvmStatic
    private static final NBTTagByteArray readByteArray(NBTStream tokens) throws IOException {
        NBTToken start = tokens.nextOrNull();
        if (!(start instanceof NBTToken.ByteArrayStart)) {
            throw new NBTParseException("Expected byte array start");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(((NBTToken.ByteArrayStart)start).getSize().orElseThrow(NBTTagReader::readByteArray$lambda$3));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        ByteBuffer buffer = byteBuffer;
        while (tokens.nextOrNull() != null) {
            NBTToken token;
            if (token instanceof NBTToken.ByteArrayEnd) {
                if (buffer.hasRemaining()) {
                    throw new NBTParseException("Not all bytes received");
                }
                byte[] byArray = buffer.array();
                NBTTagByteArray nBTTagByteArray = NBTTagByteArray.of(Arrays.copyOf(byArray, byArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagByteArray, (String)"of(...)");
                return nBTTagByteArray;
            }
            if (!(token instanceof NBTToken.ByteArrayContent)) {
                throw new NBTParseException("Expected byte array content, got " + token);
            }
            buffer.put(((NBTToken.ByteArrayContent)token).getBuffer());
        }
        throw new NBTParseException("Expected byte array end");
    }

    @JvmStatic
    private static final NBTTagIntArray readIntArray(NBTStream tokens) throws IOException {
        NBTToken start = tokens.nextOrNull();
        if (!(start instanceof NBTToken.IntArrayStart)) {
            throw new NBTParseException("Expected int array start");
        }
        IntBuffer buffer = IntBuffer.allocate(((NBTToken.IntArrayStart)start).getSize().orElseThrow(NBTTagReader::readIntArray$lambda$4));
        while (tokens.nextOrNull() != null) {
            NBTToken token;
            if (token instanceof NBTToken.IntArrayEnd) {
                if (buffer.hasRemaining()) {
                    throw new NBTParseException("Not all ints received");
                }
                int[] nArray = buffer.array();
                NBTTagIntArray nBTTagIntArray = NBTTagIntArray.of(Arrays.copyOf(nArray, nArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagIntArray, (String)"of(...)");
                return nBTTagIntArray;
            }
            if (!(token instanceof NBTToken.IntArrayContent)) {
                throw new NBTParseException("Expected int array content, got " + token);
            }
            buffer.put(((NBTToken.IntArrayContent)token).getBuffer());
        }
        throw new NBTParseException("Expected int array end");
    }

    @JvmStatic
    private static final NBTTagLongArray readLongArray(NBTStream tokens) throws IOException {
        NBTToken start = tokens.nextOrNull();
        if (!(start instanceof NBTToken.LongArrayStart)) {
            throw new NBTParseException("Expected long array start");
        }
        LongBuffer buffer = LongBuffer.allocate(((NBTToken.LongArrayStart)start).getSize().orElseThrow(NBTTagReader::readLongArray$lambda$5));
        while (tokens.nextOrNull() != null) {
            NBTToken token;
            if (token instanceof NBTToken.LongArrayEnd) {
                if (buffer.hasRemaining()) {
                    throw new NBTParseException("Not all longs received");
                }
                long[] lArray = buffer.array();
                NBTTagLongArray nBTTagLongArray = NBTTagLongArray.of(Arrays.copyOf(lArray, lArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagLongArray, (String)"of(...)");
                return nBTTagLongArray;
            }
            if (!(token instanceof NBTToken.LongArrayContent)) {
                throw new NBTParseException("Expected long array content, got " + token);
            }
            buffer.put(((NBTToken.LongArrayContent)token).getBuffer());
        }
        throw new NBTParseException("Expected long array end");
    }

    @JvmStatic
    private static final <T extends NBTTag<?>> NBTTagList<T> readList(NBTStream tokens) throws IOException {
        NBTToken start = tokens.nextOrNull();
        if (!(start instanceof NBTToken.ListStart)) {
            throw new NBTParseException("Expected list start");
        }
        NBTTagId nBTTagId = ((NBTToken.ListStart)start).getElementId().orElseThrow(NBTTagReader::readList$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)nBTTagId), (String)"orElseThrow(...)");
        NBTTagType elementType = NBTTagType.Companion.fromId(nBTTagId);
        NBTTagList nBTTagList = NBTTagList.empty(elementType);
        Intrinsics.checkNotNullExpressionValue(nBTTagList, (String)"empty(...)");
        NBTTagList builder = nBTTagList;
        int n = ((NBTToken.ListStart)start).getSize().orElseThrow(NBTTagReader::readList$lambda$7);
        for (int i = 0; i < n; ++i) {
            Object tag = NBTTagReader.readValue(tokens, elementType);
            builder.add(tag);
        }
        if (!(tokens.nextOrNull() instanceof NBTToken.ListEnd)) {
            throw new NBTParseException("Expected list end");
        }
        return builder;
    }

    @JvmStatic
    private static final <T extends NBTTag<?>> T readValue(NBTStream tokens, NBTTagType<T> id) throws IOException {
        NBTTag nBTTag;
        NBTStream tokens2 = tokens;
        NBTTagType<T> id2 = id;
        if (id2 == null) {
            NBTToken nBTToken = tokens2.nextOrNull();
            if (nBTToken == null) {
                throw new NBTParseException("Expected value, got end of stream");
            }
            NBTToken next = nBTToken;
            NBTTagId nBTTagId = next.getTagId();
            Intrinsics.checkNotNull((Object)((Object)nBTTagId));
            id2 = NBTTagType.Companion.fromId(nBTTagId);
            tokens2 = new SurroundingNBTStream(next, tokens2, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[id2.id().ordinal()]) {
            case 1: {
                nBTTag = NBTTagReader.readByteArray(tokens2);
                break;
            }
            case 2: {
                NBTToken nBTToken = NBTTagReader.requireNextToken(tokens2);
                Intrinsics.checkNotNull((Object)nBTToken, (String)"null cannot be cast to non-null type org.kingdoms.nbt.stream.token.NBTToken.Byte");
                NBTTagByte nBTTagByte = NBTTagByte.of(((NBTToken.Byte)nBTToken).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagByte, (String)"of(...)");
                nBTTag = nBTTagByte;
                break;
            }
            case 3: {
                nBTTag = NBTTagReader.readCompound(tokens2);
                break;
            }
            case 4: {
                NBTToken nBTToken = NBTTagReader.requireNextToken(tokens2);
                Intrinsics.checkNotNull((Object)nBTToken, (String)"null cannot be cast to non-null type org.kingdoms.nbt.stream.token.NBTToken.Double");
                NBTTagDouble nBTTagDouble = NBTTagDouble.of(((NBTToken.Double)nBTToken).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagDouble, (String)"of(...)");
                nBTTag = nBTTagDouble;
                break;
            }
            case 5: {
                throw new NBTParseException("Unexpected END id");
            }
            case 6: {
                NBTToken nBTToken = NBTTagReader.requireNextToken(tokens2);
                Intrinsics.checkNotNull((Object)nBTToken, (String)"null cannot be cast to non-null type org.kingdoms.nbt.stream.token.NBTToken.Float");
                NBTTagFloat nBTTagFloat = NBTTagFloat.of(((NBTToken.Float)nBTToken).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagFloat, (String)"of(...)");
                nBTTag = nBTTagFloat;
                break;
            }
            case 7: {
                nBTTag = NBTTagReader.readIntArray(tokens2);
                break;
            }
            case 8: {
                NBTToken nBTToken = NBTTagReader.requireNextToken(tokens2);
                Intrinsics.checkNotNull((Object)nBTToken, (String)"null cannot be cast to non-null type org.kingdoms.nbt.stream.token.NBTToken.Int");
                NBTTagInt nBTTagInt = NBTTagInt.of(((NBTToken.Int)nBTToken).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagInt, (String)"of(...)");
                nBTTag = nBTTagInt;
                break;
            }
            case 9: {
                nBTTag = NBTTagReader.readList(tokens2);
                break;
            }
            case 10: {
                nBTTag = NBTTagReader.readLongArray(tokens2);
                break;
            }
            case 11: {
                NBTToken nBTToken = NBTTagReader.requireNextToken(tokens2);
                Intrinsics.checkNotNull((Object)nBTToken, (String)"null cannot be cast to non-null type org.kingdoms.nbt.stream.token.NBTToken.Long");
                NBTTagLong nBTTagLong = NBTTagLong.of(((NBTToken.Long)nBTToken).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagLong, (String)"of(...)");
                nBTTag = nBTTagLong;
                break;
            }
            case 12: {
                NBTToken nBTToken = NBTTagReader.requireNextToken(tokens2);
                Intrinsics.checkNotNull((Object)nBTToken, (String)"null cannot be cast to non-null type org.kingdoms.nbt.stream.token.NBTToken.Short");
                NBTTagShort nBTTagShort = NBTTagShort.of(((NBTToken.Short)nBTToken).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagShort, (String)"of(...)");
                nBTTag = nBTTagShort;
                break;
            }
            case 13: {
                NBTToken nBTToken = NBTTagReader.requireNextToken(tokens2);
                Intrinsics.checkNotNull((Object)nBTToken, (String)"null cannot be cast to non-null type org.kingdoms.nbt.stream.token.NBTToken.String");
                NBTTagString nBTTagString = NBTTagString.of(((NBTToken.String)nBTToken).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagString, (String)"of(...)");
                nBTTag = nBTTagString;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return id2.cast(nBTTag);
    }

    @JvmStatic
    private static final NBTToken requireNextToken(NBTStream tokens) throws IOException {
        NBTToken nBTToken = tokens.nextOrNull();
        if (nBTToken == null) {
            throw new NBTParseException("Unexpected end of stream");
        }
        NBTToken linToken = nBTToken;
        return linToken;
    }

    private static final NullPointerException readRoot$lambda$0() {
        return new NullPointerException();
    }

    private static final NBTTagType readCompound$lambda$1(NBTTagId it) {
        Intrinsics.checkNotNull((Object)((Object)it));
        return NBTTagType.Companion.fromId(it);
    }

    private static final NBTTagType readCompound$lambda$2(Function1 $tmp0, Object p0) {
        return (NBTTagType)$tmp0.invoke(p0);
    }

    private static final NullPointerException readByteArray$lambda$3() {
        return new NullPointerException();
    }

    private static final NullPointerException readIntArray$lambda$4() {
        return new NullPointerException();
    }

    private static final NullPointerException readLongArray$lambda$5() {
        return new NullPointerException();
    }

    private static final NullPointerException readList$lambda$6() {
        return new NullPointerException();
    }

    private static final NullPointerException readList$lambda$7() {
        return new NullPointerException();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NBTTagId.values().length];
            try {
                nArray[NBTTagId.BYTE_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.COMPOUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.END.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.INT_ARRAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.INT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LIST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LONG_ARRAY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LONG.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.SHORT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.STRING.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

