/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.kingdoms.libs.jetbrains.annotations.Contract;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.internal.FlatteningNBTStream;
import org.kingdoms.nbt.stream.internal.SurroundingNBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagType;

public final class NBTTagList<T extends NBTTag<?>>
extends NBTTag<List<T>> {
    @Nullable
    private NBTTagType<T> elementType;
    private List<T> value;

    @NotNull
    public static <T extends NBTTag<?>> NBTTagList<T> of(@NotNull NBTTagType<T> elementType, @NotNull List<T> value) {
        for (NBTTag t : value) {
            if (t.type() == elementType) continue;
            throw new IllegalArgumentException("Element is not of type " + elementType.name() + " but " + t.type().name());
        }
        return new NBTTagList<T>(elementType, new ArrayList<T>(value));
    }

    @NotNull
    public static NBTTagList<?> ofUnknown(@NotNull List<? extends NBTTag<?>> value) {
        NBTTagType<NBTTag<?>> elementType = null;
        for (NBTTag<?> t : value) {
            if (elementType == null) {
                elementType = t.type();
                continue;
            }
            if (t.type() == elementType) continue;
            throw new IllegalArgumentException("Element is not of type " + elementType.name() + " but " + t.type().name());
        }
        return new NBTTagList(elementType, (List)NBTTagType.castAs(new ArrayList(value)));
    }

    @NotNull
    public static <T extends NBTTag<?>> NBTTagList<T> empty(@NotNull NBTTagType<T> elementType) {
        return new NBTTagList<T>(elementType, new ArrayList());
    }

    @NotNull
    public static NBTTagList<?> unknownEmpty() {
        return new NBTTagList(null, new ArrayList());
    }

    @Contract(value="_ -> this")
    @NotNull
    public NBTTagList<T> add(T tag) {
        if (this.elementType != null) {
            if (((NBTTag)tag).type() != this.elementType) {
                throw new IllegalArgumentException("Element is not of type " + this.elementType.name() + " but " + ((NBTTag)tag).type().name());
            }
        } else {
            this.elementType = ((NBTTag)tag).type();
        }
        this.value.add(tag);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public NBTTagList<T> addUnknown(NBTTag<?> tag) {
        return this.add(tag);
    }

    @Contract(value="_ -> this")
    @NotNull
    public NBTTagList<T> addAll(@NotNull Collection<? extends T> tags) {
        tags.forEach(this::add);
        return this;
    }

    private NBTTagList(NBTTagType<T> elementType, List<T> value) {
        Objects.requireNonNull(value, "value is null");
        if (!value.isEmpty() && elementType == NBTTagType.END) {
            throw new IllegalArgumentException("A non-empty list cannot be of type END");
        }
        this.elementType = elementType;
        this.value = value;
    }

    @Override
    @NotNull
    public NBTTagType<NBTTagList<T>> type() {
        return NBTTagType.listOf();
    }

    @NotNull
    public NBTTagType<T> elementType() {
        return this.elementType;
    }

    public <U extends NBTTag<?>> NBTTagList<U> asTypeChecked(@NotNull NBTTagType<U> elementType) {
        if (elementType != this.elementType) {
            throw new IllegalStateException("List is of type " + this.elementType.name() + ", not " + elementType.name());
        }
        NBTTagList cast = this;
        return cast;
    }

    @Override
    @NotNull
    public List<T> value() {
        return this.value;
    }

    @Override
    public void setValue(List<T> value) {
        if (!value.isEmpty() && ((NBTTag)value.get(0)).type() != this.elementType) {
            throw new IllegalArgumentException("Type mismatch, expected " + this.elementType + " but got: " + ((NBTTag)value.get(0)).type());
        }
        this.value = value;
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return new SurroundingNBTStream(new NBTToken.ListStart(OptionalInt.of(this.value.size()), Optional.of(this.elementType.id())), new FlatteningNBTStream(this.value.iterator()), new NBTToken.ListEnd());
    }

    public T get(int index) {
        return (T)((NBTTag)this.value.get(index));
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + this.value;
    }
}

