/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.OptionalInt;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.internal.SurroundingNBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagType;

public final class NBTTagIntArray
extends NBTTag<int[]> {
    private int[] value;

    @NotNull
    public static NBTTagIntArray of(int ... value) {
        return new NBTTagIntArray((int[])value.clone());
    }

    private NBTTagIntArray(int[] value) {
        this.value = value;
    }

    @Override
    public void setValue(int[] value) {
        this.value = value;
    }

    @Override
    @NotNull
    public NBTTagType<NBTTagIntArray> type() {
        return NBTTagType.INT_ARRAY;
    }

    @Override
    public int[] value() {
        return (int[])this.value.clone();
    }

    public IntBuffer view() {
        return IntBuffer.wrap(this.value).asReadOnlyBuffer();
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return new SurroundingNBTStream(new NBTToken.IntArrayStart(OptionalInt.of(this.value.length)), new NBTStream(){
            private static final int BUFFER_SIZE = 4096;
            private int i = 0;

            @Override
            @Nullable
            public NBTToken nextOrNull() {
                if (this.i >= NBTTagIntArray.this.value.length) {
                    return null;
                }
                int length = Math.min(4096, NBTTagIntArray.this.value.length - this.i);
                IntBuffer buffer = IntBuffer.wrap(NBTTagIntArray.this.value, this.i, length).asReadOnlyBuffer();
                this.i += length;
                return new NBTToken.IntArrayContent(buffer);
            }
        }, new NBTToken.IntArrayEnd());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTTagIntArray that = (NBTTagIntArray)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.value());
    }
}

