/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.kingdoms.libs.jetbrains.annotations.Contract;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.NBTStreamable;
import org.kingdoms.nbt.stream.internal.FlatteningNBTStream;
import org.kingdoms.nbt.stream.internal.SurroundingNBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagBool;
import org.kingdoms.nbt.tag.NBTTagByte;
import org.kingdoms.nbt.tag.NBTTagByteArray;
import org.kingdoms.nbt.tag.NBTTagDouble;
import org.kingdoms.nbt.tag.NBTTagFloat;
import org.kingdoms.nbt.tag.NBTTagInt;
import org.kingdoms.nbt.tag.NBTTagIntArray;
import org.kingdoms.nbt.tag.NBTTagList;
import org.kingdoms.nbt.tag.NBTTagLong;
import org.kingdoms.nbt.tag.NBTTagLongArray;
import org.kingdoms.nbt.tag.NBTTagReader;
import org.kingdoms.nbt.tag.NBTTagShort;
import org.kingdoms.nbt.tag.NBTTagString;
import org.kingdoms.nbt.tag.NBTTagType;

public final class NBTTagCompound
extends NBTTag<Map<String, ? extends NBTTag<?>>> {
    private Map<String, ? extends NBTTag<?>> value;

    @NotNull
    public static NBTTagCompound of(@NotNull Map<String, ? extends NBTTag<?>> value) {
        return new NBTTagCompound(value, true);
    }

    @NotNull
    public static NBTTagCompound empty() {
        return new NBTTagCompound(new LinkedHashMap(), false);
    }

    public NBTTagCompound(@NotNull Map<String, ? extends NBTTag<?>> value, boolean check) {
        if (check) {
            for (NBTTag<?> tag : value.values()) {
                if (tag.type().id() != NBTTagId.END) continue;
                throw new IllegalArgumentException("Cannot add END tag to compound tag");
            }
        }
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public <T> PropertyRef<T> createReference(String name, NBTTag<T> tag, boolean set) {
        PropertyRef<T> ref = new PropertyRef<T>(name, tag);
        if (set) {
            ref.set(tag.value());
        }
        return ref;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public <T extends NBTTag<?>> NBTTagCompound set(@NotNull String name, T value) {
        if (value.type().id() == NBTTagId.END) {
            throw new IllegalArgumentException("Cannot add END tag to compound tag");
        }
        this.value.put(name, (NBTTag)NBTTagType.castAs(value));
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public NBTTagCompound putAll(@NotNull Map<String, ? extends NBTTag<?>> map) {
        map.forEach(this::set);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public NBTTagCompound remove(@NotNull String name) {
        this.value.remove(name);
        return this;
    }

    public boolean has(@NotNull String name) {
        return this.value.containsKey(name);
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, byte[] value) {
        return this.set(name, NBTTagByteArray.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, byte value) {
        return this.set(name, NBTTagByte.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, double value) {
        return this.set(name, NBTTagDouble.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, float value) {
        return this.set(name, NBTTagFloat.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, int[] value) {
        return this.set(name, NBTTagIntArray.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, int value) {
        return this.set(name, NBTTagInt.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, boolean value) {
        return this.set(name, NBTTagBool.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, long[] value) {
        return this.set(name, NBTTagLongArray.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, long value) {
        return this.set(name, NBTTagLong.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, short value) {
        return this.set(name, NBTTagShort.of(value));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public NBTTagCompound set(@NotNull String name, String value) {
        return this.set(name, NBTTagString.of(value));
    }

    @NotNull
    public static NBTTagCompound readFrom(@NotNull NBTStream tokens) throws IOException {
        return NBTTagReader.readCompound(tokens);
    }

    @Override
    @NotNull
    public NBTTagType<NBTTagCompound> type() {
        return NBTTagType.COMPOUND;
    }

    @Override
    @NotNull
    public Map<String, ? extends NBTTag<?>> value() {
        return this.value;
    }

    @Override
    public void setValue(Map<String, ? extends NBTTag<?>> value) {
        this.value = value;
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return new SurroundingNBTStream(new NBTToken.CompoundStart(), new FlatteningNBTStream(new EntryTokenIterator()), new NBTToken.CompoundEnd());
    }

    @Nullable
    public <T extends NBTTag<?>> T tryGetTag(@NotNull String name, NBTTagType<T> type) {
        NBTTag<?> tag = this.value.get(name);
        return tag != null && type == tag.type() ? (T)type.cast(tag) : null;
    }

    @Nullable
    public <T extends NBTTag<?>> NBTTagList<T> tryGetListTag(@NotNull String name, NBTTagType<T> elementType) {
        NBTTagList listTag = this.tryGetTag(name, NBTTagType.listOf());
        if (listTag == null || listTag.elementType() != elementType) {
            return null;
        }
        NBTTagList cast = listTag;
        return cast;
    }

    private <T> T get(String name) {
        NBTTag<?> tag = this.value.get(name);
        if (tag == null) {
            return null;
        }
        try {
            return (T)tag.value();
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public NBTTagCompound getCompound(String name) {
        return this.tryGetTag(name, NBTTagType.COMPOUND);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public <T, Tag extends NBTTag<T>> T get(String name, NBTTagType<Tag> type) {
        Tag tag = this.tryGetTag(name, type);
        if (tag == null) {
            return null;
        }
        return ((NBTTag)tag).value();
    }

    @NotNull
    public <T extends NBTTag<?>> T getTag(@NotNull String name, NBTTagType<T> type) {
        NBTTag<?> tag = this.value.get(name);
        if (tag == null) {
            throw new NoSuchElementException("No tag under the name '" + name + "' exists");
        }
        if (type != tag.type()) {
            throw new IllegalStateException("Tag under '" + name + "' exists, but is a " + tag.type().name() + " instead of " + type.name());
        }
        return type.cast(tag);
    }

    @NotNull
    public <T extends NBTTag<?>> NBTTagList<T> getListTag(@NotNull String name, NBTTagType<T> elementType) {
        NBTTagList listTag = this.getTag(name, NBTTagType.listOf());
        if (listTag.elementType() != elementType) {
            throw new IllegalStateException("Tag under '" + name + "' exists, but is a " + listTag.elementType().name() + " list instead of a " + elementType.name() + " list");
        }
        NBTTagList cast = listTag;
        return cast;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + this.value;
    }

    public final class PropertyRef<T> {
        private final String name;
        private final NBTTag<T> tag;
        private final T defaultValue;
        private boolean removed = true;

        private PropertyRef(String name, NBTTag<T> tag) {
            this.name = name;
            this.tag = tag;
            this.defaultValue = tag.value();
        }

        private void ensureState() {
            NBTTag<T> currentTag = NBTTagCompound.this.tryGetTag(this.name, this.tag.type());
            if (this.tag != currentTag) {
                throw new ConcurrentModificationException("Tag '" + this.name + "' was changed unexpectedly: " + this.tag.value() + " -> " + currentTag);
            }
        }

        public void set(@Nullable T value) {
            if (value == null) {
                this.remove();
            } else {
                this.tag.setValue(value);
                if (this.removed) {
                    NBTTagCompound.this.set(this.name, this.tag);
                    this.removed = false;
                }
            }
        }

        public T get() {
            if (this.removed) {
                return this.defaultValue;
            }
            return this.tag.value();
        }

        public boolean isSet() {
            return !this.removed;
        }

        public void remove() {
            NBTTagCompound.this.remove(this.name);
            this.removed = true;
        }
    }

    private class EntryTokenIterator
    implements Iterator<NBTStreamable> {
        private final Iterator<? extends Map.Entry<String, ? extends NBTTag<?>>> entryIterator;

        private EntryTokenIterator() {
            this.entryIterator = NBTTagCompound.this.value.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public NBTStreamable next() {
            Map.Entry<String, NBTTag<?>> entry = this.entryIterator.next();
            return new SurroundingNBTStream(new NBTToken.Name(entry.getKey(), Optional.of(entry.getValue().type().id())), entry.getValue().stream(), null);
        }
    }
}

