/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.OptionalInt;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.internal.SurroundingNBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagType;

public final class NBTTagByteArray
extends NBTTag<byte[]> {
    private byte[] value;

    @NotNull
    public static NBTTagByteArray of(byte ... value) {
        return new NBTTagByteArray((byte[])value.clone());
    }

    private NBTTagByteArray(byte[] value) {
        this.value = value;
    }

    @Override
    @NotNull
    public NBTTagType<NBTTagByteArray> type() {
        return NBTTagType.BYTE_ARRAY;
    }

    @Override
    public byte[] value() {
        return (byte[])this.value.clone();
    }

    @Override
    public void setValue(byte[] value) {
        this.value = value;
    }

    @NotNull
    public ByteBuffer view() {
        return ByteBuffer.wrap(this.value).asReadOnlyBuffer();
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return new SurroundingNBTStream(new NBTToken.ByteArrayStart(OptionalInt.of(this.value.length)), new NBTStream(){
            private static final int BUFFER_SIZE = 4096;
            private int i = 0;

            @Override
            @Nullable
            public NBTToken nextOrNull() {
                if (this.i >= NBTTagByteArray.this.value.length) {
                    return null;
                }
                int length = Math.min(4096, NBTTagByteArray.this.value.length - this.i);
                ByteBuffer buffer = ByteBuffer.wrap(NBTTagByteArray.this.value, this.i, length).asReadOnlyBuffer();
                this.i += length;
                return new NBTToken.ByteArrayContent(buffer);
            }
        }, new NBTToken.ByteArrayEnd());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTTagByteArray that = (NBTTagByteArray)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.value());
    }
}

