/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTagNumber;
import org.kingdoms.nbt.tag.NBTTagType;

public class NBTTagByte
extends NBTTagNumber<Byte> {
    private byte value;

    @NotNull
    public static NBTTagByte fromInt(int value) {
        return NBTTagByte.of((byte)value);
    }

    @NotNull
    public static NBTTagByte of(byte value) {
        return new NBTTagByte(value);
    }

    protected NBTTagByte(byte value) {
        this.value = value;
    }

    @Override
    @NotNull
    public NBTTagType<NBTTagByte> type() {
        return NBTTagType.BYTE;
    }

    @Override
    @NotNull
    public Byte value() {
        return this.value;
    }

    @Override
    public void setValue(Byte value) {
        this.value = value;
    }

    public byte valueAsByte() {
        return this.value;
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return NBTStream.of((NBTToken)new NBTToken.Byte(this.value));
    }
}

