/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.stream.impl;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.OptionalInt;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.exception.NBTParseException;
import org.kingdoms.nbt.stream.token.NBTToken;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader;", "Lorg/kingdoms/nbt/stream/NBTStream;", "input", "Ljava/io/DataInput;", "<init>", "(Ljava/io/DataInput;)V", "stateStack", "Ljava/util/Deque;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "nextOrNull", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "State", "nbt"})
public final class NBTReader
implements NBTStream {
    @NotNull
    private final DataInput input;
    @NotNull
    private final Deque<State> stateStack;

    public NBTReader(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.stateStack = new ArrayDeque(CollectionsKt.listOf((Object)new State.Initial()));
    }

    @Override
    @Nullable
    public NBTToken nextOrNull() throws IOException {
        State state = this.stateStack.pollLast();
        if (state == null) {
            return null;
        }
        State state2 = state;
        if (state2 instanceof State.ListEntry) {
            if (((State.ListEntry)state2).getRemaining() == 0) {
                return new NBTToken.ListEnd();
            }
            this.stateStack.addLast(new State.ListEntry(((State.ListEntry)state2).getRemaining() - 1, ((State.ListEntry)state2).getElementId()));
            state2 = new State.ReadValue(((State.ListEntry)state2).getElementId());
        }
        if (state2 instanceof State.Initial) {
            if (this.input.readUnsignedByte() != NBTTagId.COMPOUND.id()) {
                throw new NBTParseException("NBT stream does not start with a compound tag");
            }
            this.stateStack.addLast(new State.CompoundStart());
            String string = this.input.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
            Optional<NBTTagId> optional = Optional.of(NBTTagId.COMPOUND);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return new NBTToken.Name(string, optional);
        }
        if (state2 instanceof State.CompoundStart) {
            this.stateStack.addLast(new State.CompoundEntryName());
            return new NBTToken.CompoundStart();
        }
        if (state2 instanceof State.CompoundEntryName) {
            NBTTagId id = NBTTagId.Companion.fromId(this.input.readUnsignedByte());
            if (id == NBTTagId.END) {
                return new NBTToken.CompoundEnd();
            }
            this.stateStack.addLast(new State.CompoundEntryName());
            this.stateStack.addLast(new State.ReadValue(id));
            String string = this.input.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
            Optional<NBTTagId> optional = Optional.of(id);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return new NBTToken.Name(string, optional);
        }
        if (state2 instanceof State.ReadValue) {
            NBTToken nBTToken;
            switch (WhenMappings.$EnumSwitchMapping$0[((State.ReadValue)state2).getId().ordinal()]) {
                case 1: {
                    nBTToken = new NBTToken.Byte(this.input.readByte());
                    break;
                }
                case 2: {
                    nBTToken = new NBTToken.Short(this.input.readShort());
                    break;
                }
                case 3: {
                    nBTToken = new NBTToken.Int(this.input.readInt());
                    break;
                }
                case 4: {
                    nBTToken = new NBTToken.Long(this.input.readLong());
                    break;
                }
                case 5: {
                    nBTToken = new NBTToken.Float(this.input.readFloat());
                    break;
                }
                case 6: {
                    nBTToken = new NBTToken.Double(this.input.readDouble());
                    break;
                }
                case 7: {
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ReadByteArray(size));
                    OptionalInt optionalInt = OptionalInt.of(size);
                    Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                    nBTToken = new NBTToken.ByteArrayStart(optionalInt);
                    break;
                }
                case 8: {
                    String string = this.input.readUTF();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                    nBTToken = new NBTToken.String(string);
                    break;
                }
                case 9: {
                    NBTTagId elementId = NBTTagId.Companion.fromId(this.input.readUnsignedByte());
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ListEntry(size, elementId));
                    OptionalInt optionalInt = OptionalInt.of(size);
                    Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                    Optional<NBTTagId> optional = Optional.of(elementId);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    nBTToken = new NBTToken.ListStart(optionalInt, optional);
                    break;
                }
                case 10: {
                    this.stateStack.addLast(new State.CompoundEntryName());
                    nBTToken = new NBTToken.CompoundStart();
                    break;
                }
                case 11: {
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ReadIntArray(size));
                    OptionalInt optionalInt = OptionalInt.of(size);
                    Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                    nBTToken = new NBTToken.IntArrayStart(optionalInt);
                    break;
                }
                case 12: {
                    int size = this.input.readInt();
                    this.stateStack.addLast(new State.ReadLongArray(size));
                    OptionalInt optionalInt = OptionalInt.of(size);
                    Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                    nBTToken = new NBTToken.LongArrayStart(optionalInt);
                    break;
                }
                case 13: {
                    throw new NBTParseException("Invalid id: " + (Object)((Object)((State.ReadValue)state2).getId()));
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return nBTToken;
        }
        if (state2 instanceof State.ReadByteArray) {
            if (((State.ReadByteArray)state2).getRemaining() == 0) {
                return new NBTToken.ByteArrayEnd();
            }
            ByteBuffer buffer = ByteBuffer.allocate((int)Math.min(8192.0, (double)((State.ReadByteArray)state2).getRemaining()));
            this.input.readFully(buffer.array(), buffer.position(), buffer.remaining());
            this.stateStack.addLast(new State.ReadByteArray(((State.ReadByteArray)state2).getRemaining() - buffer.remaining()));
            ByteBuffer byteBuffer = buffer.asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
            return new NBTToken.ByteArrayContent(byteBuffer);
        }
        if (state2 instanceof State.ReadIntArray) {
            if (((State.ReadIntArray)state2).getRemaining() == 0) {
                return new NBTToken.IntArrayEnd();
            }
            ByteBuffer buffer = ByteBuffer.allocate((int)Math.min(8192.0, (double)(((State.ReadIntArray)state2).getRemaining() * 4)));
            this.input.readFully(buffer.array(), buffer.position(), buffer.remaining());
            this.stateStack.addLast(new State.ReadIntArray(((State.ReadIntArray)state2).getRemaining() - buffer.remaining() / 4));
            IntBuffer intBuffer = buffer.asIntBuffer().asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"asReadOnlyBuffer(...)");
            return new NBTToken.IntArrayContent(intBuffer);
        }
        if (state2 instanceof State.ReadLongArray) {
            if (((State.ReadLongArray)state2).getRemaining() == 0) {
                return new NBTToken.LongArrayEnd();
            }
            ByteBuffer buffer = ByteBuffer.allocate((int)Math.min(8192.0, (double)(((State.ReadLongArray)state2).getRemaining() * 8)));
            this.input.readFully(buffer.array(), buffer.position(), buffer.remaining());
            this.stateStack.addLast(new State.ReadLongArray(((State.ReadLongArray)state2).getRemaining() - buffer.remaining() / 8));
            LongBuffer longBuffer = buffer.asLongBuffer().asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)longBuffer, (String)"asReadOnlyBuffer(...)");
            return new NBTToken.LongArrayContent(longBuffer);
        }
        throw new AssertionError((Object)"Missing state handler (switch patterns wen)");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\bb\u0018\u00002\u00020\u0001:\b\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "", "Initial", "CompoundStart", "CompoundEntryName", "ListEntry", "ReadValue", "ReadByteArray", "ReadIntArray", "ReadLongArray", "nbt"})
    private static interface State {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$CompoundEntryName;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "<init>", "()V", "nbt"})
        public static final class CompoundEntryName
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$CompoundStart;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "<init>", "()V", "nbt"})
        public static final class CompoundStart
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$Initial;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "<init>", "()V", "nbt"})
        public static final class Initial
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$ListEntry;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "remaining", "", "elementId", "Lorg/kingdoms/nbt/NBTTagId;", "<init>", "(ILorg/kingdoms/nbt/NBTTagId;)V", "getRemaining", "()I", "getElementId", "()Lorg/kingdoms/nbt/NBTTagId;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "nbt"})
        public static final class ListEntry
        implements State {
            private final int remaining;
            @NotNull
            private final NBTTagId elementId;

            public ListEntry(int remaining, @NotNull NBTTagId elementId) {
                Intrinsics.checkNotNullParameter((Object)((Object)elementId), (String)"elementId");
                this.remaining = remaining;
                this.elementId = elementId;
            }

            public final int getRemaining() {
                return this.remaining;
            }

            @NotNull
            public final NBTTagId getElementId() {
                return this.elementId;
            }

            public final int component1() {
                return this.remaining;
            }

            @NotNull
            public final NBTTagId component2() {
                return this.elementId;
            }

            @NotNull
            public final ListEntry copy(int remaining, @NotNull NBTTagId elementId) {
                Intrinsics.checkNotNullParameter((Object)((Object)elementId), (String)"elementId");
                return new ListEntry(remaining, elementId);
            }

            public static /* synthetic */ ListEntry copy$default(ListEntry listEntry, int n, NBTTagId nBTTagId, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = listEntry.remaining;
                }
                if ((n2 & 2) != 0) {
                    nBTTagId = listEntry.elementId;
                }
                return listEntry.copy(n, nBTTagId);
            }

            @NotNull
            public String toString() {
                return "ListEntry(remaining=" + this.remaining + ", elementId=" + (Object)((Object)this.elementId) + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.remaining);
                result = result * 31 + this.elementId.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ListEntry)) {
                    return false;
                }
                ListEntry listEntry = (ListEntry)other;
                if (this.remaining != listEntry.remaining) {
                    return false;
                }
                return this.elementId == listEntry.elementId;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$ReadByteArray;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "remaining", "", "<init>", "(I)V", "getRemaining", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "nbt"})
        public static final class ReadByteArray
        implements State {
            private final int remaining;

            public ReadByteArray(int remaining) {
                this.remaining = remaining;
            }

            public final int getRemaining() {
                return this.remaining;
            }

            public final int component1() {
                return this.remaining;
            }

            @NotNull
            public final ReadByteArray copy(int remaining) {
                return new ReadByteArray(remaining);
            }

            public static /* synthetic */ ReadByteArray copy$default(ReadByteArray readByteArray, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = readByteArray.remaining;
                }
                return readByteArray.copy(n);
            }

            @NotNull
            public String toString() {
                return "ReadByteArray(remaining=" + this.remaining + ')';
            }

            public int hashCode() {
                return Integer.hashCode(this.remaining);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReadByteArray)) {
                    return false;
                }
                ReadByteArray readByteArray = (ReadByteArray)other;
                return this.remaining == readByteArray.remaining;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$ReadIntArray;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "remaining", "", "<init>", "(I)V", "getRemaining", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "nbt"})
        public static final class ReadIntArray
        implements State {
            private final int remaining;

            public ReadIntArray(int remaining) {
                this.remaining = remaining;
            }

            public final int getRemaining() {
                return this.remaining;
            }

            public final int component1() {
                return this.remaining;
            }

            @NotNull
            public final ReadIntArray copy(int remaining) {
                return new ReadIntArray(remaining);
            }

            public static /* synthetic */ ReadIntArray copy$default(ReadIntArray readIntArray, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = readIntArray.remaining;
                }
                return readIntArray.copy(n);
            }

            @NotNull
            public String toString() {
                return "ReadIntArray(remaining=" + this.remaining + ')';
            }

            public int hashCode() {
                return Integer.hashCode(this.remaining);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReadIntArray)) {
                    return false;
                }
                ReadIntArray readIntArray = (ReadIntArray)other;
                return this.remaining == readIntArray.remaining;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$ReadLongArray;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "remaining", "", "<init>", "(I)V", "getRemaining", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "nbt"})
        public static final class ReadLongArray
        implements State {
            private final int remaining;

            public ReadLongArray(int remaining) {
                this.remaining = remaining;
            }

            public final int getRemaining() {
                return this.remaining;
            }

            public final int component1() {
                return this.remaining;
            }

            @NotNull
            public final ReadLongArray copy(int remaining) {
                return new ReadLongArray(remaining);
            }

            public static /* synthetic */ ReadLongArray copy$default(ReadLongArray readLongArray, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = readLongArray.remaining;
                }
                return readLongArray.copy(n);
            }

            @NotNull
            public String toString() {
                return "ReadLongArray(remaining=" + this.remaining + ')';
            }

            public int hashCode() {
                return Integer.hashCode(this.remaining);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReadLongArray)) {
                    return false;
                }
                ReadLongArray readLongArray = (ReadLongArray)other;
                return this.remaining == readLongArray.remaining;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/nbt/stream/impl/NBTReader$State$ReadValue;", "Lorg/kingdoms/nbt/stream/impl/NBTReader$State;", "id", "Lorg/kingdoms/nbt/NBTTagId;", "<init>", "(Lorg/kingdoms/nbt/NBTTagId;)V", "getId", "()Lorg/kingdoms/nbt/NBTTagId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "nbt"})
        public static final class ReadValue
        implements State {
            @NotNull
            private final NBTTagId id;

            public ReadValue(@NotNull NBTTagId id) {
                Intrinsics.checkNotNullParameter((Object)((Object)id), (String)"id");
                this.id = id;
            }

            @NotNull
            public final NBTTagId getId() {
                return this.id;
            }

            @NotNull
            public final NBTTagId component1() {
                return this.id;
            }

            @NotNull
            public final ReadValue copy(@NotNull NBTTagId id) {
                Intrinsics.checkNotNullParameter((Object)((Object)id), (String)"id");
                return new ReadValue(id);
            }

            public static /* synthetic */ ReadValue copy$default(ReadValue readValue, NBTTagId nBTTagId, int n, Object object) {
                if ((n & 1) != 0) {
                    nBTTagId = readValue.id;
                }
                return readValue.copy(nBTTagId);
            }

            @NotNull
            public String toString() {
                return "ReadValue(id=" + (Object)((Object)this.id) + ')';
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReadValue)) {
                    return false;
                }
                ReadValue readValue = (ReadValue)other;
                return this.id == readValue.id;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NBTTagId.values().length];
            try {
                nArray[NBTTagId.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.INT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.DOUBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.BYTE_ARRAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.STRING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LIST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.COMPOUND.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.INT_ARRAY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LONG_ARRAY.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.END.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

