/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.stream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Optional;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.nbt.internal.AbstractIterator;
import org.kingdoms.nbt.stream.NBTStreamable;
import org.kingdoms.nbt.stream.impl.OptionalInfoCalculator;
import org.kingdoms.nbt.stream.token.NBTToken;

public interface NBTStream
extends NBTStreamable {
    public static NBTStream of() {
        return () -> null;
    }

    public static NBTStream of(final NBTToken token) {
        return new NBTStream(){
            private NBTToken nextToken;
            {
                this.nextToken = token;
            }

            @Override
            @Nullable
            public NBTToken nextOrNull() {
                NBTToken token2 = this.nextToken;
                this.nextToken = null;
                return token2;
            }
        };
    }

    public static NBTStream of(final NBTToken ... tokens) {
        return new NBTStream(){
            private int index = 0;

            @Override
            @Nullable
            public NBTToken nextOrNull() {
                if (this.index >= tokens.length) {
                    return null;
                }
                NBTToken token = tokens[this.index];
                ++this.index;
                return token;
            }
        };
    }

    @Nullable
    public NBTToken nextOrNull() throws IOException;

    default public Optional<NBTToken> next() throws IOException {
        return Optional.ofNullable(this.nextOrNull());
    }

    default public NBTStream calculateOptionalInfo() {
        return new OptionalInfoCalculator(this);
    }

    @Override
    @NotNull
    default public NBTStream stream() {
        return this;
    }

    @NotNull
    default public Iterator<NBTToken> asIterator() {
        return new AbstractIterator<NBTToken>(){

            @Override
            @Nullable
            protected NBTToken computeNext() {
                try {
                    NBTToken NBTToken2 = NBTStream.this.nextOrNull();
                    return NBTToken2 == null ? (NBTToken)this.end() : NBTToken2;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }
}

