/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.stream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.IOFunction;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.NBTStreamable;
import org.kingdoms.nbt.stream.exception.NBTWriteException;
import org.kingdoms.nbt.stream.impl.NBTReader;
import org.kingdoms.nbt.stream.token.NBTToken;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J5\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\n\u001a\u0014\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0005\u0012\u0006\b\u0001\u0012\u0002H\t0\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\"\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0003\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/nbt/stream/NBTBinaryIO;", "", "<init>", "()V", "read", "Lorg/kingdoms/nbt/stream/NBTStream;", "input", "Ljava/io/DataInput;", "readUsing", "R", "transform", "Lorg/kingdoms/nbt/IOFunction;", "(Ljava/io/DataInput;Lorg/kingdoms/nbt/IOFunction;)Ljava/lang/Object;", "write", "", "output", "Ljava/io/DataOutput;", "tokens", "Lorg/kingdoms/nbt/stream/NBTStreamable;", "writeIdAndNameIfNeeded", "id", "Lorg/kingdoms/nbt/NBTTagId;", "name", "", "nbt"})
public final class NBTBinaryIO {
    @NotNull
    public static final NBTBinaryIO INSTANCE = new NBTBinaryIO();

    private NBTBinaryIO() {
    }

    @JvmStatic
    @NotNull
    public static final NBTStream read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new NBTReader(input);
    }

    @JvmStatic
    public static final <R> R readUsing(@NotNull DataInput input, @NotNull IOFunction<? super NBTStream, ? extends R> transform) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return transform.apply(NBTBinaryIO.read(input));
    }

    @JvmStatic
    public static final void write(@NotNull DataOutput output, @NotNull NBTStreamable tokens) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        NBTStream tokenStream = tokens.stream().calculateOptionalInfo();
        boolean seenFirstName = false;
        String nextName = null;
        NBTToken token = null;
        while (tokenStream.nextOrNull() != null) {
            Buffer buffer;
            if (!seenFirstName) {
                if (token instanceof NBTToken.Name) {
                    seenFirstName = true;
                } else {
                    throw new NBTWriteException("Expected first token to be a name");
                }
            }
            if (token instanceof NBTToken.Name) {
                nextName = ((NBTToken.Name)token).getName();
                continue;
            }
            if (token instanceof NBTToken.ByteArrayStart) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.BYTE_ARRAY, nextName);
                nextName = null;
                output.writeInt(((NBTToken.ByteArrayStart)token).getSize().orElseThrow(NBTBinaryIO::write$lambda$0));
                continue;
            }
            if (token instanceof NBTToken.ByteArrayContent) {
                byte[] copy = new byte[((NBTToken.ByteArrayContent)token).getBuffer().remaining()];
                ((NBTToken.ByteArrayContent)token).getBuffer().get(copy);
                output.write(copy);
                continue;
            }
            if (token instanceof NBTToken.ByteArrayEnd) continue;
            if (token instanceof NBTToken.Byte) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.BYTE, nextName);
                nextName = null;
                output.writeByte(((NBTToken.Byte)token).getValue());
                continue;
            }
            if (token instanceof NBTToken.CompoundStart) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.COMPOUND, nextName);
                nextName = null;
                continue;
            }
            if (token instanceof NBTToken.CompoundEnd) {
                output.writeByte(NBTTagId.END.id());
                continue;
            }
            if (token instanceof NBTToken.Double) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.DOUBLE, nextName);
                nextName = null;
                output.writeDouble(((NBTToken.Double)token).getValue());
                continue;
            }
            if (token instanceof NBTToken.Float) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.FLOAT, nextName);
                nextName = null;
                output.writeFloat(((NBTToken.Float)token).getValue());
                continue;
            }
            if (token instanceof NBTToken.IntArrayStart) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.INT_ARRAY, nextName);
                nextName = null;
                output.writeInt(((NBTToken.IntArrayStart)token).getSize().orElseThrow(NBTBinaryIO::write$lambda$1));
                continue;
            }
            if (token instanceof NBTToken.IntArrayContent) {
                buffer = ((NBTToken.IntArrayContent)token).getBuffer();
                while (buffer.hasRemaining()) {
                    output.writeInt(((IntBuffer)buffer).get());
                }
                continue;
            }
            if (token instanceof NBTToken.IntArrayEnd) continue;
            if (token instanceof NBTToken.Int) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.INT, nextName);
                nextName = null;
                output.writeInt(((NBTToken.Int)token).getValue());
                continue;
            }
            if (token instanceof NBTToken.ListStart) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.LIST, nextName);
                nextName = null;
                output.writeByte(((NBTToken.ListStart)token).getElementId().orElseThrow(NBTBinaryIO::write$lambda$2).id());
                output.writeInt(((NBTToken.ListStart)token).getSize().orElseThrow(NBTBinaryIO::write$lambda$3));
                continue;
            }
            if (token instanceof NBTToken.ListEnd) continue;
            if (token instanceof NBTToken.LongArrayStart) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.LONG_ARRAY, nextName);
                nextName = null;
                output.writeInt(((NBTToken.LongArrayStart)token).getSize().orElseThrow(NBTBinaryIO::write$lambda$4));
                continue;
            }
            if (token instanceof NBTToken.LongArrayContent) {
                buffer = ((NBTToken.LongArrayContent)token).getBuffer();
                while (buffer.hasRemaining()) {
                    output.writeLong(((LongBuffer)buffer).get());
                }
                continue;
            }
            if (token instanceof NBTToken.LongArrayEnd) continue;
            if (token instanceof NBTToken.Long) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.LONG, nextName);
                nextName = null;
                output.writeLong(((NBTToken.Long)token).getValue());
                continue;
            }
            if (token instanceof NBTToken.Short) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.SHORT, nextName);
                nextName = null;
                output.writeShort(((NBTToken.Short)token).getValue());
                continue;
            }
            if (token instanceof NBTToken.String) {
                NBTBinaryIO.writeIdAndNameIfNeeded(output, NBTTagId.STRING, nextName);
                nextName = null;
                output.writeUTF(((NBTToken.String)token).getValue());
                continue;
            }
            throw new NBTWriteException("Unknown token: " + token);
        }
    }

    @JvmStatic
    private static final void writeIdAndNameIfNeeded(DataOutput output, NBTTagId id, String name) throws IOException {
        if (name != null) {
            output.writeByte(id.id());
            output.writeUTF(name);
        }
    }

    private static final NullPointerException write$lambda$0() {
        return new NullPointerException();
    }

    private static final NullPointerException write$lambda$1() {
        return new NullPointerException();
    }

    private static final NullPointerException write$lambda$2() {
        return new NullPointerException();
    }

    private static final NullPointerException write$lambda$3() {
        return new NullPointerException();
    }

    private static final NullPointerException write$lambda$4() {
        return new NullPointerException();
    }
}

