/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.snbt.reader;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.snbt.reader.SNBTToken;
import org.kingdoms.nbt.snbt.reader.SNBTTokenWithMetadata;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.exception.NBTParseException;
import org.kingdoms.nbt.stream.token.NBTToken;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u0003345B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002Jr\u0010\"\u001a\u00020\u001a\"\n\b\u0000\u0010#*\u0004\u0018\u00010$\"\n\b\u0001\u0010%*\u0004\u0018\u00010\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H#0)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002H%0+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\u000b0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0/H\u0002J\b\u00100\u001a\u00020\u001aH\u0002J\u0010\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0011H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader;", "Lorg/kingdoms/nbt/stream/NBTStream;", "input", "", "Lorg/kingdoms/nbt/snbt/reader/SNBTTokenWithMetadata;", "<init>", "(Ljava/util/Iterator;)V", "stateStack", "Ljava/util/Deque;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "tokenQueue", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "readAgainStack", "charIndex", "", "read", "errorPrefix", "", "unexpectedTokenError", "Lorg/kingdoms/nbt/stream/exception/NBTParseException;", "token", "Lorg/kingdoms/nbt/snbt/reader/SNBTToken;", "unexpectedTokenSpecificError", "expected", "nextOrNull", "fillTokenStack", "", "state", "readValue", "mustBeCompound", "", "advanceCompound", "readName", "advanceList", "advanceArray", "T", "Ljava/nio/Buffer;", "L", "tagType", "Ljava/lang/Class;", "allocator", "Ljava/util/function/IntFunction;", "putter", "Ljava/util/function/BiConsumer;", "contentProducer", "Ljava/util/function/Function;", "endProducer", "Ljava/util/function/Supplier;", "prepareListLike", "getTokenFor", "valueString", "State", "ArrayAdvancer", "Companion", "nbt"})
public final class SNBTReader
implements NBTStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Iterator<SNBTTokenWithMetadata> input;
    @NotNull
    private final Deque<State> stateStack;
    @NotNull
    private final Deque<NBTToken> tokenQueue;
    @NotNull
    private final Deque<SNBTTokenWithMetadata> readAgainStack;
    private int charIndex;
    private static final int BUFFER_SIZE = 4096;

    public SNBTReader(@NotNull Iterator<SNBTTokenWithMetadata> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        this.input = input;
        this.stateStack = new ArrayDeque(CollectionsKt.listOf((Object)new State.ReadValue(true)));
        this.tokenQueue = new ArrayDeque();
        this.readAgainStack = new ArrayDeque();
    }

    private final SNBTTokenWithMetadata read() {
        SNBTTokenWithMetadata token = this.readAgainStack.pollFirst();
        if (token != null) {
            return token;
        }
        if (!this.input.hasNext()) {
            throw new NBTParseException(this.errorPrefix() + "Unexpected end of input");
        }
        SNBTTokenWithMetadata next = this.input.next();
        this.charIndex = next.getCharIndex();
        return next;
    }

    private final String errorPrefix() {
        return "At character index " + this.charIndex + ": ";
    }

    private final NBTParseException unexpectedTokenError(SNBTToken token) {
        return new NBTParseException(this.errorPrefix() + "Unexpected token: " + token);
    }

    private final NBTParseException unexpectedTokenSpecificError(SNBTToken token, String expected) {
        return new NBTParseException(this.errorPrefix() + "Unexpected token: " + token + ", expected " + expected);
    }

    @Override
    @Nullable
    public NBTToken nextOrNull() {
        NBTToken token = this.tokenQueue.pollFirst();
        while (token == null) {
            State state;
            if (this.stateStack.peekLast() == null) {
                return null;
            }
            this.fillTokenStack(state);
            token = this.tokenQueue.pollFirst();
        }
        return token;
    }

    private final void fillTokenStack(State state) {
        State state2 = state;
        if (state2 instanceof State.ReadValue) {
            this.readValue(((State.ReadValue)state).getMustBeCompound());
        } else if (state2 instanceof State.InCompound) {
            this.advanceCompound();
        } else if (state2 instanceof State.CompoundEntryName) {
            this.readName();
        } else if (state2 instanceof State.InList) {
            this.advanceList();
        } else if (state2 instanceof State.InByteArray) {
            this.advanceArray(NBTToken.Byte.class, SNBTReader::fillTokenStack$lambda$0, SNBTReader::fillTokenStack$lambda$1, SNBTReader::fillTokenStack$lambda$2, SNBTReader::fillTokenStack$lambda$3);
        } else if (state2 instanceof State.InIntArray) {
            this.advanceArray(NBTToken.Int.class, SNBTReader::fillTokenStack$lambda$4, SNBTReader::fillTokenStack$lambda$5, SNBTReader::fillTokenStack$lambda$6, SNBTReader::fillTokenStack$lambda$7);
        } else if (state2 instanceof State.InLongArray) {
            this.advanceArray(NBTToken.Long.class, SNBTReader::fillTokenStack$lambda$8, SNBTReader::fillTokenStack$lambda$9, SNBTReader::fillTokenStack$lambda$10, SNBTReader::fillTokenStack$lambda$11);
        } else {
            throw new IllegalStateException(this.errorPrefix() + "Unknown state: " + state);
        }
    }

    private final void readValue(boolean mustBeCompound) {
        this.stateStack.removeLast();
        SNBTToken token = this.read().getToken();
        if (token instanceof SNBTToken.CompoundStart) {
            this.stateStack.addLast(new State.InCompound());
            this.stateStack.addLast(new State.CompoundEntryName());
            this.tokenQueue.addLast(new NBTToken.CompoundStart());
            return;
        }
        if (mustBeCompound) {
            throw this.unexpectedTokenSpecificError(token, SNBTToken.CompoundStart.INSTANCE.toString());
        }
        SNBTToken sNBTToken = token;
        if (sNBTToken instanceof SNBTToken.ListLikeStart) {
            this.prepareListLike();
        } else if (sNBTToken instanceof SNBTToken.Text) {
            NBTToken NBTToken2 = ((SNBTToken.Text)token).getQuoted() ? (NBTToken)new NBTToken.String(((SNBTToken.Text)token).getContent()) : this.getTokenFor(((SNBTToken.Text)token).getContent());
            this.tokenQueue.addLast(NBTToken2);
        } else {
            throw this.unexpectedTokenError(token);
        }
    }

    private final void advanceCompound() {
        SNBTToken token = this.read().getToken();
        if (token instanceof SNBTToken.CompoundEnd) {
            this.stateStack.removeLast();
            this.tokenQueue.addLast(new NBTToken.CompoundEnd());
        } else if (token instanceof SNBTToken.Separator) {
            this.stateStack.addLast(new State.CompoundEntryName());
        } else {
            throw this.unexpectedTokenError(token);
        }
    }

    private final void readName() {
        SNBTToken token;
        this.stateStack.removeLast();
        SNBTToken sNBTToken = token = this.read().getToken();
        SNBTToken.Text text = sNBTToken instanceof SNBTToken.Text ? (SNBTToken.Text)sNBTToken : null;
        if (text == null) {
            throw this.unexpectedTokenSpecificError(token, "Text");
        }
        SNBTToken.Text textToken = text;
        token = this.read().getToken();
        if (!(token instanceof SNBTToken.EntrySeparator)) {
            throw this.unexpectedTokenSpecificError(token, SNBTToken.EntrySeparator.INSTANCE.toString());
        }
        this.stateStack.addLast(new State.ReadValue(false));
        String string = textToken.getContent();
        Optional<NBTTagId> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.tokenQueue.addLast(new NBTToken.Name(string, optional));
    }

    private final void advanceList() {
        SNBTToken token = this.read().getToken();
        if (token instanceof SNBTToken.ListLikeEnd) {
            this.stateStack.removeLast();
            this.tokenQueue.addLast(new NBTToken.ListEnd());
        } else if (token instanceof SNBTToken.Separator) {
            this.stateStack.addLast(new State.ReadValue(false));
        } else {
            throw this.unexpectedTokenError(token);
        }
    }

    private final <T extends Buffer, L extends NBTToken> void advanceArray(Class<L> tagType, IntFunction<T> allocator, BiConsumer<T, L> putter, Function<T, NBTToken> contentProducer, Supplier<NBTToken> endProducer) {
        Buffer buffer;
        boolean isEnd;
        block4: {
            SNBTToken token;
            isEnd = false;
            buffer = (Buffer)allocator.apply(4096);
            do {
                Buffer buffer2 = buffer;
                Intrinsics.checkNotNull((Object)buffer2);
                if (!buffer2.hasRemaining()) break block4;
                token = this.read().getToken();
                if (!(token instanceof SNBTToken.Text)) {
                    throw this.unexpectedTokenSpecificError(token, "Text");
                }
                NBTToken nextValue = this.getTokenFor(((SNBTToken.Text)token).getContent());
                if (!tagType.isInstance(nextValue)) {
                    throw new NBTParseException(this.errorPrefix() + "Expected " + tagType.getSimpleName() + " token, got " + nextValue);
                }
                putter.accept(buffer, tagType.cast(nextValue));
                token = this.read().getToken();
                if (!(token instanceof SNBTToken.ListLikeEnd)) continue;
                isEnd = true;
                break block4;
            } while (token instanceof SNBTToken.Separator);
            throw this.unexpectedTokenError(token);
        }
        this.tokenQueue.addLast(contentProducer.apply(buffer));
        if (isEnd) {
            this.stateStack.removeLast();
            this.tokenQueue.addLast(endProducer.get());
        }
    }

    private final void prepareListLike() {
        int initialCharIndex = this.charIndex;
        SNBTTokenWithMetadata typing = this.read();
        SNBTToken text = typing.getToken();
        if (text instanceof SNBTToken.Text && !((SNBTToken.Text)text).getQuoted() && ((SNBTToken.Text)text).getContent().length() == 1) {
            SNBTTokenWithMetadata separatorCheck = this.read();
            if (separatorCheck.getToken() instanceof SNBTToken.ListTypeSeparator) {
                switch (((SNBTToken.Text)text).getContent().charAt(0)) {
                    case 'B': {
                        this.stateStack.addLast(new State.InByteArray());
                        OptionalInt optionalInt = OptionalInt.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
                        this.tokenQueue.addLast(new NBTToken.ByteArrayStart(optionalInt));
                        break;
                    }
                    case 'I': {
                        this.stateStack.addLast(new State.InIntArray());
                        OptionalInt optionalInt = OptionalInt.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
                        this.tokenQueue.addLast(new NBTToken.IntArrayStart(optionalInt));
                        break;
                    }
                    case 'L': {
                        this.stateStack.addLast(new State.InLongArray());
                        OptionalInt optionalInt = OptionalInt.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
                        this.tokenQueue.addLast(new NBTToken.LongArrayStart(optionalInt));
                        break;
                    }
                    default: {
                        throw new NBTParseException(this.errorPrefix() + "Invalid array type: " + ((SNBTToken.Text)text).getContent());
                    }
                }
                return;
            }
            this.readAgainStack.addFirst(separatorCheck);
        }
        this.readAgainStack.addFirst(typing);
        this.charIndex = initialCharIndex;
        this.stateStack.addLast(new State.InList());
        this.stateStack.addLast(new State.ReadValue(false));
        OptionalInt optionalInt = OptionalInt.empty();
        Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
        Optional<NBTTagId> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.tokenQueue.addLast(new NBTToken.ListStart(optionalInt, optional));
    }

    private final NBTToken getTokenFor(String valueString) {
        NBTToken nBTToken;
        char last = valueString.charAt(valueString.length() - 1);
        switch (last) {
            case 'B': 
            case 'b': {
                NBTToken nBTToken2;
                try {
                    String string = valueString.substring(0, valueString.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    nBTToken2 = new NBTToken.Byte(Byte.parseByte(string));
                }
                catch (NumberFormatException e) {
                    nBTToken2 = new NBTToken.String(valueString);
                }
                nBTToken = nBTToken2;
                break;
            }
            case 'L': 
            case 'l': {
                NBTToken nBTToken3;
                try {
                    String string = valueString.substring(0, valueString.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    nBTToken3 = new NBTToken.Long(Long.parseLong(string));
                }
                catch (NumberFormatException e) {
                    nBTToken3 = new NBTToken.String(valueString);
                }
                nBTToken = nBTToken3;
                break;
            }
            case 'S': 
            case 's': {
                NBTToken nBTToken4;
                try {
                    String string = valueString.substring(0, valueString.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    nBTToken4 = new NBTToken.Short(Short.parseShort(string));
                }
                catch (NumberFormatException e) {
                    nBTToken4 = new NBTToken.String(valueString);
                }
                nBTToken = nBTToken4;
                break;
            }
            case 'F': 
            case 'f': {
                NBTToken nBTToken5;
                try {
                    String string = valueString.substring(0, valueString.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    nBTToken5 = new NBTToken.Float(Float.parseFloat(string));
                }
                catch (NumberFormatException e) {
                    nBTToken5 = new NBTToken.String(valueString);
                }
                nBTToken = nBTToken5;
                break;
            }
            case 'D': 
            case 'd': {
                NBTToken nBTToken6;
                try {
                    String string = valueString.substring(0, valueString.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    nBTToken6 = new NBTToken.Double(Double.parseDouble(string));
                }
                catch (NumberFormatException e) {
                    nBTToken6 = new NBTToken.String(valueString);
                }
                nBTToken = nBTToken6;
                break;
            }
            default: {
                try {
                    new NBTToken.Int(Integer.parseInt(valueString));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    new NBTToken.Double(Double.parseDouble(valueString));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                boolean isTrue = StringsKt.equals((String)valueString, (String)"true", (boolean)true);
                if (isTrue || StringsKt.equals((String)valueString, (String)"false", (boolean)true)) {
                    new NBTToken.Byte((byte)(isTrue ? 1 : 0));
                }
                nBTToken = new NBTToken.String(valueString);
            }
        }
        return nBTToken;
    }

    private static final ByteBuffer fillTokenStack$lambda$0(int capacity) {
        return ByteBuffer.allocate(capacity);
    }

    private static final void fillTokenStack$lambda$1(ByteBuffer buffer, NBTToken.Byte t) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        buffer.put(t.getValue());
    }

    private static final NBTToken fillTokenStack$lambda$2(ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = buffer.flip().asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
        return new NBTToken.ByteArrayContent(byteBuffer);
    }

    private static final NBTToken fillTokenStack$lambda$3() {
        return new NBTToken.ByteArrayEnd();
    }

    private static final IntBuffer fillTokenStack$lambda$4(int capacity) {
        return IntBuffer.allocate(capacity);
    }

    private static final void fillTokenStack$lambda$5(IntBuffer buffer, NBTToken.Int t) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        buffer.put(t.getValue());
    }

    private static final NBTToken fillTokenStack$lambda$6(IntBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        IntBuffer intBuffer = buffer.flip().asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"asReadOnlyBuffer(...)");
        return new NBTToken.IntArrayContent(intBuffer);
    }

    private static final NBTToken fillTokenStack$lambda$7() {
        return new NBTToken.IntArrayEnd();
    }

    private static final LongBuffer fillTokenStack$lambda$8(int capacity) {
        return LongBuffer.allocate(capacity);
    }

    private static final void fillTokenStack$lambda$9(LongBuffer buffer, NBTToken.Long t) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        buffer.put(t.getValue());
    }

    private static final NBTToken fillTokenStack$lambda$10(LongBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        LongBuffer longBuffer = buffer.flip().asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)longBuffer, (String)"asReadOnlyBuffer(...)");
        return new NBTToken.LongArrayContent(longBuffer);
    }

    private static final NBTToken fillTokenStack$lambda$11() {
        return new NBTToken.LongArrayEnd();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\bb\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u0002*\n\b\u0001\u0010\u0003*\u0004\u0018\u00010\u00042\u00020\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007H&J\r\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$ArrayAdvancer;", "T", "Ljava/nio/Buffer;", "L", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "", "tagType", "Ljava/lang/Class;", "allocate", "()Ljava/nio/Buffer;", "put", "", "array", "token", "(Ljava/nio/Buffer;Lorg/kingdoms/nbt/stream/token/NBTToken;)V", "produceContent", "(Ljava/nio/Buffer;)Lorg/kingdoms/nbt/stream/token/NBTToken;", "produceEnd", "nbt"})
    private static interface ArrayAdvancer<T extends Buffer, L extends NBTToken> {
        @Nullable
        public Class<L> tagType();

        public T allocate();

        public void put(T var1, L var2);

        @Nullable
        public NBTToken produceContent(T var1);

        @Nullable
        public NBTToken produceEnd();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$Companion;", "", "<init>", "()V", "BUFFER_SIZE", "", "nbt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\bb\u0018\u00002\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "", "InCompound", "CompoundEntryName", "InList", "InByteArray", "InIntArray", "InLongArray", "ReadValue", "nbt"})
    private static interface State {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State$CompoundEntryName;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "<init>", "()V", "nbt"})
        public static final class CompoundEntryName
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State$InByteArray;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "<init>", "()V", "nbt"})
        public static final class InByteArray
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State$InCompound;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "<init>", "()V", "nbt"})
        public static final class InCompound
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State$InIntArray;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "<init>", "()V", "nbt"})
        public static final class InIntArray
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State$InList;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "<init>", "()V", "nbt"})
        public static final class InList
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State$InLongArray;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "<init>", "()V", "nbt"})
        public static final class InLongArray
        implements State {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State$ReadValue;", "Lorg/kingdoms/nbt/snbt/reader/SNBTReader$State;", "mustBeCompound", "", "<init>", "(Z)V", "getMustBeCompound", "()Z", "nbt"})
        public static final class ReadValue
        implements State {
            private final boolean mustBeCompound;

            public ReadValue(boolean mustBeCompound) {
                this.mustBeCompound = mustBeCompound;
            }

            public final boolean getMustBeCompound() {
                return this.mustBeCompound;
            }
        }
    }
}

