/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.snbt;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayDeque;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.snbt.Elusion;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.exception.NBTWriteException;
import org.kingdoms.nbt.stream.token.NBTToken;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/nbt/snbt/SNBTWriter;", "", "<init>", "()V", "stateStack", "Ljava/util/ArrayDeque;", "Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState;", "write", "", "output", "Ljava/lang/Appendable;", "Lorg/kingdoms/libs/kotlin/text/Appendable;", "tokens", "Lorg/kingdoms/nbt/stream/NBTStream;", "handleValueEnd", "replaceLast", "state", "WriteState", "nbt"})
public final class SNBTWriter {
    @NotNull
    private final ArrayDeque<WriteState> stateStack = new ArrayDeque();

    public final void write(@NotNull Appendable output, @NotNull NBTStream tokens) throws IOException {
        block35: {
            NBTToken token;
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            block0: while (true) {
                Buffer buffer;
                WriteState state = this.stateStack.peekLast();
                if (tokens.nextOrNull() == null) break block35;
                if (token instanceof NBTToken.Name) {
                    if (!(state instanceof WriteState.Compound)) {
                        throw new NBTWriteException("Names can only appear inside compounds");
                    }
                    if (((WriteState.Compound)state).getHasPrevious()) {
                        output.append(',');
                        this.replaceLast(new WriteState.Compound(false));
                    }
                    output.append(Elusion.escapeIfNeeded(((NBTToken.Name)token).getName())).append(':');
                    continue;
                }
                if (token instanceof NBTToken.ByteArrayStart) {
                    output.append("[B;");
                    continue;
                }
                if (token instanceof NBTToken.ByteArrayContent) {
                    if (state instanceof WriteState.WritingArray) {
                        output.append(',');
                    } else {
                        this.stateStack.addLast(new WriteState.WritingArray());
                    }
                    buffer = ((NBTToken.ByteArrayContent)token).getBuffer();
                    while (true) {
                        if (!buffer.hasRemaining()) continue block0;
                        output.append(String.valueOf(((ByteBuffer)buffer).get())).append('B');
                        if (!buffer.hasRemaining()) continue;
                        output.append(',');
                    }
                }
                if (token instanceof NBTToken.ByteArrayEnd) {
                    if (state instanceof WriteState.WritingArray) {
                        this.stateStack.removeLast();
                    }
                    output.append(']');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.Byte) {
                    output.append(String.valueOf(((NBTToken.Byte)token).getValue())).append('B');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.CompoundStart) {
                    output.append('{');
                    this.stateStack.addLast(new WriteState.Compound(false));
                    continue;
                }
                if (token instanceof NBTToken.CompoundEnd) {
                    output.append('}');
                    this.stateStack.removeLast();
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.Double) {
                    output.append(String.valueOf(((NBTToken.Double)token).getValue())).append('D');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.Float) {
                    output.append(String.valueOf(((NBTToken.Float)token).getValue())).append('F');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.IntArrayStart) {
                    output.append("[I;");
                    continue;
                }
                if (token instanceof NBTToken.IntArrayContent) {
                    if (state instanceof WriteState.WritingArray) {
                        output.append(',');
                    } else {
                        this.stateStack.addLast(new WriteState.WritingArray());
                    }
                    buffer = ((NBTToken.IntArrayContent)token).getBuffer();
                    while (true) {
                        if (!buffer.hasRemaining()) continue block0;
                        output.append(String.valueOf(((IntBuffer)buffer).get()));
                        if (!buffer.hasRemaining()) continue;
                        output.append(',');
                    }
                }
                if (token instanceof NBTToken.IntArrayEnd) {
                    if (state instanceof WriteState.WritingArray) {
                        this.stateStack.removeLast();
                    }
                    output.append(']');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.Int) {
                    output.append(String.valueOf(((NBTToken.Int)token).getValue()));
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.ListStart) {
                    output.append('[');
                    this.stateStack.addLast(new WriteState.List(((NBTToken.ListStart)token).getSize().orElseThrow(SNBTWriter::write$lambda$0)));
                    continue;
                }
                if (token instanceof NBTToken.ListEnd) {
                    output.append(']');
                    this.stateStack.removeLast();
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.LongArrayStart) {
                    output.append("[L;");
                    continue;
                }
                if (token instanceof NBTToken.LongArrayContent) {
                    if (state instanceof WriteState.WritingArray) {
                        output.append(',');
                    } else {
                        this.stateStack.addLast(new WriteState.WritingArray());
                    }
                    buffer = ((NBTToken.LongArrayContent)token).getBuffer();
                    while (true) {
                        if (!buffer.hasRemaining()) continue block0;
                        output.append(String.valueOf(((LongBuffer)buffer).get())).append('L');
                        if (!buffer.hasRemaining()) continue;
                        output.append(',');
                    }
                }
                if (token instanceof NBTToken.LongArrayEnd) {
                    if (state instanceof WriteState.WritingArray) {
                        this.stateStack.removeLast();
                    }
                    output.append(']');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.Long) {
                    output.append(String.valueOf(((NBTToken.Long)token).getValue())).append('L');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof NBTToken.Short) {
                    output.append(String.valueOf(((NBTToken.Short)token).getValue())).append('S');
                    this.handleValueEnd(output);
                    continue;
                }
                if (!(token instanceof NBTToken.String)) break;
                output.append(Elusion.escapeIfNeeded(((NBTToken.String)token).getValue()));
                this.handleValueEnd(output);
            }
            throw new NBTWriteException("Unknown token: " + token);
        }
    }

    private final void handleValueEnd(Appendable output) throws IOException {
        WriteState writeState = this.stateStack.pollLast();
        if (writeState == null) {
            return;
        }
        WriteState state = writeState;
        if (state instanceof WriteState.List) {
            int remainingValues = ((WriteState.List)state).getRemainingValues() - 1;
            this.stateStack.addLast(new WriteState.List(remainingValues));
            if (remainingValues > 0) {
                output.append(',');
            }
        } else if (state instanceof WriteState.Compound) {
            this.stateStack.addLast(new WriteState.Compound(true));
        } else {
            throw new NBTWriteException("Unexpected state: " + state);
        }
    }

    private final void replaceLast(WriteState state) {
        this.stateStack.removeLast();
        this.stateStack.addLast(state);
    }

    private static final IllegalStateException write$lambda$0() {
        return new IllegalStateException();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\bb\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState;", "", "List", "Compound", "WritingArray", "nbt"})
    private static interface WriteState {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState$Compound;", "Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState;", "hasPrevious", "", "<init>", "(Z)V", "getHasPrevious", "()Z", "nbt"})
        public static final class Compound
        implements WriteState {
            private final boolean hasPrevious;

            public Compound(boolean hasPrevious) {
                this.hasPrevious = hasPrevious;
            }

            public final boolean getHasPrevious() {
                return this.hasPrevious;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState$List;", "Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState;", "remainingValues", "", "<init>", "(I)V", "getRemainingValues", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "nbt"})
        public static final class List
        implements WriteState {
            private final int remainingValues;

            public List(int remainingValues) {
                this.remainingValues = remainingValues;
            }

            public final int getRemainingValues() {
                return this.remainingValues;
            }

            public final int component1() {
                return this.remainingValues;
            }

            @NotNull
            public final List copy(int remainingValues) {
                return new List(remainingValues);
            }

            public static /* synthetic */ List copy$default(List list, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = list.remainingValues;
                }
                return list.copy(n);
            }

            @NotNull
            public String toString() {
                return "List(remainingValues=" + this.remainingValues + ')';
            }

            public int hashCode() {
                return Integer.hashCode(this.remainingValues);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof List)) {
                    return false;
                }
                List list = (List)other;
                return this.remainingValues == list.remainingValues;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState$WritingArray;", "Lorg/kingdoms/nbt/snbt/SNBTWriter$WriteState;", "<init>", "()V", "nbt"})
        public static final class WritingArray
        implements WriteState {
        }
    }
}

