/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.resourcepoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.item.KingdomItemData;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.abstraction.CustomResourcePointDescription;
import org.kingdoms.managers.resourcepoints.ConvertedResourcePoints;
import org.kingdoms.managers.resourcepoints.ResourcePointWorthType;
import org.kingdoms.nbt.tag.NBTTagDouble;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.item.ItemNBT;
import org.kingdoms.utils.KingdomsItemDeserializer;
import org.kingdoms.utils.cache.single.CachedSupplier;

public final class ResourcePointManager {
    private static final Namespace RESOURCE_POINTS = Namespace.kingdoms("RESOURCE_POINTS");
    private static CustomResourcePointDescription[] customResourcePointDescriptions;

    public static void loadSettings() {
        YamlConfigAccessor section = KingdomsConfig.ResourcePoints.ADVANCED.getManager().noDefault().getSection();
        if (section == null) {
            customResourcePointDescriptions = new CustomResourcePointDescription[0];
            KLogger.error("'advanced' section of resource-points.yml is not found.");
            return;
        }
        Set<String> keys = section.getKeys();
        customResourcePointDescriptions = new CustomResourcePointDescription[keys.size()];
        int i = 0;
        for (String key : keys) {
            YamlConfigAccessor customSection = section.gotoSection(key);
            ResourcePointManager.customResourcePointDescriptions[i++] = new CustomResourcePointDescription(key, customSection.getSection());
        }
    }

    public static CustomResourcePointDescription[] getCustomResourcePointDescriptions() {
        return customResourcePointDescriptions;
    }

    private static Long getCustomWorth(ItemStack item, ItemMeta meta) {
        for (CustomResourcePointDescription description : customResourcePointDescriptions) {
            if (!description.matches(item, meta, CachedSupplier.of(() -> ItemNBT.getTag(item)))) continue;
            return (long)description.getWorth();
        }
        return null;
    }

    public static KingdomItem injectWorth(@NonNull ItemStack item, double resourcePoints) {
        KingdomItem kingdomItem = KingdomItem.getOrCreateKingdomItem(item);
        KingdomItemData rpData = KingdomItemData.createEmpty(RESOURCE_POINTS);
        rpData.setData(NBTTagDouble.of(resourcePoints));
        kingdomItem.addData(rpData);
        kingdomItem.applyChanges();
        return kingdomItem;
    }

    public static @Nullable Double getInjectedWorth(@NonNull ItemStack item) {
        return ResourcePointManager.getInjectedWorth(KingdomItem.getKingdomItem(item));
    }

    public static Double getInjectedWorth(KingdomItem item) {
        if (item == null) {
            return null;
        }
        KingdomItemData rpData = item.getData().get(RESOURCE_POINTS);
        if (rpData == null) {
            return null;
        }
        return NBTTagType.DOUBLE.cast(rpData.getData()).value();
    }

    public static Pair<KingdomItem, Double> buildItem(String name) {
        YamlConfigAccessor section = Objects.requireNonNull(KingdomsConfig.ResourcePoints.CUSTOM_ITEMS.getManager().getSection(), "Cannot find the custom items section in the config");
        if ((section = section.noDefault().gotoSection(name)) == null) {
            return null;
        }
        ItemStack item = new KingdomsItemDeserializer().withSection(section).deserialize();
        double rp = section.getDouble("resource-points");
        return Pair.of(ResourcePointManager.injectWorth(item, rp), rp);
    }

    public static double getWorth(ItemStack item) {
        return ResourcePointManager.convertToResourcePoints(Collections.singleton(item), null).getTotalWorth();
    }

    public static @NonNull ConvertedResourcePoints convertToResourcePoints(@NonNull Collection<ItemStack> donations, @Nullable BiFunction<ItemStack, List<ItemStack>, Long> function) {
        return ResourcePointManager.convertToResourcePoints(donations, function, null);
    }

    public static @NonNull ConvertedResourcePoints convertToResourcePoints(@NonNull Collection<ItemStack> donations, @Nullable BiFunction<ItemStack, List<ItemStack>, Long> function, @Nullable Set<ResourcePointWorthType> exclude) {
        List<String> list = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_MATERIAL_LIST.getManager().getStringList();
        boolean blacklist = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_MATERIAL_BLACKLIST.getManager().getBoolean();
        KeyedYamlConfigAccessor loreFilterOpt = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_LORE.getManager();
        KeyedYamlConfigAccessor enchantFilterOpt = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_ENCHANTED.getManager();
        List<String> loreFilter = loreFilterOpt.isSet() ? loreFilterOpt.getStringList() : null;
        Boolean enchantFilter = enchantFilterOpt.isSet() ? Boolean.valueOf(enchantFilterOpt.getBoolean()) : null;
        int forEach = KingdomsConfig.ResourcePoints.FOR_EACH.getManager().getInt();
        int giveAmt = KingdomsConfig.ResourcePoints.GIVE.getManager().getInt();
        boolean hasNormalWorth = forEach != 0 && giveAmt != 0 && (exclude == null || !exclude.contains((Object)ResourcePointWorthType.NORMAL));
        boolean includeInjection = exclude == null || !exclude.contains((Object)ResourcePointWorthType.INJECTED);
        boolean includeSpecials = exclude == null || !exclude.contains((Object)ResourcePointWorthType.SPECIAL);
        YamlConfigAccessor customMaterials = KingdomsConfig.ResourcePoints.CUSTOM.getManager().getSection().noDefault();
        ArrayList<ItemStack> leftOvers = new ArrayList<ItemStack>();
        ArrayList<ItemStack> convertedItems = new ArrayList<ItemStack>();
        double totalWorth = 0.0;
        for (ItemStack item : donations) {
            int special;
            Double injected;
            Long amount;
            if (function != null && (amount = function.apply(item, leftOvers)) != null) {
                totalWorth += (double)amount.longValue();
                convertedItems.add(item);
                continue;
            }
            int amount2 = item.getAmount();
            if (includeInjection && (injected = ResourcePointManager.getInjectedWorth(item)) != null) {
                totalWorth += injected * (double)amount2;
                convertedItems.add(item);
                continue;
            }
            if (includeSpecials) {
                ItemMeta meta = item.getItemMeta();
                Long advancedRp = ResourcePointManager.getCustomWorth(item, meta);
                if (advancedRp != null) {
                    totalWorth += (double)(advancedRp * (long)amount2);
                    convertedItems.add(item);
                    continue;
                }
                boolean hasLore = meta.hasLore();
                if (hasLore && loreFilter != null && !meta.getLore().equals(loreFilter)) {
                    leftOvers.add(item);
                    continue;
                }
                boolean hasEnchants = meta.hasEnchants();
                if (hasEnchants && enchantFilter != null && hasEnchants != enchantFilter) {
                    leftOvers.add(item);
                    continue;
                }
            }
            XMaterial material = XMaterial.matchXMaterial((ItemStack)item);
            int n = special = includeSpecials ? customMaterials.getInt(material.name()) : 0;
            if (special != 0) {
                totalWorth += (double)((long)special * (long)amount2);
                convertedItems.add(item);
                continue;
            }
            if (!hasNormalWorth) continue;
            boolean contains = XTag.anyMatch((Object)material, (Collection)XTag.stringMatcher(list, null));
            if (blacklist == contains) {
                leftOvers.add(item);
                continue;
            }
            totalWorth += (double)((long)(amount2 / forEach) * (long)giveAmt);
            int remainder = amount2 % forEach;
            if (remainder == 0) continue;
            ItemStack converted = item.clone();
            converted.setAmount(converted.getAmount() - remainder);
            convertedItems.add(converted);
            ItemStack leftOver = item.clone();
            leftOver.setAmount(remainder);
            leftOvers.add(leftOver);
        }
        return new ConvertedResourcePoints(totalWorth, donations, leftOvers, convertedItems);
    }

    static {
        ResourcePointManager.loadSettings();
    }
}

