/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.protectionsign;

import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.playerselector.PlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorGUI;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeUtils;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class ProtectionSignGUIManager {
    public static final Map<ProtectionSign, Set<ProtectionSignGUIManager>> OPEN_GUIS = new IdentityHashMap<ProtectionSign, Set<ProtectionSignGUIManager>>();
    private final Player player;
    private final ProtectionSign protection;

    public void invalidate() {
        KingdomsLang.PROTECTED_SIGNS_GUI_INVALID.sendError((CommandSender)this.player, new Object[0]);
        ChatInputManager.endConversation(this.player);
        this.player.closeInventory();
        OPEN_GUIS.remove(this.protection);
    }

    public ProtectionSignGUIManager(Player player, ProtectionSign protection) {
        this.player = player;
        this.protection = protection;
        Set guis = OPEN_GUIS.computeIfAbsent(protection, k -> Collections.newSetFromMap(new IdentityHashMap()));
        guis.add(this);
    }

    public void openMenu() {
        boolean openable = VersionSupport.openable(this.protection.getBlock()).isPresent();
        InteractiveGUI gui = GUIAccessor.prepare(this.player, (OfflinePlayer)this.player, "protection-signs/protected-sign", "protection_type", this.protection.getProtectionType().getDisplayname(), "owner", this.protection.getOwnerPlayer().getName(), "automatic_state_toggle_duration", this.protection.getAutomaticStateToggle(), "openable", openable);
        if (gui == null) {
            return;
        }
        gui.push("back", () -> ((Player)this.player).closeInventory(), new Object[0]).push("automatic-state-toggle-duration", () -> {
            if (!openable) {
                KingdomsLang.PROTECTED_SIGNS_AUTO_STATE_CHANGE_DURATION_UNSUPPORTED.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_AUTO_STATE_CHANGE_DURATION_SET.sendMessage((CommandSender)this.player);
            gui.startConversation("automatic-state-toggle-duration");
        }, input -> {
            Long autoDuration = TimeUtils.parseTime(input);
            if (autoDuration == null) {
                KingdomsLang.INVALID_TIME.sendError((CommandSender)this.player, "time", input);
                return;
            }
            this.protection.setAutomaticStateToggle(Duration.ofMillis(autoDuration));
            gui.endConversation();
            this.openMenu();
        }, new Object[0]).push("access-entries", this::openAccessEntries, new Object[0]).push("protection-type", this::openProtectionTypeGUI, new Object[0]).push("info", () -> {
            if (!this.protection.isContainer()) {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_CONTAINER_ONLY.sendMessage((CommandSender)this.player);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_PASSWORD_ASK.sendMessage((CommandSender)this.player);
            gui.startConversation("info");
        }, this::setPassword, new Object[0]);
        gui.open();
    }

    private void setPassword(String password) {
        String removeKeyword = KingdomsConfig.ProtectionSigns.PASSWORDS_REMOVE_KEYWORD.getManager().getString();
        if (password.equalsIgnoreCase(removeKeyword)) {
            if (!this.protection.hasPassword()) {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_NOT_SET.sendError((CommandSender)this.player, new Object[0]);
            } else {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_REMOVED.sendMessage((CommandSender)this.player);
                password = null;
            }
        } else {
            int maxLength = KingdomsConfig.ProtectionSigns.PASSWORDS_LENGTH_MAX.getManager().getInt();
            int minLength = KingdomsConfig.ProtectionSigns.PASSWORDS_LENGTH_MIN.getManager().getInt();
            int len = password.length();
            if (len < minLength || len > maxLength) {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_LENGTH.sendError((CommandSender)this.player, "min", minLength, "max", maxLength, "length", len);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_PASSWORD_SET.sendMessage((CommandSender)this.player);
        }
        this.protection.changePassword(password);
        ChatInputManager.endConversation(this.player);
    }

    private void openAccessEntries() {
        Object gui = new GUIBuilder("protection-signs/access-entries").forPlayer(this.player).build();
        ReusableOptionHandler entriesOption = ((InteractiveGUI)gui).getReusableOption("entries");
        for (ProtectionSign.AccessEntry accessEntry : this.protection.getAccessEntries()) {
            if (!entriesOption.hasNext()) break;
            entriesOption.setEdits("access_entry_privilege_displayname", accessEntry.getPrivilege().displayName(), "access_entry_privilege", accessEntry.getPrivilege().name(), "access_entry_player_selector", PlayerSelectorGUI.buildPlayerSelectorInfo(accessEntry.getSelector()));
            PlayerSelectorGUI.handleGrouped(entriesOption, this.protection.getAccessEntries(), accessEntry, () -> this.openAccessEntry(accessEntry), this::openAccessEntries);
        }
        ((InteractiveGUI)gui).push("add", () -> {
            int limit = KingdomsConfig.ProtectionSigns.LIMITS_ACCESS_ENTRIES.getManager().getInt();
            if (this.protection.getAccessEntries().size() >= limit) {
                KingdomsLang.PROTECTED_SIGNS_ACCESS_ENTRY_LIMIT.sendError((CommandSender)this.player, "limit", limit);
                return;
            }
            ProtectionSign.AccessEntry accessEntry = new ProtectionSign.AccessEntry(null, ProtectionSign.AccessPrivilege.ALLOWED);
            this.openAccessEntry(accessEntry);
        }, new Object[0]);
        ((InteractiveGUI)gui).push("clear", () -> {
            this.protection.getAccessEntries().clear();
            this.openAccessEntries();
        }, new Object[0]);
        ((InteractiveGUI)gui).push("back", this::openMenu, new Object[0]);
        ((InteractiveGUI)gui).open();
    }

    private void openAccessEntry(ProtectionSign.AccessEntry accessEntry) {
        Object gui = new GUIBuilder("protection-signs/access-entry").forPlayer(this.player).editMessageContext(ctx -> ctx.raws("access_entry_privilege_displayname", accessEntry.getPrivilege().displayName(), "access_entry_privilege", accessEntry.getPrivilege().name(), "access_entry_player_selector", PlayerSelectorGUI.buildPlayerSelectorInfo(accessEntry.getSelector()))).build();
        ((InteractiveGUI)gui).option("player-selector").on(ClickType.LEFT, () -> {
            if (accessEntry.getSelector() == null) {
                PlayerSelectorGUI.createPlayerSelector(this.player).thenAccept(selector -> {
                    if (selector != null) {
                        if (accessEntry.getSelector() == null) {
                            this.protection.getAccessEntries().add(accessEntry);
                        }
                        accessEntry.setSelector((PlayerSelector)selector);
                    }
                    this.openAccessEntry(accessEntry);
                });
            } else {
                accessEntry.getSelector().getProvider().prompt(this.player, (PlayerSelector)Fn.cast(accessEntry.getSelector())).thenAccept(selector -> {
                    if (selector != null) {
                        accessEntry.setSelector((PlayerSelector)selector);
                    }
                    this.openAccessEntry(accessEntry);
                });
            }
        }).on(ClickType.RIGHT, () -> PlayerSelectorGUI.createPlayerSelector(this.player).thenAccept(selector -> {
            if (accessEntry.getSelector() == null) {
                this.protection.getAccessEntries().add(accessEntry);
            }
            accessEntry.setSelector((PlayerSelector)selector);
            this.openAccessEntry(accessEntry);
        })).done();
        ((InteractiveGUI)gui).push("privilege", () -> this.openPrivilegeSelector(accessEntry), new Object[0]);
        ((InteractiveGUI)gui).push("back", this::openAccessEntries, new Object[0]);
        ((InteractiveGUI)gui).open();
    }

    private void openPrivilegeSelector(ProtectionSign.AccessEntry accessEntry) {
        Object gui = new GUIBuilder("protection-signs/access-privileges").forPlayer(this.player).build();
        for (ProtectionSign.AccessPrivilege privilege : ProtectionSign.AccessPrivilege.values()) {
            ((InteractiveGUI)gui).push("privilege-" + privilege.name().toLowerCase(Locale.ENGLISH), () -> {
                accessEntry.setPrivilege(privilege);
                this.openPrivilegeSelector(accessEntry);
            }, "selected", accessEntry.getPrivilege() == privilege);
        }
        ((InteractiveGUI)gui).push("back", () -> this.openAccessEntry(accessEntry), new Object[0]);
        ((InteractiveGUI)gui).open();
    }

    private void openProtectionTypeGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, "protection-signs/protection-type");
        if (gui == null) {
            return;
        }
        for (ProtectionSign.ProtectionType type : ProtectionSign.ProtectionType.values()) {
            gui.push(Strings.configOption(type), () -> {
                this.player.closeInventory();
                if (this.protection.getProtectionType() == type) {
                    KingdomsLang.PROTECTED_SIGNS_PROTECTION_TYPE_ALREADY_USING.sendMessage((CommandSender)this.player, "protection", type.getDisplayname());
                } else {
                    this.protection.setProtectionType(type);
                    KingdomsLang.PROTECTED_SIGNS_PROTECTION_TYPE_CHANGED.sendMessage((CommandSender)this.player, "protection", type.getDisplayname());
                    this.protection.updateSign();
                }
            }, "protection", type.getDisplayname(), "enabled", this.protection.getProtectionType() == type);
        }
        gui.push("back", this::openMenu, new Object[0]);
        gui.open();
    }
}

