/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.bukkit.plugin.Plugin;
import org.kingdoms.addons.AddonRegistry;
import org.kingdoms.commands.general.admin.CommandAbout;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.NodeInterpretContext;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.network.Metrics;

public final class MetricsLoader {
    public static void init(final Kingdoms plugin) {
        Metrics metrics = new Metrics((Plugin)plugin, 7903);
        metrics.addCustomChart(new Metrics.SingleLineChart("turret_limit", new Callable<Integer>(){

            @Override
            public Integer call() {
                KeyedYamlConfigAccessor option = KingdomsConfig.Turrets.LIMITS_TOTAL.getManager();
                return option.get(NodeInterpreter.INT, NodeInterpretContext.nullable());
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("nations", new Callable<Integer>(){

            @Override
            public Integer call() {
                return plugin.getDataCenter().getNationManager().loadedCount();
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("kingdoms", new Callable<Integer>(){

            @Override
            public Integer call() {
                return plugin.getDataCenter().getKingdomManager().loadedCount();
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("lands", new Callable<Integer>(){

            @Override
            public Integer call() {
                return plugin.getDataCenter().getLandManager().loadedCount();
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("source", () -> {
            String src = CommandAbout.getSource().toString();
            if (src.contains("#@!")) {
                src = "Discord";
            }
            return src;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("addons", () -> {
            HashMap map = new HashMap(1);
            AddonRegistry.getAddons().keySet().forEach(x -> {
                HashMap<String, Integer> addons = new HashMap<String, Integer>();
                addons.put("dummy", 1);
                map.put(x, addons);
            });
            return map;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("language_packs", () -> {
            HashMap map = new HashMap(1);
            Arrays.stream(SupportedLanguage.VALUES).filter(x -> x != Language.getDefault()).filter(SupportedLanguage::isInstalled).forEach(x -> {
                HashMap<String, Integer> langs = new HashMap<String, Integer>();
                langs.put("dummy", 1);
                map.put(x.getNativeName(), langs);
            });
            return map;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("chosen_language", () -> {
            HashMap map = new HashMap(1);
            for (KingdomPlayer player : plugin.getDataCenter().getKingdomPlayerManager().getLoadedData()) {
                HashMap<String, Integer> langs = new HashMap<String, Integer>();
                langs.put("dummy", 1);
                if (player.getLanguage() == Language.getDefault()) continue;
                map.put(player.getLanguage().getNativeName(), langs);
            }
            return map;
        }));
    }
}

