/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection.explosions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.SiegeCannon;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.managers.land.protection.explosions.LandExplosionHandler;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.hash.EntityHashSet;
import org.kingdoms.utils.hash.EntityWeakHashMap;
import org.kingdoms.utils.hash.EntityWeakHashSet;

public final class LandExplosionManager
implements Listener {
    public static final boolean REGENERATE = XReflection.supports((int)13) && KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_AUTO_REGENERATE_ENABLED.getManager().getBoolean();
    protected static final double HEIGHT_MIN;
    protected static final double HEIGHT_MAX;
    protected static final double SPREAD_MIN;
    protected static final double SPREAD_MAX;
    protected static final EntityWeakHashSet<FallingBlock> EXPLOSION_BLOCKS;
    protected static final EntityWeakHashMap<Entity, List<Entity>> EXPLODED_ENTITIES;
    protected static final Set<LandExplosionHandler> ONGOING_REGENERATIONS;
    protected static final Map<SimpleLocation, Hanging> BLOCKS_HOLDING_HANGING;

    public static void forceOngoingRegenerations() {
        for (LandExplosionHandler regen : ONGOING_REGENERATIONS) {
            regen.forceFinishRegeneration();
        }
    }

    protected static void customExplosion(SiegeCannon cannon, List<Block> blocks, Block center, int radius, boolean hollow) {
        blocks.clear();
        int bx = center.getX();
        int by = center.getY();
        int bz = center.getZ();
        for (int x = bx - radius; x <= bx + radius; ++x) {
            for (int y = by - radius; y <= by + radius; ++y) {
                for (int z = bz - radius; z <= bz + radius; ++z) {
                    Block block;
                    double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z) + (by - y) * (by - y);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1)) || XBlock.isAir((Material)(block = center.getWorld().getBlockAt(x, y, z)).getType()) || LandExplosionManager.isUnbreakable(block.getType()) || !cannon.canDamage(BlockType.OTHER, "others", () -> XMaterial.matchXMaterial((Material)block.getType()).name())) continue;
                    blocks.add(block);
                }
            }
        }
    }

    private static boolean isUnbreakable(Material material) {
        switch (material) {
            case BEDROCK: 
            case BARRIER: 
            case COMMAND_BLOCK: 
            case END_PORTAL_FRAME: 
            case STRUCTURE_BLOCK: 
            case STRUCTURE_VOID: {
                return true;
            }
        }
        return false;
    }

    protected static void fancyExplode(Block block) {
        if (XReflection.supports((int)13) && block.isPassable()) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Vector vector = new Vector(random.nextDouble(SPREAD_MIN, SPREAD_MAX), random.nextDouble(HEIGHT_MIN, HEIGHT_MAX), random.nextDouble(SPREAD_MIN, SPREAD_MAX));
        FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), block.getType().createBlockData());
        EXPLOSION_BLOCKS.add(falling);
        falling.setDropItem(false);
        falling.setVelocity(vector);
    }

    protected static ItemStack[] getContainerContent(BlockState state) {
        ItemStack[] items = null;
        if (state instanceof InventoryHolder) {
            InventoryHolder inv = (InventoryHolder)state;
            if (inv instanceof Chest) {
                Chest chest = (Chest)inv;
                items = chest.getBlockInventory().getContents();
                chest.getBlockInventory().clear();
            } else {
                items = inv.getInventory().getStorageContents();
                inv.getInventory().clear();
            }
        }
        return items;
    }

    protected static boolean isAttachableOrHangingBlock(BlockState state) {
        if (state instanceof Banner) {
            return true;
        }
        if (state instanceof Sign) {
            return true;
        }
        XMaterial material = XMaterial.matchXMaterial((Material)state.getType());
        switch (material) {
            case TWISTING_VINES_PLANT: 
            case VINE: 
            case TWISTING_VINES: 
            case WEEPING_VINES_PLANT: 
            case WEEPING_VINES: 
            case LANTERN: 
            case SOUL_LANTERN: 
            case LADDER: {
                return true;
            }
        }
        String name = material.name();
        if (name.endsWith("TORCH")) {
            return true;
        }
        if (name.endsWith("BUTTON")) {
            return true;
        }
        return name.contains("CORAL");
    }

    private static boolean handleEntities(Entity target) {
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(target)) {
            return false;
        }
        if (!MiscUpgrade.ANTI_EXPLOSION.isEnabled()) {
            return false;
        }
        SimpleChunkLocation targetChunk = SimpleChunkLocation.of(target.getLocation());
        Land targetLand = targetChunk.getLand();
        if (targetLand == null) {
            return false;
        }
        Kingdom kingdom = targetLand.getKingdom();
        if (kingdom == null) {
            return false;
        }
        return kingdom.getMiscUpgrades().getOrDefault(MiscUpgrade.ANTI_EXPLOSION.getNamespace(), 0) >= 3;
    }

    private static void fuckPaintings(Painting painting, boolean add) {
        Block adjustedCenter;
        int height = painting.getArt().getBlockHeight();
        int width = painting.getArt().getBlockWidth();
        BlockFace facing = painting.getAttachedFace();
        BlockFace leftFace = LandExplosionManager.getFacingOnLeft(facing);
        Block center = painting.getLocation().getBlock().getRelative(facing, 1);
        Block block = adjustedCenter = (facing == BlockFace.EAST || facing == BlockFace.NORTH) && width > 1 ? center.getRelative(leftFace) : center;
        Block topLeftCorner = height < 3 && width < 3 ? adjustedCenter : adjustedCenter.getRelative(BlockFace.UP, height > 2 ? 1 : 0).getRelative(leftFace);
        for (int y = 0; y < height; ++y) {
            Block currentY = topLeftCorner.getRelative(BlockFace.DOWN, y);
            for (int x = 0; x < width; ++x) {
                Block current = currentY.getRelative(leftFace.getOppositeFace(), x);
                SimpleLocation loc = SimpleLocation.of(current);
                if (add) {
                    BLOCKS_HOLDING_HANGING.put(loc, (Hanging)painting);
                    continue;
                }
                BLOCKS_HOLDING_HANGING.remove(loc);
            }
        }
    }

    private static BlockFace getFacingOnLeft(BlockFace face) {
        switch (face) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        throw new AssertionError((Object)("Unknown hanging attached face: " + face));
    }

    private static SimpleLocation getSupportingBlock(Hanging hanging) {
        return SimpleLocation.of(hanging.getLocation().add(hanging.getAttachedFace().getDirection()));
    }

    public static void protectEntityFromExplosion(Cancellable event, Entity damager, Entity entity2) {
        if (LandExplosionManager.handleEntities(entity2)) {
            if (event != null) {
                event.setCancelled(true);
            }
            if (REGENERATE && entity2.hasGravity() && !(entity2 instanceof Player) && !(entity2 instanceof Explosive)) {
                entity2.setGravity(false);
                if (entity2 instanceof LivingEntity) {
                    ((LivingEntity)entity2).setAI(false);
                    if (XReflection.supports((int)17)) {
                        ((LivingEntity)entity2).setInvisible(true);
                    }
                }
                EXPLODED_ENTITIES.computeIfAbsent(damager, k -> new ArrayList()).add(entity2);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void hangingBreak(HangingBreakEvent event) {
        Hanging hanging = event.getEntity();
        if (event.getCause() != HangingBreakEvent.RemoveCause.EXPLOSION) {
            if (hanging instanceof ItemFrame) {
                BLOCKS_HOLDING_HANGING.remove(LandExplosionManager.getSupportingBlock(hanging));
            } else if (hanging instanceof Painting) {
                LandExplosionManager.fuckPaintings((Painting)hanging, false);
            }
            return;
        }
        if (hanging instanceof ItemFrame) {
            BLOCKS_HOLDING_HANGING.put(LandExplosionManager.getSupportingBlock(hanging), hanging);
        } else if (hanging instanceof Painting) {
            LandExplosionManager.fuckPaintings((Painting)hanging, true);
        }
        if (LandExplosionManager.handleEntities((Entity)hanging)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityExplosionDamage(EntityDamageByEntityEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            if (event.getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
                return;
            }
            Entity entity2 = event.getEntity();
            if (SiegeCannon.getSiegeCannonFromProjectile(entity2) == null) {
                return;
            }
        }
        LandExplosionManager.protectEntityFromExplosion((Cancellable)event, event.getDamager(), event.getEntity());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onUnknownExplosion(BlockExplodeEvent event) {
        if (event.blockList().isEmpty()) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(event.getBlock())) {
            return;
        }
        new LandExplosionHandler((Event)event, event.blockList(), null, null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEntityAntiExplosion(EntityExplodeEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(event.getEntity())) {
            return;
        }
        new LandExplosionHandler((Event)event, event.blockList(), event.getEntity(), SiegeCannon.getSiegeCannonFromProjectile(event.getEntity()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onWitherSkullExplosion(EntityChangeBlockEvent event) {
        if (event.getEntityType() != EntityType.WITHER) {
            return;
        }
        Land land = Land.getLand(event.getBlock());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (kingdom.getUpgradeLevel(MiscUpgrade.ANTI_EXPLOSION) > 1) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFancyExplosionFall(EntityChangeBlockEvent event) {
        Entity entity2 = event.getEntity();
        if (entity2.getType() != EntityType.FALLING_BLOCK) {
            return;
        }
        if (EXPLOSION_BLOCKS.remove((FallingBlock)entity2)) {
            event.setCancelled(true);
        }
    }

    static {
        EXPLOSION_BLOCKS = ((EntityHashSet.WeakBuilder)((EntityHashSet.WeakBuilder)EntityHashSet.weakBuilder(FallingBlock.class).onDeath(EntityHashSet::remove)).onLeave(EntityHashSet::remove)).build();
        EXPLODED_ENTITIES = ((EntityHashMap.WeakBuilder)((EntityHashMap.WeakBuilder)EntityHashMap.weakBuilder(Entity.class).onDeath(EntityWeakHashMap::remove)).onLeave(EntityWeakHashMap::remove)).build();
        ONGOING_REGENERATIONS = Collections.newSetFromMap(new IdentityHashMap());
        BLOCKS_HOLDING_HANGING = new HashMap<SimpleLocation, Hanging>();
        HEIGHT_MIN = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_HEIGHT_MIN.getManager().getDouble();
        HEIGHT_MAX = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_HEIGHT_MAX.getManager().getDouble();
        SPREAD_MIN = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_SPREAD_MIN.getManager().getDouble();
        SPREAD_MAX = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_SPREAD_MAX.getManager().getDouble();
    }

    public static enum BlockType {
        OTHER,
        TURRET,
        STRUCTURE,
        PROTECTED_BLOCK;

    }
}

