/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection.explosions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Shield;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.structures.objects.SiegeCannon;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.structures.SiegeCannonAmmo;
import org.kingdoms.managers.land.protection.explosions.LandExplosionManager;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.kingdoms.Shields;
import org.kingdoms.utils.string.Strings;

final class LandExplosionHandler {
    final BlockState[] states;
    final ArrayList<BlockState> requireBaseStates;
    final Map<SimpleLocation, ItemStack[]> containers;
    final @Nullable SiegeCannon cannon;
    final SiegeCannonAmmo cannonAmmo;
    final boolean antiExplosionEnabled = MiscUpgrade.ANTI_EXPLOSION.isEnabled();
    final boolean regenerate = LandExplosionManager.REGENERATE && this.antiExplosionEnabled;
    final boolean fancyExplosions = XReflection.supports((int)13) && KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_ENABLED.getManager().getBoolean();
    final boolean protectionSigns = KingdomsConfig.ProtectionSigns.PROTECTIONS_EXPLOSION.getManager().getBoolean();
    final boolean allowExplosionDuringInvasions = KingdomsConfig.Invasions.ALLOW_EXPLOSION.getManager().getBoolean();
    final boolean regenWilderness = MiscUpgrade.ANTI_EXPLOSION.getConfig().getBoolean("wilderness");
    final boolean dontDropKingdomItems = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_DROP_DESTROYED_KINGDOM_ITEMS.getManager().getBoolean();
    final Iterator<Block> iterator;
    final @Nullable Entity source;
    int stateIndex = 0;
    Block block;
    SimpleLocation location;
    Land land;
    Kingdom kingdom;
    Shield shieldToCheck;
    private final Kingdom cannonKingdom;
    BukkitTask regenerationTask;
    boolean baseBlocksBuilt;
    private final KLogger logger = new KLogger(KingdomsDebug.EXPLOSIONS);
    private int regulatorCaused;
    private int kingdomCaused;
    private final Event cause;
    private final Set<KingdomBuilding<?>> handledBuildings = Collections.newSetFromMap(new IdentityHashMap());

    LandExplosionHandler(Event cause, List<Block> blocks, @Nullable Entity source, @Nullable Pair<SiegeCannon, SiegeCannonAmmo> cannonProps) {
        int requiredLevel;
        IdentityHashMap<Land, Kingdom> trusted = new IdentityHashMap<Land, Kingdom>(9);
        if (this.regenerate) {
            LandExplosionManager.ONGOING_REGENERATIONS.add(this);
        }
        this.cannon = cannonProps == null ? null : cannonProps.getKey();
        SiegeCannonAmmo siegeCannonAmmo = this.cannonAmmo = cannonProps == null ? null : cannonProps.getValue();
        if (this.cannon != null) {
            LandExplosionManager.customExplosion(this.cannon, blocks, source.getLocation().getBlock(), this.cannon.getExplosionRadius(cannonProps.getValue()), false);
            this.cannonKingdom = this.cannon.getLand().getKingdom();
        } else {
            this.cannonKingdom = null;
        }
        this.cause = cause;
        this.source = source;
        this.iterator = blocks.iterator();
        this.states = this.regenerate ? new BlockState[blocks.size()] : null;
        this.requireBaseStates = this.regenerate ? new ArrayList() : null;
        this.containers = this.regenerate ? new HashMap() : null;
        int n = requiredLevel = source != null && source.getType() == EntityType.CREEPER ? 0 : 1;
        if (KLogger.isDebugging()) {
            this.logger.property((Object)"Source", source);
            this.logger.property((Object)"Blocks", blocks.size());
            this.logger.property((Object)"Has Cannon", this.cannon);
            this.logger.property((Object)"Fancy", this.fancyExplosions);
            this.logger.property((Object)"Regenerate", this.regenerate);
            this.logger.property((Object)"Anti-Explosion", this.antiExplosionEnabled);
            this.logger.property((Object)"Allow Explosion During Invasions", this.allowExplosionDuringInvasions);
        }
        while (this.iterator.hasNext()) {
            this.block = this.iterator.next();
            this.location = SimpleLocation.of(this.block);
            this.land = Land.getLand(this.location);
            this.kingdom = null;
            this.shieldToCheck = null;
            if (this.land == null) {
                this.animateBlock();
                continue;
            }
            this.kingdom = (Kingdom)trusted.get(this.land);
            if (this.kingdom != null) {
                this.handleLand();
                continue;
            }
            this.kingdom = this.land.getKingdom();
            if (this.kingdom == null) {
                if (this.handleKingdomItems(true) || !this.regenWilderness) continue;
                this.handleNormalBlock();
                continue;
            }
            if (this.protectionSigns && ProtectionSign.isProtected(this.block)) {
                if (this.canBreak(LandExplosionManager.BlockType.PROTECTED_BLOCK, () -> "everyone?")) continue;
                this.iterator.remove();
                continue;
            }
            if (this.isPacifist() || this.antiExplosionEnabled && this.kingdom.getMiscUpgrades().getOrDefault(MiscUpgrade.ANTI_EXPLOSION.getNamespace(), 0) > requiredLevel) {
                Regulator regulator = this.land.getStructure(Regulator.class);
                if (regulator != null && regulator.hasRule(Regulator.Rule.ALLOW_EXPLOSIONS)) {
                    ++this.regulatorCaused;
                    this.animateBlock();
                    this.handleKingdomItems(false);
                    continue;
                }
                trusted.put(this.land, this.kingdom);
                this.handleLand();
                continue;
            }
            ++this.kingdomCaused;
            this.handleKingdomItems(true);
            this.animateBlock();
        }
        if (this.kingdomCaused > 0) {
            this.logger.property((Object)"Blocks broken due to normal causes", this.kingdomCaused);
        }
        if (this.regulatorCaused > 0) {
            this.logger.property((Object)"Regulatored", this.regulatorCaused);
        }
        this.logger.property((Object)"Left Blocks", blocks.size());
        if (this.regenerate) {
            this.regenerateBlocks();
        }
        if (!this.regenerate) {
            this.logger.end();
        }
    }

    private boolean isPacifist() {
        return Shields.isEffectivelyPacifist(this.kingdom);
    }

    private void animateBlock() {
        if (this.fancyExplosions) {
            LandExplosionManager.fancyExplode(this.block);
        }
    }

    void handleLand() {
        if (!this.isPacifist()) {
            if (this.allowExplosionDuringInvasions && this.land.isBeingInvaded()) {
                this.animateBlock();
                this.handleKingdomItems(true);
                return;
            }
            if (this.handleKingdomItems(false)) {
                return;
            }
        }
        if (this.isPacifist() || !this.canBreak(LandExplosionManager.BlockType.OTHER, () -> XMaterial.matchXMaterial((Material)this.block.getType()).name())) {
            this.handleNormalBlock();
        }
    }

    private void handleNormalBlock() {
        if (this.regenerate && !this.block.getType().name().contains("CHEST")) {
            if (LandExplosionManager.BLOCKS_HOLDING_HANGING.containsKey(this.location)) {
                this.iterator.remove();
                return;
            }
            this.animateBlock();
            this.handleGeneration(this.block);
        } else {
            this.iterator.remove();
        }
    }

    boolean handleKingdomItems(boolean force) {
        KingdomBuilding hitBuilding = null;
        LandExplosionManager.BlockType blockType = null;
        BlockVector3 vector = this.location.toBlockVector();
        KingdomBlock block = this.land.unsafeGetKingdomBlocks().get(vector);
        if (block instanceof Structure) {
            hitBuilding = (Structure)block;
            blockType = LandExplosionManager.BlockType.STRUCTURE;
        } else if (block instanceof Turret) {
            hitBuilding = (Turret)block;
            blockType = LandExplosionManager.BlockType.TURRET;
        }
        if (hitBuilding == null) {
            return false;
        }
        if (this.handledBuildings.add(hitBuilding)) {
            KingdomBuilding finalItem = hitBuilding;
            if (force || this.canBreak(blockType, () -> ((KingdomBuildingStyle)finalItem.getStyle()).getName())) {
                KingdomBuilding finalKingdomItem = hitBuilding;
                this.logger.log(() -> "Kingdom item " + finalKingdomItem + " (" + ((KingdomBuildingStyle)finalKingdomItem.getStyle()).getName() + ") broke with explosion: " + force);
                if (this.cannonAmmo != null) {
                    this.cannonAmmo.getEffects().applyEffects(this.source.getLocation(), hitBuilding);
                }
            }
        }
        this.iterator.remove();
        return true;
    }

    private KingdomItemRemoveContext getBreakContext() {
        KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
        ctx.setCause(this.cause);
        ctx.setPlayer(this.getResponsiblePlayer());
        if (this.cannon != null) {
            ctx.setModifier(event -> event.getMetadata().put(SiegeCannon.NS, (Object)this.cannon));
        }
        return ctx;
    }

    KingdomPlayer getResponsiblePlayer() {
        return this.cannon == null ? null : KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.cannon.getHandler());
    }

    boolean canBreak(LandExplosionManager.BlockType blockType, Supplier<String> type) {
        if (this.cannon == null) {
            return false;
        }
        if (this.shieldToCheck == null) {
            this.shieldToCheck = Shields.getShieldToUse(this.kingdom).getShield();
        }
        if (this.shieldToCheck.hasShield()) {
            return false;
        }
        if (StandardRelationAttribute.BUILD.hasAttribute(this.kingdom, this.cannonKingdom)) {
            return false;
        }
        if (((StructureStyle)this.cannon.getStyle()).getOption("invasion-only").getBoolean() && !this.land.isUnderAttack()) {
            return false;
        }
        return this.cannon.canDamage(blockType, Strings.configOption(blockType) + 's', type);
    }

    void handleGeneration(Block block) {
        BlockState state = block.getState();
        ItemStack[] content = LandExplosionManager.getContainerContent(state);
        if (content != null) {
            this.containers.put(SimpleLocation.of(block), content);
        }
        if (LandExplosionManager.isAttachableOrHangingBlock(state)) {
            this.requireBaseStates.add(state);
        } else {
            this.states[this.stateIndex++] = state;
        }
        block.setType(Material.AIR, false);
    }

    void onRegenerationEnd() {
        if (this.regenerate) {
            LandExplosionManager.ONGOING_REGENERATIONS.remove(this);
        }
        this.regenerateEntities();
        this.logger.end();
    }

    void regenerateEntities() {
        if (this.source == null) {
            return;
        }
        List<Entity> entities = LandExplosionManager.EXPLODED_ENTITIES.remove(this.source);
        if (entities == null) {
            return;
        }
        for (Entity entity2 : entities) {
            entity2.setGravity(true);
            if (!(entity2 instanceof LivingEntity)) continue;
            ((LivingEntity)entity2).setAI(true);
            if (!XReflection.supports((int)17)) continue;
            ((LivingEntity)entity2).setInvisible(false);
            ParticleDisplay.of((XParticle)XParticle.CLOUD).withCount(50).offset(1.0).spawn(entity2.getLocation().add(0.0, 0.5, 0.0));
        }
        this.logger.property((Object)"Regenerated entities", entities.size());
    }

    public void forceFinishRegeneration() {
        if (this.regenerate && this.regenerationTask != null) {
            this.regenerationTask.cancel();
        }
        if (!this.baseBlocksBuilt) {
            while (this.stateIndex >= 0) {
                BlockState state = this.states[this.stateIndex];
                state.update(true);
                this.handleChest(state);
                if (--this.stateIndex >= 0) continue;
                this.baseBlocksBuilt = true;
                ++this.stateIndex;
                break;
            }
        }
        while (this.stateIndex < this.requireBaseStates.size()) {
            this.requireBaseStates.get(this.stateIndex++).update(true);
        }
        this.regenerateEntities();
    }

    void handleChest(BlockState state) {
        if (state instanceof InventoryHolder) {
            InventoryHolder inv = (InventoryHolder)state;
            ItemStack[] content = this.containers.get(SimpleLocation.of(state.getLocation()));
            if (inv instanceof Chest) {
                Chest chest = (Chest)inv;
                chest.getBlockInventory().setContents(content);
            } else {
                inv.getInventory().setContents(content);
            }
        }
    }

    void regenerateBlocks() {
        boolean bl = this.baseBlocksBuilt = this.stateIndex == 0;
        if (this.stateIndex == 0 && this.requireBaseStates.isEmpty()) {
            this.onRegenerationEnd();
            return;
        }
        if (this.stateIndex > 0) {
            --this.stateIndex;
        }
        Arrays.sort(this.states, (s1, s2) -> {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return Integer.compare(s2.getY(), s1.getY());
        });
        this.logger.log(() -> "Starting the regeneration of " + this.states.length + " blocks with " + this.requireBaseStates.size() + " bases.");
        this.regenerationTask = new BukkitRunnable(){

            public void run() {
                BlockState state;
                if (LandExplosionHandler.this.baseBlocksBuilt) {
                    BlockState state2;
                    try {
                        state2 = LandExplosionHandler.this.requireBaseStates.get(LandExplosionHandler.this.stateIndex++);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return;
                    }
                    if (!state2.update(true)) {
                        MessageHandler.sendConsolePluginMessage("&4Failed to update state for derived block regeneration: " + state2.getBlock());
                    }
                    if (LandExplosionHandler.this.stateIndex >= LandExplosionHandler.this.requireBaseStates.size()) {
                        this.cancel();
                    }
                    return;
                }
                try {
                    state = LandExplosionHandler.this.states[LandExplosionHandler.this.stateIndex];
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                if (state == null) {
                    if (LandExplosionHandler.this.requireBaseStates.isEmpty()) {
                        this.cancel();
                    } else {
                        LandExplosionHandler.this.baseBlocksBuilt = true;
                        LandExplosionHandler.this.stateIndex = 0;
                    }
                    return;
                }
                if (!state.update(true)) {
                    MessageHandler.sendConsolePluginMessage("&4Failed to update state for block regeneration: " + state.getBlock());
                }
                LandExplosionHandler.this.handleChest(state);
                if (--LandExplosionHandler.this.stateIndex < 0) {
                    if (LandExplosionHandler.this.requireBaseStates.isEmpty()) {
                        this.cancel();
                    } else {
                        LandExplosionHandler.this.baseBlocksBuilt = true;
                        ++LandExplosionHandler.this.stateIndex;
                    }
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                LandExplosionHandler.this.onRegenerationEnd();
            }
        }.runTaskTimer((Plugin)Kingdoms.get(), (long)KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_AUTO_REGENERATE_DELAY.getManager().getInt() * 20L, KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_AUTO_REGENERATE_INTERVAL.getManager().getLong());
    }
}

