/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityBuilder;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.entity.types.KingdomLandEntity;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.hash.EntityWeakHashMap;

public final class KingdomGuardManager
implements Listener {
    private static final String GUARD_METADATA = "GUARDS";
    private static final EntityWeakHashMap<Player, GuardSession> GUARDING = EntityHashMap.weakBuilder(Player.class).build();

    protected static void despawnGuards(Player player, boolean cancel) {
        GuardSession guards = GUARDING.remove(player);
        if (guards == null) {
            return;
        }
        if (cancel) {
            guards.autoCleaner.cancel();
        }
        ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.WITCH);
        for (KingdomEntity kingdomGuard : guards.guards) {
            LivingEntity guard = (LivingEntity)kingdomGuard.getEntity();
            if (!guard.isValid()) continue;
            display.spawn(guard.getLocation());
            guard.setHealth(0.0);
            KingdomEntityRegistry.remove(guard);
        }
    }

    public static void spawnGuards(MiscUpgrade type, Kingdom belongingKingdom, Player target, boolean useDelay, Function<LivingEntity, KingdomEntity> entityCtor) {
        if (!type.isEnabled()) {
            return;
        }
        int lvl = belongingKingdom.getUpgradeLevel(type);
        if (lvl <= 0) {
            return;
        }
        ConfigSection mainSection = KingdomsConfig.MISC_UPGRADE.accessor().gotoSection(type.getNamespace().getConfigOptionName()).getSection();
        KeyedYamlConfigAccessor option = KingdomsConfig.MiscUpgrades.LEVELS.getManager().noDefault().withOption("upgrade", type.getNamespace().getConfigOptionName()).withProperty(String.valueOf(lvl));
        YamlConfigAccessor section = option.getSection();
        if (section == null) {
            MessageHandler.sendConsolePluginMessage("&4Unknown level entry for &e" + type + " &cmisc upgrade at level&8: &e" + lvl);
            return;
        }
        if (useDelay) {
            int delay = mainSection.getInt("spawn-delay");
            if (delay <= 0) {
                delay = 0;
            } else {
                KingdomsLang.KINGDOM_GUARDS_SPAWNING.sendMessage((CommandSender)target, new MessagePlaceholderProvider().withContext(belongingKingdom));
            }
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> KingdomGuardManager.spawnGuards(belongingKingdom, target, section, entityCtor), (long)delay);
        } else {
            KingdomGuardManager.spawnGuards(belongingKingdom, target, section, entityCtor);
        }
    }

    public static void spawnGuards(Kingdom belongingKingdom, Player target, YamlConfigAccessor section, Function<LivingEntity, KingdomEntity> entityCtor) {
        Location location = target.getLocation();
        ArrayList group = new ArrayList();
        KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_SPAWNED, () -> "Spawning guards around " + target.getName() + " for kingdom " + belongingKingdom.getName());
        int insanity = belongingKingdom.getUpgradeLevel(MiscUpgrade.INSANITY);
        List effects = insanity > 0 ? XPotion.parseEffects(MiscUpgrade.INSANITY.getConfig().getStringList("effects", String.valueOf(insanity))) : new ArrayList();
        for (String guards : section.getKeys()) {
            YamlConfigAccessor guardSection = section.noDefault().gotoSection(guards);
            int total = Math.max(0, guardSection.getInt("amount"));
            int minRadius = 5;
            int maxRadius = 20;
            AtomicInteger i = new AtomicInteger();
            MessagePlaceholderProvider context = new MessagePlaceholderProvider().withContext(belongingKingdom);
            LocationUtils.attemptSafeLocation(minRadius, 3, maxRadius, 5, location, safeLoc -> {
                Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                    LivingEntity guard = new KingdomEntityBuilder().location(safeLoc == null ? location : safeLoc).settings(guardSection.getSection()).registrar(entityCtor).entityType(belongingKingdom.getName() + "'s guards").context(context).delayedRegistry().spawn();
                    for (XPotion.Effect effect : effects) {
                        effect.apply(guard);
                    }
                    if (guard instanceof Monster) {
                        ((Monster)guard).setTarget((LivingEntity)target);
                    }
                    KingdomEntity mob = (KingdomEntity)entityCtor.apply(guard);
                    guard.setMetadata(GUARD_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)mob));
                    group.add(mob);
                    KingdomEntityRegistry.add(mob);
                });
                return i.incrementAndGet() < total;
            });
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> KingdomGuardManager.despawnGuards(target, false), 1200L);
        GUARDING.put(target, new GuardSession(group, task));
    }

    @EventHandler
    public void onTargetQuit(PlayerQuitEvent event) {
        KingdomGuardManager.despawnGuards(event.getPlayer(), true);
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        KingdomGuardManager.despawnGuards(event.getEntity(), true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTargetTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT || event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        KingdomGuardManager.despawnGuards(event.getPlayer(), true);
    }

    public static void onGuardSpawn(LandChangeEvent event) {
        Player player = event.getPlayer();
        if (player.isInvulnerable()) {
            return;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (PlayerUtils.isEffectivelyInvisible(player)) {
            return;
        }
        if (ServiceHandler.isVanished(player)) {
            return;
        }
        if (GUARDING.containsKey(player)) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_SIMPLE$CHECKS, () -> "Kingdom guard spawning system has passed simple checks for " + player.getName());
        Land to = event.getToLand();
        if (to == null || !to.isClaimed()) {
            return;
        }
        KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin()) {
            return;
        }
        Kingdom playerKingdom = kp.getKingdom();
        if (playerKingdom != null && playerKingdom.isPacifist()) {
            return;
        }
        Kingdom landKingdom = to.getKingdom();
        if (StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(playerKingdom, landKingdom) || StandardRelationAttribute.CEASEFIRE.hasAttribute(playerKingdom, landKingdom)) {
            return;
        }
        MiscUpgrade upgrade = to.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus()) != null ? MiscUpgrade.NEXUS_GUARDS : MiscUpgrade.GUARDS;
        ConditionalExpression condition = upgrade.getConfig().getSection().getCondition("condition");
        if (condition != null && ConditionProcessor.process(condition, new MessagePlaceholderProvider().withContext(player).other(landKingdom))) {
            KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_ATTEMPT, () -> "Condition " + condition + " not passed for " + upgrade + " -> " + upgrade.isEnabled() + " with level " + landKingdom.getUpgradeLevel(upgrade));
            return;
        }
        KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_ATTEMPT, () -> "Attempting to spawn guards while upgrade is " + upgrade + " -> " + upgrade.isEnabled() + " with level " + landKingdom.getUpgradeLevel(upgrade));
        KingdomGuardManager.spawnGuards(upgrade, landKingdom, player, true, guard -> new KingdomLandEntity((Entity)guard, to, (LivingEntity)player));
    }

    private static final class GuardSession {
        private final List<KingdomEntity> guards;
        private final BukkitTask autoCleaner;

        private GuardSession(List<KingdomEntity> guards, BukkitTask autoCleaner) {
            this.guards = guards;
            this.autoCleaner = autoCleaner;
        }
    }
}

