/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.map;

import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.map.KingdomsMap;
import org.kingdoms.managers.land.map.KingdomsMapElement;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/managers/land/map/ClipboardKingdomsMapElement;", "Lorg/kingdoms/managers/land/map/KingdomsMapElement;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "clipboard", "Lorg/kingdoms/managers/land/claiming/ClaimClipboard;", "getClipboard", "()Lorg/kingdoms/managers/land/claiming/ClaimClipboard;", "getElement", "", "map", "Lorg/kingdoms/managers/land/map/KingdomsMap;", "core"})
public final class ClipboardKingdomsMapElement
implements KingdomsMapElement {
    @Nullable
    private final ClaimClipboard clipboard;

    public ClipboardKingdomsMapElement(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.clipboard = ClaimClipboard.getClipboards().get(player.getUniqueId());
    }

    @Nullable
    public final ClaimClipboard getClipboard() {
        return this.clipboard;
    }

    @Override
    @Nullable
    public String getElement(@NotNull KingdomsMap map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (this.clipboard == null) {
            return null;
        }
        AbstractClaimProcessor result = this.clipboard.getClaims().getProcessedClaims().get(map.chunk.worldlessWrapper());
        if (result != null) {
            if (!(result = result.reprocess()).isSuccessful()) {
                map.getSettings().inheritPlaceholders(result.getMessageContext());
                map.getSettings().raw("reason", result.getCombinedMessage());
            }
            return "clipboard." + (result.isSuccessful() ? "added" : "failed");
        }
        if (map.nationZone != null || map.kingdom != null) {
            return null;
        }
        return "clipboard.wilderness";
    }
}

