/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.distance;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.distance.BasePlayerLocationListener;
import org.kingdoms.managers.land.distance.DistanceChangeReason;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/managers/land/distance/DistanceManager;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onMove", "", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onTp", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "onWorldChange", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "Companion", "core"})
public final class DistanceManager
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double TRIGGER_DISTANCE_SQRT = Math.sqrt(10.0);
    @NotNull
    private static final Cache<UUID, BlockVector3> MOVEMENT_COOLDOWN;
    @NotNull
    private static final Set<BasePlayerLocationListener> ACTIONS;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Location location = event.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getFrom(...)");
        Location from = location;
        Location location2 = event.getTo();
        if (location2 == null) {
            return;
        }
        Location to = location2;
        int x = to.getBlockX();
        int y = to.getBlockY();
        int z = to.getBlockZ();
        if (from.getBlockX() == x && from.getBlockY() == y && from.getBlockZ() == z) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        BlockVector3 lastAcceptedMove = (BlockVector3)MOVEMENT_COOLDOWN.getIfPresent((Object)player2.getUniqueId());
        BlockVector3 currentLocation = new BlockVector3(x, y, z);
        if (lastAcceptedMove == null) {
            MOVEMENT_COOLDOWN.put((Object)player2.getUniqueId(), (Object)currentLocation);
        } else if (lastAcceptedMove.distanceSquared(currentLocation) <= TRIGGER_DISTANCE_SQRT) {
            return;
        }
        Companion.checkActions(player2, DistanceChangeReason.MOVED);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onTp(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Location location = event.getTo();
        Intrinsics.checkNotNull((Object)location);
        World world = event.getFrom().getWorld();
        Location location2 = event.getTo();
        Intrinsics.checkNotNull((Object)location2);
        Companion.checkActions(player, location, Intrinsics.areEqual((Object)world, (Object)location2.getWorld()) ? DistanceChangeReason.TELEPORTED : DistanceChangeReason.CHANGED_WORLDS);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onWorldChange(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Companion.checkActions(player, DistanceChangeReason.CHANGED_WORLDS);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Companion.checkActions(player, DistanceChangeReason.JOINED);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Companion.checkActions(player, DistanceChangeReason.LEFT);
    }

    @JvmStatic
    public static final void registerListener$core(@NotNull BasePlayerLocationListener listener) {
        Companion.registerListener$core(listener);
    }

    @JvmStatic
    public static final void checkActions(@NotNull Player player, @NotNull DistanceChangeReason reason) {
        Companion.checkActions(player, reason);
    }

    @JvmStatic
    public static final void checkActions(@NotNull Player player, @NotNull Location location, @NotNull DistanceChangeReason reason) {
        Companion.checkActions(player, location, reason);
    }

    @JvmStatic
    private static final void checkActions0(Player player, Location location, DistanceChangeReason reason) {
        DistanceManager.Companion.checkActions0(player, location, reason);
    }

    static {
        Cache cache = CacheHandler.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        MOVEMENT_COOLDOWN = cache;
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        ACTIONS = set;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/managers/land/distance/DistanceManager$Companion;", "", "<init>", "()V", "TRIGGER_DISTANCE_SQRT", "", "MOVEMENT_COOLDOWN", "Lorg/kingdoms/libs/caffeine/cache/Cache;", "Ljava/util/UUID;", "Lorg/kingdoms/server/location/BlockVector3;", "ACTIONS", "", "Lorg/kingdoms/managers/land/distance/BasePlayerLocationListener;", "registerListener", "", "listener", "registerListener$core", "checkActions", "player", "Lorg/bukkit/entity/Player;", "reason", "Lorg/kingdoms/managers/land/distance/DistanceChangeReason;", "location", "Lorg/bukkit/Location;", "checkActions0", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void registerListener$core(@NotNull BasePlayerLocationListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            ACTIONS.add(listener);
        }

        @JvmStatic
        public final void checkActions(@NotNull Player player, @NotNull DistanceChangeReason reason) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            this.checkActions(player, location, reason);
        }

        @JvmStatic
        public final void checkActions(@NotNull Player player, @NotNull Location location, @NotNull DistanceChangeReason reason) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            if (!((Collection)ACTIONS).isEmpty()) {
                Kingdoms.taskScheduler().async().execute(() -> Companion.checkActions$lambda$0(player, location, reason));
            }
        }

        @JvmStatic
        private final void checkActions0(Player player, Location location, DistanceChangeReason reason) {
            if (reason == DistanceChangeReason.INIT) {
                throw new IllegalStateException("Reason cannot be init");
            }
            Iterator iter = ACTIONS.iterator();
            while (iter.hasNext()) {
                BasePlayerLocationListener next = (BasePlayerLocationListener)iter.next();
                if (next.getClosed$core()) {
                    iter.remove();
                    continue;
                }
                next.checkActions$core(player, location, reason);
            }
        }

        private static final void checkActions$lambda$0(Player $player, Location $location, DistanceChangeReason $reason) {
            Companion.checkActions0($player, $location, $reason);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

