/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming.bulk;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BulkClaimProcessor;
import org.kingdoms.server.location.BlockVector2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/managers/land/claiming/bulk/MixedBulkClaimProcessor;", "Lorg/kingdoms/managers/land/claiming/bulk/BulkClaimProcessor;", "claimingContext", "Lorg/kingdoms/managers/land/claiming/ClaimProcessor;", "unclaimingContext", "Lorg/kingdoms/managers/land/claiming/UnclaimProcessor;", "<init>", "(Lorg/kingdoms/managers/land/claiming/ClaimProcessor;Lorg/kingdoms/managers/land/claiming/UnclaimProcessor;)V", "claims", "Ljava/util/LinkedHashMap;", "Lorg/kingdoms/server/location/BlockVector2;", "Lorg/kingdoms/managers/land/claiming/AbstractClaimProcessor;", "Lorg/kingdoms/managers/land/claiming/bulk/ProcessedClaims;", "specialHandling", "", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "Lorg/kingdoms/managers/land/claiming/AbstractClaimProcessor$ChunkHandling;", "addBatch", "", "claiming", "", "chunk", "getProcessedClaims", "core"})
public class MixedBulkClaimProcessor
implements BulkClaimProcessor {
    @NotNull
    private final ClaimProcessor claimingContext;
    @NotNull
    private final UnclaimProcessor unclaimingContext;
    @NotNull
    private final LinkedHashMap<BlockVector2, AbstractClaimProcessor> claims;
    @NotNull
    private final Map<SimpleChunkLocation, AbstractClaimProcessor.ChunkHandling> specialHandling;

    public MixedBulkClaimProcessor(@NotNull ClaimProcessor claimingContext, @NotNull UnclaimProcessor unclaimingContext) {
        Intrinsics.checkNotNullParameter((Object)claimingContext, (String)"claimingContext");
        Intrinsics.checkNotNullParameter((Object)unclaimingContext, (String)"unclaimingContext");
        this.claimingContext = claimingContext;
        this.unclaimingContext = unclaimingContext;
        this.claims = new LinkedHashMap();
        this.specialHandling = new HashMap();
        this.claimingContext.specialHandling(this.specialHandling);
        this.unclaimingContext.specialHandling(this.specialHandling);
    }

    public void addBatch(boolean claiming, @NotNull SimpleChunkLocation chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        AbstractClaimProcessor abstractClaimProcessor = (claiming ? (AbstractClaimProcessor)this.claimingContext : (AbstractClaimProcessor)this.unclaimingContext).clone();
        Intrinsics.checkNotNullExpressionValue((Object)abstractClaimProcessor, (String)"clone(...)");
        AbstractClaimProcessor processor = abstractClaimProcessor;
        processor.setChunk(chunk);
        this.specialHandling.put(chunk, claiming ? AbstractClaimProcessor.ChunkHandling.CLAIMED : AbstractClaimProcessor.ChunkHandling.UNCLAIMED);
        ((Map)this.claims).put(processor.getChunk().worldlessWrapper(), processor);
    }

    @Override
    @NotNull
    public LinkedHashMap<BlockVector2, AbstractClaimProcessor> getProcessedClaims() {
        return this.claims;
    }
}

