/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming.bulk;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BulkClaimProcessor;
import org.kingdoms.server.location.BlockVector2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0012J\u0015\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u000bj\u0002`\rH\u0016R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u000bj\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/managers/land/claiming/bulk/BasicBulkClaimProcessor;", "T", "Lorg/kingdoms/managers/land/claiming/AbstractClaimProcessor;", "Lorg/kingdoms/managers/land/claiming/bulk/BulkClaimProcessor;", "context", "<init>", "(Lorg/kingdoms/managers/land/claiming/AbstractClaimProcessor;)V", "Lorg/kingdoms/managers/land/claiming/AbstractClaimProcessor;", "claiming", "", "claims", "Ljava/util/LinkedHashMap;", "Lorg/kingdoms/server/location/BlockVector2;", "Lorg/kingdoms/managers/land/claiming/bulk/ProcessedClaims;", "getClaims", "()Ljava/util/LinkedHashMap;", "specialHandling", "", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "Lorg/kingdoms/managers/land/claiming/AbstractClaimProcessor$ChunkHandling;", "isProcessed", "chunk", "addBatch", "(Lorg/kingdoms/constants/land/location/SimpleChunkLocation;)Lorg/kingdoms/managers/land/claiming/AbstractClaimProcessor;", "getProcessedClaims", "core"})
public class BasicBulkClaimProcessor<T extends AbstractClaimProcessor>
implements BulkClaimProcessor {
    @NotNull
    private final T context;
    private final boolean claiming;
    @NotNull
    private final LinkedHashMap<BlockVector2, AbstractClaimProcessor> claims;
    @NotNull
    private final Map<SimpleChunkLocation, AbstractClaimProcessor.ChunkHandling> specialHandling;

    public BasicBulkClaimProcessor(@NotNull T context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.context = context;
        this.claiming = this.context instanceof ClaimProcessor;
        this.claims = new LinkedHashMap();
        this.specialHandling = new HashMap();
        ((AbstractClaimProcessor)this.context).specialHandling(this.specialHandling);
    }

    @NotNull
    public final LinkedHashMap<BlockVector2, AbstractClaimProcessor> getClaims() {
        return this.claims;
    }

    public final boolean isProcessed(@NotNull SimpleChunkLocation chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        return this.claims.containsKey(chunk.toBlockVector());
    }

    @NotNull
    public T addBatch(@NotNull SimpleChunkLocation chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        AbstractClaimProcessor abstractClaimProcessor = ((AbstractClaimProcessor)this.context).clone();
        Intrinsics.checkNotNullExpressionValue((Object)abstractClaimProcessor, (String)"clone(...)");
        AbstractClaimProcessor processor = abstractClaimProcessor;
        processor.setChunk(chunk);
        this.specialHandling.put(chunk, this.claiming ? AbstractClaimProcessor.ChunkHandling.CLAIMED : AbstractClaimProcessor.ChunkHandling.UNCLAIMED);
        ((Map)this.claims).put(processor.getChunk().worldlessWrapper(), processor);
        return (T)processor;
    }

    @Override
    @NotNull
    public LinkedHashMap<BlockVector2, AbstractClaimProcessor> getProcessedClaims() {
        return this.claims;
    }
}

