/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshotManager;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotPath;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimProcessorBuilder;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.chunks.ChunkConnections;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.time.TimeFormatter;

public class UnclaimProcessor
extends AbstractClaimProcessor {
    private static final Cooldown<SimpleChunkLocation> COOLDOWN = new Cooldown();
    private boolean confirmed = true;
    private static ClaimProcessorBuilder<UnclaimProcessor> builder = UnclaimProcessor::new;

    public static ClaimProcessorBuilder<UnclaimProcessor> getBuilder() {
        return builder;
    }

    public static void setBuilder(ClaimProcessorBuilder<UnclaimProcessor> builder) {
        UnclaimProcessor.builder = Objects.requireNonNull(builder, "UnclaimProcessor builder cannot be null");
    }

    public static UnclaimProcessor build(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
        return builder.build(chunk, kp, kingdom);
    }

    protected UnclaimProcessor(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
        super(chunk, kp, kingdom);
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    @Override
    public AbstractClaimProcessor reprocess() {
        return this.clone().process();
    }

    @Override
    public UnclaimProcessor clone() {
        UnclaimProcessor processor = UnclaimProcessor.build(this.chunk, this.kp, this.kingdom);
        processor.confirmed = this.confirmed;
        if (this.specialChunks != null) {
            processor.specialChunks = this.specialChunks;
        }
        return processor;
    }

    @Override
    public Messenger initialChecks() {
        return this.checkWorldAndPermission();
    }

    @Override
    public UnclaimProcessor process() {
        Messenger issue = this.processIssue();
        if (issue != null) {
            this.fail(issue);
        }
        return this;
    }

    @Override
    public boolean finalizeProcess() {
        boolean result = super.finalizeProcess();
        if (result && KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean()) {
            ChunkSnapshotManager.queueRestoration(new ChunkSnapshotPath(this.chunk, ChunkSnapshotPath.TYPE_UNCLAIM).latest());
        }
        return result;
    }

    @Override
    public Messenger checkWorldAndPermission() {
        boolean canUnclaimAny = this.kp.hasPermission(StandardKingdomPermission.UNCLAIM);
        if (!canUnclaimAny && !this.kp.hasPermission(StandardKingdomPermission.UNCLAIM_OWNED)) {
            return StandardKingdomPermission.UNCLAIM.getDeniedMessage();
        }
        if (!this.kp.isAdmin()) {
            Land land = this.getLand();
            if (!canUnclaimAny && !this.kp.getId().equals(land.getClaimedBy())) {
                this.var("claimer", Bukkit.getOfflinePlayer((UUID)land.getClaimedBy()).getName());
                return KingdomsLang.PERMISSIONS_UNCLAIM_OWNED;
            }
        }
        return null;
    }

    @Override
    public Messenger processIssue() {
        Messenger issue = this.initialChecks();
        if (issue != null) {
            return issue;
        }
        issue = this.checkCooldown();
        if (issue != null) {
            return issue;
        }
        Land land = this.getLand();
        if (land == null || !land.isClaimed()) {
            return KingdomsLang.COMMAND_UNCLAIM_NOT_CLAIMED;
        }
        if (!this.kingdom.isClaimed(this.chunk)) {
            KingdomRelation relation;
            Kingdom occupiedKingdom = land.getKingdom();
            KingdomRelation kingdomRelation = relation = occupiedKingdom != null ? this.kingdom.getRelationWith(occupiedKingdom) : null;
            if (relation == KingdomRelation.TRUCE || relation == KingdomRelation.ALLY) {
                return KingdomsLang.COMMAND_UNCLAIM_OCCUPIED_FRIENDLY_LAND;
            }
            return KingdomsLang.COMMAND_UNCLAIM_OCCUPIED_LAND;
        }
        if (!this.kp.isAdmin()) {
            Pair<Long, Double> costs = UnclaimProcessor.calculateRefund(this.kingdom, 1, this.auto);
            if (costs != null) {
                this.rp = costs.getKey();
                this.money = costs.getValue();
                this.var("rp", this.rp);
                this.var("money", this.money);
            }
            if (land.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus()) != null && !KingdomsConfig.NEXUS_ALLOW_REMOVAL.getBoolean()) {
                return KingdomsLang.COMMAND_UNCLAIM_CANNOT_REMOVE_NEXUS;
            }
        }
        if ((issue = this.checkConfirmation()) != null) {
            return issue;
        }
        issue = this.disconnectsLandsAfterUnclaim();
        return issue;
    }

    public Messenger checkCooldown() {
        long unclaimCd = COOLDOWN.getTimeLeft(this.chunk);
        if (unclaimCd > 0L) {
            this.var("time", TimeFormatter.of(unclaimCd));
            return KingdomsLang.COMMAND_UNCLAIM_COOLDOWN;
        }
        return null;
    }

    public Messenger checkConfirmation() {
        if (!this.confirmed) {
            Land land = this.getLand();
            if (KingdomsConfig.Claims.UNCLAIM_CONFIRMATION_HOME.getManager().getBoolean() && land.isHomeLand()) {
                return KingdomsLang.COMMAND_UNCLAIM_CONFIRMATION_HOME;
            }
            if (KingdomsConfig.Claims.UNCLAIM_CONFIRMATION_STRUCTURES.getManager().getBoolean() && !land.getStructures().isEmpty()) {
                return KingdomsLang.COMMAND_UNCLAIM_CONFIRMATION_STRUCTURES;
            }
            if (KingdomsConfig.Claims.UNCLAIM_CONFIRMATION_TURRETS.getManager().getBoolean() && !land.getTurrets().isEmpty()) {
                return KingdomsLang.COMMAND_UNCLAIM_CONFIRMATION_TURRETS;
            }
        }
        return null;
    }

    public Messenger disconnectsLandsAfterUnclaim() {
        boolean disconnects = ChunkConnections.disconnectsClaimsAfterUnclaim(this.chunk.getWorld(), this.kingdom, ChunkConnections.getConnectionRadius(), x -> x.equals(this.chunk));
        return disconnects ? KingdomsLang.COMMAND_UNCLAIM_DISCONNECTION : null;
    }

    public static Pair<Long, Double> calculateRefund(Kingdom kingdom, int lands, boolean auto) {
        int remainingLands;
        int starterPackLeft;
        int starterPack = KingdomsConfig.Claims.STARTER_FREE.getManager().getInt();
        int currentLands = kingdom.getLandLocations().size();
        if (currentLands - lands <= starterPack && (lands -= (starterPackLeft = starterPack - (remainingLands = currentLands - lands))) <= 0) {
            return null;
        }
        PlaceholderContextBuilder ctx = new PlaceholderContextBuilder().withContext(kingdom);
        KingdomsConfig.Claims rpOpt = auto ? KingdomsConfig.Claims.RESOURCE_POINTS_REFUND_AUTO_UNCLAIM : KingdomsConfig.Claims.RESOURCE_POINTS_REFUND_UNCLAIM;
        long rp = (long)MathUtils.eval(rpOpt.getManager().getMathExpression(), (PlaceholderProvider)ctx);
        double money = 0.0;
        if (ServiceHandler.bankServiceAvailable()) {
            KingdomsConfig.Claims moneyOpt = auto ? KingdomsConfig.Claims.MONEY_REFUND_AUTO_UNCLAIM : KingdomsConfig.Claims.MONEY_REFUND_UNCLAIM;
            money = MathUtils.eval(moneyOpt.getManager().getMathExpression(), (PlaceholderProvider)ctx);
        }
        return Pair.of(rp * (long)lands, money * (double)lands);
    }

    public static Cooldown<SimpleChunkLocation> getUnclaimCooldown() {
        return COOLDOWN;
    }
}

