/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.kingdoms.abstraction.processor.AbstractKingdomsProcessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.messenger.Messenger;

public abstract class AbstractClaimProcessor
extends AbstractKingdomsProcessor
implements Cloneable {
    protected Map<SimpleChunkLocation, ChunkHandling> specialChunks;
    protected SimpleChunkLocation chunk;
    protected boolean ignoreAdmin;
    private Optional<Land> land;
    protected KingdomPlayer kp;
    protected Kingdom kingdom;
    protected boolean auto;
    protected long rp;
    protected double money;

    public abstract AbstractClaimProcessor clone();

    public @Nullable ChunkHandling getSpecialHandling(SimpleChunkLocation chunk) {
        return this.specialChunks == null ? null : this.specialChunks.get(chunk);
    }

    public boolean isAdminMode() {
        return !this.ignoreAdmin && this.kp.isAdmin();
    }

    public AbstractClaimProcessor(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
        this.chunk = Objects.requireNonNull(chunk, "Cannot process null chunk");
        this.kp = Objects.requireNonNull(kp, "Player performer cannot be null");
        this.kingdom = Objects.requireNonNull(kingdom, "Kingdom cannot be null");
        this.getMessageContext().withContext(kp.getOfflinePlayer());
        this.var("x", chunk.getX());
        this.var("z", chunk.getZ());
    }

    public AbstractClaimProcessor specialHandling(Map<SimpleChunkLocation, ChunkHandling> specialChunks) {
        this.specialChunks = specialChunks;
        return this;
    }

    public Map<SimpleChunkLocation, ChunkHandling> getSpecialChunks() {
        return this.specialChunks;
    }

    public void asAuto() {
        this.auto = true;
    }

    @Override
    public abstract AbstractClaimProcessor reprocess();

    protected Messenger initialChecks() {
        return null;
    }

    @Override
    public abstract AbstractClaimProcessor process();

    public abstract Messenger checkWorldAndPermission();

    @Override
    public boolean finalizeProcess() {
        super.finalizeProcess();
        if (!this.kp.isAdmin()) {
            if (this.money != 0.0) {
                this.kingdom.getBank().add(this.money);
            }
            if (this.rp != 0L) {
                this.kingdom.getResourcePoints().add(this.rp);
            }
        }
        return true;
    }

    public long getResourcePoints() {
        return this.rp;
    }

    public double getMoney() {
        return this.money;
    }

    public Kingdom getKingdom() {
        return this.kingdom;
    }

    public SimpleChunkLocation getChunk() {
        return this.chunk;
    }

    public Land getLand() {
        if (this.land != null) {
            return this.land.orElse(null);
        }
        this.land = Optional.ofNullable(Land.getLand(this.chunk));
        return this.land.orElse(null);
    }

    public void setChunk(Land land) {
        this.land = Optional.ofNullable(land);
        this.chunk = land.getLocation();
    }

    public void setChunk(SimpleChunkLocation chunk) {
        this.chunk = chunk;
        this.land = null;
    }

    public static enum ChunkHandling {
        CLAIMED,
        UNCLAIMED;

    }
}

