/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.block;

import org.bukkit.event.block.BlockBreakEvent;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.building.info.BuildingFunctionalPoint;
import org.kingdoms.constants.land.building.info.BuildingSettings;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.land.block.KingdomsBlockContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/managers/land/block/KingdomsBlockBreakContext;", "T", "Lorg/kingdoms/constants/land/KingdomBlock;", "Lorg/kingdoms/managers/land/block/KingdomsBlockContext;", "cause", "Lorg/bukkit/event/block/BlockBreakEvent;", "block", "player", "Lorg/kingdoms/constants/player/KingdomPlayer;", "<init>", "(Lorg/bukkit/event/block/BlockBreakEvent;Lorg/kingdoms/constants/land/KingdomBlock;Lorg/kingdoms/constants/player/KingdomPlayer;)V", "getCause", "()Lorg/bukkit/event/block/BlockBreakEvent;", "getBlock", "()Lorg/kingdoms/constants/land/KingdomBlock;", "Lorg/kingdoms/constants/land/KingdomBlock;", "isFunctionalPoint", "", "type", "", "getFunctionalPoint", "Lorg/kingdoms/constants/land/building/info/BuildingFunctionalPoint;", "core"})
public class KingdomsBlockBreakContext<T extends KingdomBlock>
extends KingdomsBlockContext {
    @NotNull
    private final BlockBreakEvent cause;
    @NotNull
    private final T block;

    public KingdomsBlockBreakContext(@NotNull BlockBreakEvent cause, @NotNull T block, @NotNull KingdomPlayer player) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player, false, 2, null);
        this.cause = cause;
        this.block = block;
    }

    @NotNull
    public final BlockBreakEvent getCause() {
        return this.cause;
    }

    @NotNull
    public final T getBlock() {
        return this.block;
    }

    public final boolean isFunctionalPoint(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.getFunctionalPoint(type) != null;
    }

    @Nullable
    public final BuildingFunctionalPoint getFunctionalPoint(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        SimpleLocation simpleLocation = SimpleLocation.of(this.cause.getBlock());
        Intrinsics.checkNotNullExpressionValue((Object)simpleLocation, (String)"of(...)");
        return BuildingSettings.Companion.getFunctionalPoint(simpleLocation, type);
    }
}

