/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.invasions;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.entity.types.KingdomLandEntity;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.bossbars.BossBarSession;
import org.kingdoms.utils.chunks.ChunkLocationMapper;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.string.Strings;

public class Plunder
extends Invasion {
    private static final DecimalFormat PROGRESS_FORMAT = new DecimalFormat("#,##0.0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final QuickEnumMap<State, OptionCache> cache = new QuickEnumMap((Enum[])State.values());
    protected double captureProgress;
    protected State state = State.CAPTURING;
    protected Consumer<TickData> tickProcessor;
    protected boolean tugOfWarMode = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_TUG_OF_WAR_ENABLED.getManager().getBoolean();
    private final double captureProgressGoal = MathUtils.eval(KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_GOAL.getManager().getMathExpression(), (PlaceholderProvider)this.getMessageContext());
    protected final double endlessModeMax;

    public double getCaptureProgress() {
        return this.captureProgress;
    }

    public void setTickProcessor(Consumer<TickData> tickProcessor) {
        this.tickProcessor = tickProcessor;
    }

    public void setCaptureProgress(double captureProgress) {
        this.captureProgress = captureProgress;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Plunder(KingdomPlayer invader, Land originLand, Set<SimpleChunkLocation> affectedLands, Location startLocation, boolean ransackMode) {
        super(invader, originLand, affectedLands, startLocation, ransackMode);
        if (this.attackerDeathLimit <= 0) {
            KLogger.error("Cannot start plunder invasion with the current player-death option: defender=" + this.defenderDeathLimit + ", attacker=" + this.attackerDeathLimit + " defaulting attacker's death limit back to 10");
            this.attackerDeathLimit = 10;
        }
        if (this.tugOfWarMode) {
            this.captureProgress = MathUtils.eval(KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_TUG_OF_WAR_INITIAL_GOAL.getManager().getMathExpression(), (PlaceholderProvider)this.getMessageContext());
        }
        this.endlessModeMax = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_ENDLESS_MODE_ENABLED.getManager().getBoolean() ? KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_ENDLESS_MODE_MAX.getManager().getDouble() : 0.0;
    }

    public boolean isEndlessMode() {
        return this.endlessModeMax != 0.0;
    }

    @Override
    public void start() {
        this.finalizePreparation();
        this.setupBossBars();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), this::usePlunderTask);
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider builder) {
        super.addMessageContextEdits(builder);
        builder.raws("capture-progress", PROGRESS_FORMAT.format(this.captureProgress), "capture-progress-goal", this.captureProgressGoal);
    }

    public void usePlunderTask() {
        int captureProgressBossBar;
        String cpbar;
        ConfigSection progressSection = KingdomsConfig.INVASIONS.accessor().gotoSection("bossbar").getSection();
        final double range = this.getVisualRange();
        if (this.getAttackerProgress() != null) {
            progressSection = KingdomsConfig.INVASIONS.accessor().gotoSection("plunder", "defender-bossbar").getSection();
            this.defenderProgress = BossBarSession.from(progressSection);
        }
        switch (cpbar = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_BOSSBAR_USE.getManager().getString().toLowerCase(Locale.ENGLISH)) {
            case "none": {
                captureProgressBossBar = 0;
                break;
            }
            case "normal": {
                captureProgressBossBar = 1;
                break;
            }
            case "timer": {
                captureProgressBossBar = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown capture progress boss bar mode: " + cpbar);
            }
        }
        this.initializeCache();
        if (range <= 0.0) {
            this.addBossBarToAllMembers();
        }
        final ChunkLocationMapper mappedParticles = KingdomsConfig.Invasions.PLUNDER_PARTICLES_ENABLED.getManager().getBoolean() ? new ChunkLocationMapper(this.getAffectedLands(), true, 0, 70.0).populateLocations() : null;
        final int startLocationY = this.startLocation.getBlockY();
        this.setTask(new BukkitRunnable(){
            final Kingdom defenderKingdom;
            final Kingdom attackerKingdom;
            final BossBarSession progressBossBar;
            final BossBarSession timeLimitBossBar;
            final long duration;
            final MathExpression captureProgressIncrement;
            final MathExpression captureProgressDecrement;
            final Location landLocation;
            final boolean considerMobs;
            int nearbyCheck;
            int particleTick;
            final boolean verticalBoundaries;
            final int maxY;
            final int minY;
            {
                this.defenderKingdom = Plunder.this.getDefender();
                this.attackerKingdom = Plunder.this.getAttacker();
                this.progressBossBar = Plunder.this.getAttackerProgress();
                this.timeLimitBossBar = Plunder.this.getTimeLimitProgress();
                this.duration = Plunder.this.getDuration();
                this.captureProgressIncrement = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_INCREMENT.getManager().getMathExpression();
                this.captureProgressDecrement = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_TUG_OF_WAR_DEFENDERS_DECREMENT.getManager().getMathExpression();
                this.landLocation = range > 0.0 ? Plunder.this.getStartLocation() : null;
                this.considerMobs = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_CONSIDER_KINGDOM_MOBS.getManager().getBoolean();
                this.nearbyCheck = 100;
                this.verticalBoundaries = KingdomsConfig.Invasions.PLUNDER_VERTICAL_BOUNDARIES_ENABLED.getManager().getBoolean();
                this.maxY = startLocationY + KingdomsConfig.Invasions.PLUNDER_VERTICAL_BOUNDARIES_UPWARDS.getManager().getInt();
                this.minY = startLocationY - KingdomsConfig.Invasions.PLUNDER_VERTICAL_BOUNDARIES_DOWNWARDS.getManager().getInt();
            }

            public void run() {
                if (mappedParticles != null && this.particleTick++ % 30 == 0) {
                    Plunder.this.spawnParticles(mappedParticles.getBorderLocations(), mappedParticles.getInsideLocations());
                }
                if (Plunder.this.champion != null && Plunder.this.champion.isValid()) {
                    Plunder.this.championAbilitiesTick();
                }
                long timePassed = Plunder.this.getTimePassed();
                if (this.duration != 0L && timePassed >= this.duration) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Plunder.this.end(Invasion.Result.TIMES_UP));
                    this.cancel();
                    return;
                }
                int totalAttackers = 0;
                int totalDefenders = 0;
                for (LivingEntity entity2 : Plunder.this.getEntitiesInArea()) {
                    KingdomEntity kingdomEntity;
                    int y;
                    if (this.verticalBoundaries && ((y = entity2.getLocation().getBlockY()) < this.minY || y > this.maxY)) continue;
                    if (entity2 instanceof Player) {
                        Player player = (Player)entity2;
                        if (this.defenderKingdom.isMember((OfflinePlayer)player)) {
                            ++totalDefenders;
                            continue;
                        }
                        if (!this.attackerKingdom.isMember((OfflinePlayer)player)) continue;
                        ++totalAttackers;
                        continue;
                    }
                    if (!this.considerMobs || !((kingdomEntity = KingdomEntityRegistry.get((Entity)entity2)) instanceof KingdomLandEntity) || !((KingdomLandEntity)kingdomEntity).getKingdom().getId().equals(this.defenderKingdom.getId())) continue;
                    ++totalDefenders;
                }
                boolean cancelled = false;
                if (Plunder.this.tickProcessor != null) {
                    TickData data = new TickData(totalAttackers, totalDefenders);
                    Plunder.this.tickProcessor.accept(data);
                    cancelled = data.cancelled;
                }
                if (!cancelled) {
                    if (totalAttackers > totalDefenders) {
                        Plunder.this.captureProgress += MathUtils.eval(this.captureProgressIncrement, (PlaceholderProvider)Plunder.this.getMessageContext());
                        Plunder.this.state = State.CAPTURING;
                    } else {
                        Plunder.this.captureProgress -= MathUtils.eval(this.captureProgressDecrement, (PlaceholderProvider)Plunder.this.getMessageContext());
                        Plunder.this.state = State.PROTECTED;
                    }
                    Plunder.this.captureProgress = Math.min(Plunder.this.captureProgress = Math.max(0.0, Plunder.this.captureProgress), Plunder.this.isEndlessMode() ? Plunder.this.endlessModeMax : Plunder.this.captureProgressGoal);
                }
                if (Plunder.this.captureProgress >= Plunder.this.captureProgressGoal && !Plunder.this.isEndlessMode()) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Plunder.this.end(Invasion.Result.SUCCESS));
                    this.cancel();
                    return;
                }
                BarColor stateColor = ((OptionCache)Plunder.this.cache.get((Object)Plunder.this.state)).color;
                if (captureProgressBossBar == 1) {
                    if (Plunder.this.getAttackerProgress() != null) {
                        Plunder.this.getAttackerProgress().setColor(stateColor);
                    }
                    if (Plunder.this.getDefenderProgress() != null) {
                        Plunder.this.getDefenderProgress().setColor(stateColor);
                    }
                } else if (captureProgressBossBar == 2 && this.timeLimitBossBar != null) {
                    this.timeLimitBossBar.setColor(stateColor);
                }
                if (this.progressBossBar != null || this.timeLimitBossBar != null) {
                    if (this.progressBossBar != null) {
                        double percent = captureProgressBossBar == 1 ? Plunder.this.getBossBarCaptureProgress() : (Plunder.this.reverseProgress ? ((double)Plunder.this.defenderDeathLimit - Plunder.this.getAttackerScore()) / (double)Plunder.this.defenderDeathLimit : Plunder.this.getAttackerScore() / (double)Plunder.this.defenderDeathLimit);
                        Plunder.this.updateProgress(this.progressBossBar, percent);
                    }
                    if (Plunder.this.getDefenderProgress() != null) {
                        double percent = captureProgressBossBar == 1 ? Plunder.this.getBossBarCaptureProgress() : (Plunder.this.reverseProgress ? ((double)Plunder.this.attackerDeathLimit - Plunder.this.getDefenderScore()) / (double)Plunder.this.attackerDeathLimit : Plunder.this.getDefenderScore() / (double)Plunder.this.attackerDeathLimit);
                        Plunder.this.updateProgress(Plunder.this.getDefenderProgress(), percent);
                    }
                    Plunder.this.updateTimeLimitBossBar(timePassed, this.defenderKingdom, () -> captureProgressBossBar == 2 ? Double.valueOf(Plunder.this.getBossBarCaptureProgress()) : null);
                    if (range > 0.0 && this.nearbyCheck++ == 100) {
                        this.nearbyCheck = 0;
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Plunder.this.updateRangedBossBar(range, this.landLocation));
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 1L));
    }

    private void initializeCache() {
        YamlConfigAccessor barColorSection = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_BOSSBAR_STATE_COLORS.getManager().getSection();
        YamlConfigAccessor particles = KingdomsConfig.Invasions.PLUNDER_PARTICLES_STATES.getManager().getSection();
        for (State state : State.values()) {
            String config = Strings.configOption(state);
            BarColor color = BarColor.valueOf((String)barColorSection.getString(config).toUpperCase(Locale.ENGLISH));
            ParticleDisplay particle = ParticleDisplay.fromConfig((ConfigurationSection)particles.gotoSection(config).toBukkitConfigurationSection());
            this.cache.put(state, new OptionCache(particle, color));
        }
    }

    private double getBossBarCaptureProgress() {
        double goal = this.isEndlessMode() ? this.endlessModeMax : this.captureProgressGoal;
        return this.reverseProgress ? (goal - this.captureProgress) / goal : this.captureProgress / goal;
    }

    public void spawnParticles(List<Location> particles, List<Location> barracksParticles) {
        ParticleDisplay particle = this.cache.get((Object)this.state).particle;
        for (Location loc : particles) {
            particle.spawn(loc);
        }
        for (Location loc : barracksParticles) {
            int constRand = Math.abs((loc.getBlockY() + loc.getBlockX() + loc.getBlockZ() * 65 / 8) % 4);
            World world = loc.getWorld();
            switch (constRand) {
                case 0: {
                    world.playEffect(loc, Effect.MOBSPAWNER_FLAMES, 1);
                }
                case 1: {
                    ParticleDisplay.of((XParticle)XParticle.LARGE_SMOKE).withLocation(loc).directional().offset(0.0, 0.1, 0.0).withExtra(0.5).spawn();
                    break;
                }
                case 2: {
                    ParticleDisplay.of((XParticle)XParticle.CAMPFIRE_COSY_SMOKE).withLocation(loc).directional().offset(0.0, 0.1, 0.0).withExtra(0.5).spawn();
                    break;
                }
                case 3: {
                    ParticleDisplay.of((XParticle)XParticle.DUST).withColor(Color.BLACK, 3.0f).withLocation(loc).withCount(2).spawn();
                }
            }
        }
    }

    public double getAttackerCaptureProgress() {
        return this.captureProgress;
    }

    public static enum State {
        CAPTURING,
        PROTECTED;

    }

    private static final class OptionCache {
        private final ParticleDisplay particle;
        private final BarColor color;

        private OptionCache(ParticleDisplay particle, BarColor color) {
            this.particle = particle;
            this.color = color;
        }
    }

    public static class TickData {
        public final int totalAttackers;
        public final int totalDefenders;
        public boolean cancelled = false;

        public TickData(int totalAttackers, int totalDefenders) {
            this.totalAttackers = totalAttackers;
            this.totalDefenders = totalDefenders;
        }
    }
}

