/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.invasions;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.EnumConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.invasion.KingdomInvadeEvent;
import org.kingdoms.events.invasion.KingdomPreInvadeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.invasions.Plunder;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.caffeine.ExpirableMap;

public final class InvasionFactory {
    public static final ExpirableMap<UUID, Long> TOTAL_PLAYTIME = new ExpirableMap();

    public static @NonNull KingdomPreInvadeEvent standardInvasion(Land originLand, Set<SimpleChunkLocation> affectedLands, Player player, boolean ransackMode) {
        KingdomPlayer invader = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean plunderMode = KingdomsConfig.Invasions.PLUNDER_ENABLED.getManager().getBoolean();
        Invasion invasion = plunderMode ? new Plunder(invader, originLand, affectedLands, player.getLocation(), ransackMode) : new Invasion(invader, originLand, affectedLands, player.getLocation(), ransackMode);
        return InvasionFactory.prepareInvasion(invasion);
    }

    public static KingdomPreInvadeEvent prepareInvasion(final Invasion invasion) {
        KingdomPreInvadeEvent event = new KingdomPreInvadeEvent(invasion);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        final Player player = invasion.getInvaderPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        player.setMetadata("INVASION", (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)invasion));
        kp.setInvasion(invasion);
        invasion.getAffectedLands().stream().map(SimpleChunkLocation::getLand).forEach(x -> x.addInvasion(invasion));
        final int timer = KingdomsConfig.Invasions.COUNTDOWN_SECONDS.getManager().getInt();
        if (timer > 0) {
            BukkitTask task = new BukkitRunnable(){
                final YamlConfigAccessor sounds = KingdomsConfig.Invasions.COUNTDOWN_SOUND.getManager().getSection();
                int times = timer;

                public void run() {
                    if (!player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    KingdomsLang.COMMAND_INVADE_COUNTDOWN_ATTACKER.sendMessage((CommandSender)player, "sec", this.times);
                    if (this.sounds != null) {
                        int closest = KingdomsConfig.getClosestLevelSection(this.sounds, this.times);
                        XSound.play((String)this.sounds.getString(Integer.toString(closest)), x -> x.atLocation(player.getEyeLocation()));
                    }
                    if (KingdomsConfig.Invasions.COUNTDOWN_SHOW_TO_DEFENDER.getManager().getBoolean()) {
                        for (Player member : invasion.getDefender().getOnlineMembers()) {
                            KingdomsLang.COMMAND_INVADE_COUNTDOWN_DEFNEDER.sendMessage((CommandSender)member, "invader", player.getName(), "sec", this.times);
                        }
                    }
                    if (this.times-- <= 0) {
                        this.cancel();
                        InvasionFactory.notifyMembers(invasion);
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> InvasionFactory.invade(invasion));
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 20L);
            invasion.setPreparationTask(task);
        } else {
            InvasionFactory.notifyMembers(invasion);
            InvasionFactory.invade(invasion);
        }
        return event;
    }

    public static void notifyMembers(Invasion invasion) {
        Kingdom defender = invasion.getDefender();
        Nation defenderNationNotifyParty = defender.getNation();
        MessagePlaceholderProvider settings = invasion.getMessageContext();
        if (defenderNationNotifyParty == null) {
            for (Player member : defender.getOnlineMembers()) {
                KingdomsLang.COMMAND_INVADE_ANNOUNCEMENT_DEFENDER.sendMessage((CommandSender)member, settings);
            }
        } else {
            for (Player member : defenderNationNotifyParty.getOnlineMembers()) {
                if (defender.isMember((OfflinePlayer)member)) {
                    KingdomsLang.COMMAND_INVADE_ANNOUNCEMENT_DEFENDER.sendMessage((CommandSender)member, settings);
                    continue;
                }
                KingdomsLang.COMMAND_INVADE_ANNOUNCEMENT_NATION.sendMessage((CommandSender)member, settings);
            }
        }
    }

    public static KingdomInvadeEvent invade(Invasion invasion) {
        KingdomPlayer invader = invasion.getInvader();
        Player player = invasion.getInvaderPlayer();
        if (!invader.isAdmin()) {
            if (player.getAllowFlight()) {
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            if (PlayerUtils.invulnerableGameMode(player)) {
                player.setGameMode(GameMode.SURVIVAL);
            }
        }
        ServiceHandler.announce(KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_INVASION_START, (Supplier<MessagePlaceholderProvider>)((Supplier)invasion::getMessageContext));
        invader.getKingdom().setLastInvasion(System.currentTimeMillis());
        if (!(invasion instanceof Plunder) || KingdomsConfig.Invasions.PLUNDER_KEEP_CHAMPION.getManager().getBoolean()) {
            invasion.spawnChampion(invasion.getStartLocation());
        }
        invasion.start();
        KingdomInvadeEvent startEvent = new KingdomInvadeEvent(invasion);
        Bukkit.getPluginManager().callEvent((Event)startEvent);
        return startEvent;
    }

    private static List<Kingdom> getRemainingKingdomNexus(Nation nation) {
        ArrayList<Kingdom> kingdoms = new ArrayList<Kingdom>();
        for (Kingdom nationKingdoms : nation.getKingdoms()) {
            SimpleLocation nexus = nationKingdoms.getNexus();
            if (nexus == null || !Invasion.getCapitalProtection().isInCooldown(nationKingdoms.getId())) continue;
            kingdoms.add(nationKingdoms);
        }
        return kingdoms;
    }

    private static void notifyRadiusProtection(Nation nation, Player player) {
        List<Kingdom> kingdoms = InvasionFactory.getRemainingKingdomNexus(nation);
        if (kingdoms.isEmpty()) {
            return;
        }
        List names = kingdoms.stream().map(Group::getName).collect(Collectors.toList());
        String kingdomsStr = "&e" + String.join((CharSequence)"&7, &e", names);
        KingdomsLang.COMMAND_INVADE_NATION_CAPITAL.sendMessage((CommandSender)player, "kingdoms", kingdomsStr);
    }

    public static boolean coversAdjoiningProtection(Land land) {
        if (InvasionFactory.hasStructure(land, StructureRegistry.get().getType("powercell"))) {
            return false;
        }
        int radius = KingdomsConfig.Invasions.ADJOINING_PROTECTION_RADIUS.getManager().getInt();
        if (radius <= 0) {
            return false;
        }
        Kingdom kingdom = Objects.requireNonNull(land.getKingdom());
        int marginalErrorLimit = KingdomsConfig.Invasions.ADJOINING_PROTECTION_MARGINAL_ERROR_LIMIT.getManager().getInt();
        for (SimpleChunkLocation chunk : land.getLocation().getChunksAround(radius)) {
            if (kingdom.isClaimed(chunk) || marginalErrorLimit-- > 0) continue;
            return false;
        }
        return true;
    }

    private static boolean hasStructure(Land land, StructureType type) {
        return land != null && land.isClaimed() && land.getStructure(struct -> ((StructureStyle)struct.getStyle()).getType() == type) != null;
    }

    public static boolean nationCapitalRadiusProtection(Nation nation, Kingdom defenderKingdom, Player player, Land land) {
        double nationProtectionRadius = KingdomsConfig.Invasions.NATIONS_CAPITAL_PROTECTION_RADIUS.getManager().getDouble();
        if (nationProtectionRadius < 0.0) {
            return false;
        }
        if (nationProtectionRadius == 0.0) {
            if (nation.getCapitalId().equals(defenderKingdom.getId())) {
                InvasionFactory.notifyRadiusProtection(nation, player);
            }
            return false;
        }
        SimpleLocation loc = nation.getNexus();
        if (loc != null) {
            SimpleChunkLocation nexusChunk = loc.toSimpleChunkLocation();
            double distance = land.getLocation().distance(nexusChunk);
            if (distance <= nationProtectionRadius) {
                KingdomsLang.COMMAND_INVADE_NATION_CAPITAL.sendMessage((CommandSender)player);
                InvasionFactory.notifyRadiusProtection(nation, player);
                return true;
            }
        }
        return false;
    }

    public static Pair<Long, Double> getInvasionCosts(Player invader, Kingdom defender, boolean ransack) {
        PlaceholderContextBuilder ctx = new PlaceholderContextBuilder().withContext(invader).other(PlaceholderTarget.of(defender)).raw("ransack", ransack);
        long rpCost = (long)MathUtils.eval(KingdomsConfig.Invasions.COSTS_RESOURCE_POINTS.getManager().getMathExpression(), (PlaceholderProvider)ctx);
        double money = MathUtils.eval(KingdomsConfig.Invasions.COSTS_MONEY.getManager().getString(), ctx);
        return Pair.of(rpCost, money);
    }

    public static Pair<Set<SimpleChunkLocation>, Map<SimpleChunkLocation, Structure>> getAffectedLands(Land origin) {
        SimpleChunkLocation[] simpleChunkLocationArray;
        HashSet<SimpleChunkLocation> acceptedLands = new HashSet<SimpleChunkLocation>();
        HashMap<SimpleChunkLocation, Structure> rejectedPowercell = new HashMap<SimpleChunkLocation, Structure>();
        HashSet<SimpleChunkLocation> powercellLessChunks = new HashSet<SimpleChunkLocation>();
        int radius = KingdomsConfig.Invasions.MULTI_CHUNK_INVASION_RADIUS.getManager().getInt();
        if (radius <= 1) {
            SimpleChunkLocation[] simpleChunkLocationArray2 = new SimpleChunkLocation[1];
            simpleChunkLocationArray = simpleChunkLocationArray2;
            simpleChunkLocationArray2[0] = origin.getLocation();
        } else {
            simpleChunkLocationArray = origin.getLocation().getChunksAround(radius, true);
        }
        SimpleChunkLocation[] chunks = simpleChunkLocationArray;
        StructureType powercellType = StructureRegistry.get().getType("powercell");
        Kingdom defender = origin.getKingdom();
        Set invadingChunks = Arrays.stream(chunks).collect(Collectors.toSet());
        block0: for (SimpleChunkLocation chunk : chunks) {
            if (!defender.isClaimed(chunk)) continue;
            if (!InvasionFactory.hasStructure(chunk.getLand(), powercellType)) {
                for (SimpleChunkLocation aroundChunk : chunk.getChunksAround(2)) {
                    if (invadingChunks.contains(aroundChunk) || powercellLessChunks.contains(aroundChunk) || !defender.isClaimed(aroundChunk)) continue;
                    Land currentLand = Land.getLand(aroundChunk);
                    Structure powercell = currentLand.getStructure(struct -> ((StructureStyle)struct.getStyle()).getType() == powercellType);
                    if (powercell != null) {
                        double dist = chunk.distanceIgnoreWorld(powercell.getOrigin().toSimpleChunkLocation());
                        if (!(dist <= (double)powercell.getLevel())) continue;
                        rejectedPowercell.put(chunk, powercell);
                        continue block0;
                    }
                    powercellLessChunks.add(aroundChunk);
                }
            }
            acceptedLands.add(chunk);
        }
        if (acceptedLands.isEmpty() && rejectedPowercell.isEmpty()) {
            throw new IllegalStateException("Failed to get affected lands: " + radius + " -> " + Arrays.stream(chunks).map(SimpleChunkLocation::getLand).collect(Collectors.toList()));
        }
        return Pair.of(acceptedLands, rejectedPowercell);
    }

    public static boolean handleMaxClaims(World world, CommandContext context, KingdomPlayer kp, Kingdom kingdom, int amount) {
        int maxKingdomClaim = kingdom.getMaxClaims(world.getName());
        if (kingdom.getLandLocations().size() + amount > maxKingdomClaim) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_MAX_CLAIMS, "limit", maxKingdomClaim);
            return false;
        }
        int maxClaims = kp.getRank().getMaxClaims();
        if (maxClaims >= 0 && kp.getClaims().size() + amount > maxClaims) {
            context.sendError(maxClaims == 0 ? KingdomsLang.COMMAND_CLAIM_NO_CLAIMS_PLAYER : KingdomsLang.COMMAND_CLAIM_MAX_CLAIMS_PLAYER, "limit", maxClaims);
            return false;
        }
        return true;
    }

    public static Pair<Integer, Integer> meetsMinOnlineMembers(Kingdom kingdom, Kingdom other, EnumConfig cfg) {
        int onlineNeeded = (int)MathUtils.eval(cfg.getManager().getMathExpression(), (PlaceholderProvider)new PlaceholderContextBuilder().withContext(kingdom).other(other));
        if (onlineNeeded <= 0) {
            return null;
        }
        int onlinePlayers = 0;
        for (UUID memberId : kingdom.getMembers()) {
            Player online = Bukkit.getPlayer((UUID)memberId);
            if (online != null) {
                if (!ServiceHandler.isAuthenticated(online)) continue;
                ++onlinePlayers;
                continue;
            }
            if (cfg != KingdomsConfig.Invasions.ONLINE_MEMBERS_DEFENDER || !TOTAL_PLAYTIME.contains(memberId)) continue;
            ++onlinePlayers;
        }
        return Pair.of(onlineNeeded, onlinePlayers);
    }
}

