/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.invasions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.general.claims.unclaiming.CommandUnclaimAll;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.type.nexus.StructureTypeKingdomNexus;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.namespace.NamespacedMetadataContainer;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.invasion.KingdomInvadeEndEvent;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.XAttribute;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XEntity;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MultiMessenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.provider.CascadingMessageContextProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.BlockLogManager;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomChampionEntity;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.invasions.InvasionFactory;
import org.kingdoms.managers.land.chests.ChestGenerator;
import org.kingdoms.managers.land.chests.ChestVisualizer;
import org.kingdoms.managers.land.chests.GeneratedChest;
import org.kingdoms.managers.land.chests.GeneratedChestHandle;
import org.kingdoms.managers.land.chests.GeneratedChestManager;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlaceholderContextProviders;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.bossbars.BossBarSession;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.display.components.ScoreboardVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.AbstractVisualizer;
import org.kingdoms.utils.display.visualizer.Visualizer;
import org.kingdoms.utils.display.visualizer.visibility.DistancedVisibilityStrategy;
import org.kingdoms.utils.internal.stacktrace.TracedObject;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeFormatter;

public class Invasion
implements NamespacedMetadataContainer,
CascadingMessageContextProvider {
    private static final Namespace SCOREBOARD_NS = Namespace.kingdoms("INVASION");
    public static final String METADATA = "INVASION";
    private static final Cooldown<UUID> CAPITAL_PROTECTION = new Cooldown();
    private static final BiCooldown<UUID, UUID> SUCCESSFUL = new BiCooldown();
    private static final BiCooldown<UUID, UUID> FAILED = new BiCooldown();
    protected final boolean ransackMode;
    protected final Set<SimpleChunkLocation> affectedLands;
    protected final Land originLand;
    protected final Kingdom defender;
    protected final Kingdom attacker;
    protected Location startLocation;
    protected Creature champion;
    protected final long start;
    protected BossBarSession attackerProgress;
    protected BossBarSession defenderProgress;
    protected BossBarSession timeLimitProgress;
    protected final KingdomPlayer invader;
    protected final Player invaderPlayer;
    protected boolean showBossBarToAllPlayers;
    protected boolean reverseProgress;
    protected long duration;
    protected BukkitTask task;
    protected double attackerScore;
    protected double defenderScore;
    protected TracedObject<Result> result;
    protected BukkitTask preparationTask;
    private final NamespacedMap<Object> metadata = new NamespacedMap();
    private final Visualizer visualizer;
    protected int attackerDeathLimit;
    protected int defenderDeathLimit;
    private static final Namespace NS = Namespace.kingdoms("INVASION_BONUS_CHEST");

    public Invasion(KingdomPlayer invader, Land originLand, Set<SimpleChunkLocation> affectedLands, Location startLocation, boolean ransackMode) {
        this.invader = Objects.requireNonNull(invader);
        this.attacker = Objects.requireNonNull(invader.getKingdom());
        this.invaderPlayer = Objects.requireNonNull(invader.getPlayer());
        this.originLand = Objects.requireNonNull(originLand);
        this.defender = Objects.requireNonNull(originLand.getKingdom());
        this.affectedLands = Collections.unmodifiableSet(Objects.requireNonNull(affectedLands));
        this.startLocation = Objects.requireNonNull(startLocation);
        this.start = System.currentTimeMillis();
        this.duration = this.getDefaultDuration();
        this.ransackMode = ransackMode;
        Validate.notEmpty(affectedLands, "affectedLands must not be empty");
        this.attackerDeathLimit = (int)MathUtils.eval(KingdomsConfig.Invasions.PLAYER_DEATHS_DEFENDER.getManager().getString(), this.defender, new Object[0]);
        this.defenderDeathLimit = (int)MathUtils.eval(KingdomsConfig.Invasions.PLAYER_DEATHS_ATTACKER.getManager().getString(), this.attacker, new Object[0]);
        this.visualizer = new AbstractVisualizer(new DistancedVisibilityStrategy(false, startLocation, 50.0)){

            @Override
            @NotNull
            public MessagePlaceholderProvider getMessageContext() {
                return Invasion.this.getMessageContext();
            }
        };
    }

    public void finalizePreparation() {
        this.preparationTask = null;
        if (!KingdomsConfig.Invasions.INITIAL_LOCATION.getManager().getBoolean()) {
            this.startLocation = this.invaderPlayer.getLocation();
        }
        Invasion.performCommands(this.invaderPlayer);
        if (KingdomsConfig.Invasions.ALLOW_BUILDING_OWN_ONLY.getManager().getBoolean()) {
            BlockLogManager.track(this.invaderPlayer);
        }
    }

    public void setPreparationTask(BukkitTask preparationTask) {
        if (this.preparationTask != null) {
            throw new IllegalStateException("Preparation task was already set");
        }
        this.preparationTask = preparationTask;
    }

    public void spawnChampion(Location spawnLocation) {
        if (KingdomsConfig.Invasions.NATIONS_USE_CAPITAL_CHAMPION.getManager().getBoolean()) {
            Nation nation = this.defender.getNation();
            if (nation != null) {
                Kingdom capital = nation.getCapital();
                this.champion = capital.spawnChampion(spawnLocation);
            } else {
                this.champion = this.defender.spawnChampion(spawnLocation);
            }
        } else {
            this.champion = this.defender.spawnChampion(spawnLocation);
        }
        this.champion.setMetadata(METADATA, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)this));
        KingdomEntityRegistry.add(new KingdomChampionEntity((Entity)this.champion, this, (LivingEntity)this.invaderPlayer));
        Particles.meguminExplosion((Plugin)Kingdoms.get(), (double)3.0, (ParticleDisplay)ParticleDisplay.of((XParticle)XParticle.FLAME).withLocation(spawnLocation.clone().add(0.0, 0.3, 0.0)));
        if (XEntity.isUndead((EntityType)this.champion.getType()) && XReflection.supports((int)13)) {
            new BukkitRunnable(){
                int secondsInWater = 0;

                public void run() {
                    if (Invasion.this.champion.isDead() || !Invasion.this.champion.isValid()) {
                        this.cancel();
                        return;
                    }
                    if (this.secondsInWater >= 5) {
                        Invasion.this.champion.teleport((Entity)Invasion.this.invaderPlayer);
                        this.secondsInWater = 0;
                        return;
                    }
                    Block block = Invasion.this.champion.getLocation().getBlock();
                    Block upperBlock = block.getRelative(BlockFace.UP);
                    this.secondsInWater = XBlock.isWater((Material)block.getType()) && XBlock.isWater((Material)upperBlock.getType()) ? ++this.secondsInWater : 0;
                }
            }.runTaskTimer((Plugin)Kingdoms.get(), 100L, 20L);
        }
    }

    public void setupBossBars() {
        ConfigAccessor progressSection = KingdomsConfig.INVASIONS.accessor().gotoSection("bossbar");
        this.attackerProgress = BossBarSession.from(progressSection.getSection());
        this.reverseProgress = progressSection.getBoolean("reverse-progress");
        ConfigAccessor timeBossbarSection = KingdomsConfig.INVASIONS.accessor().gotoSection("time-limit", "bossbar");
        this.timeLimitProgress = this.duration != 0L ? BossBarSession.from(timeBossbarSection.getSection()) : null;
    }

    public boolean isRansackMode() {
        return this.ransackMode;
    }

    public void start() {
        this.finalizePreparation();
        this.setupBossBars();
        this.useStandardTask();
        if (KingdomsConfig.Invasions.SCOREBOARD_ENABLED.getManager().getBoolean()) {
            this.visualizer.addComponent(new ScoreboardVisualComponent(SCOREBOARD_NS, new StaticMessenger(KingdomsConfig.Invasions.SCOREBOARD_TITLE.getManager().getString()), KingdomsConfig.Invasions.SCOREBOARD_LINES.getManager().getStringList().stream().map(StaticMessenger::new).collect(Collectors.toList()), this.visualizer, KingdomsConfig.Invasions.SCOREBOARD_UPDATE_RATE.getManager().getTime()));
        }
        this.visualizer.start();
    }

    public static void forAllRelatedRangedBossBarInvasions(Kingdom kingdom, Consumer<Invasion> action) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            kingdom.getInvasions().values().stream().filter(invasion -> invasion.showBossBarToAllPlayers).forEach(action);
            kingdom.getLandsUnderAttack().stream().map(x -> x.getInvasions().values()).flatMap(Collection::stream).filter(invasion -> invasion.showBossBarToAllPlayers).forEach(action);
        });
    }

    protected static void performCommands(Player player) {
        Strings.performCommands((OfflinePlayer)player, KingdomsConfig.Invasions.COMMANDS_EXECUTE_BEFORE.getManager().getStringList());
    }

    public static Cooldown<UUID> getCapitalProtection() {
        return CAPITAL_PROTECTION;
    }

    public static Pair<Long, Boolean> getCooldown(Kingdom attacker, Kingdom defender) {
        long successful = SUCCESSFUL.getTimeLeft(attacker.getId(), defender.getId());
        long failed = FAILED.getTimeLeft(attacker.getId(), defender.getId());
        if (successful == 0L && failed == 0L) {
            return null;
        }
        return Pair.of(successful == 0L ? failed : successful, failed == 0L);
    }

    public static @Nullable Invasion getInvasion(@NonNull LivingEntity entity2) {
        Objects.requireNonNull(entity2, "Cannot get land invasion session from null entity");
        if (!entity2.hasMetadata(METADATA)) {
            return null;
        }
        if (entity2 instanceof Player) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)entity2));
            Invasion invasion = kp.getInvasion();
            if (!kp.isInvading() || invasion == null) {
                throw new IllegalStateException("Attempted to get invasion session of a land that is not under attack from player: '" + entity2.getName() + '\'');
            }
            return invasion;
        }
        return Invasion.getInvasionFromChampion(entity2);
    }

    public static Invasion getInvasionFromChampion(@NonNull LivingEntity entity2) {
        KingdomEntity championEntity = KingdomEntityRegistry.get((Entity)entity2);
        if (championEntity == null) {
            throw new IllegalStateException("Attempted to get invasion session of a land that is not under attack from champion: '" + entity2.getName() + '\'');
        }
        if (!(championEntity instanceof KingdomChampionEntity)) {
            throw new AssertionError((Object)("Attempted to get invasion session of a land from an entity that is not KingdomChampionEntity: '" + entity2.getName() + "' - " + championEntity));
        }
        return ((KingdomChampionEntity)championEntity).getInvasion();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void updateTimeLimitBossBar(long timePassed, Kingdom kingdom, Supplier<Double> progressSupplier) {
        Double prog;
        if (this.timeLimitProgress == null) {
            return;
        }
        double percent = -1.0;
        if (progressSupplier != null && (prog = progressSupplier.get()) != null) {
            percent = prog;
        }
        if (percent == -1.0) {
            percent = this.reverseProgress ? (double)(1.0f - (float)timePassed / (float)this.duration) : (double)((float)timePassed / (float)this.duration);
        }
        this.timeLimitProgress.setProgress(percent);
        this.timeLimitProgress.updateTitle(this.getMessageContext().withContext(kingdom.hasOwner() ? kingdom.getKing().getOfflinePlayer() : null));
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider builder) {
        PlaceholderContextBuilder invasionContext = new PlaceholderContextBuilder().raw("total_lands", this.affectedLands).raw("result", (Object)this.getResult()).raw("attacker_score", this.attackerScore).raw("defender_score", this.defenderScore).raw("attacker_death_limit", this.attackerDeathLimit).raw("defender_death_limit", this.defenderDeathLimit).raw("defender-lives-left", (int)((double)this.defenderDeathLimit - this.attackerScore)).raw("attacker-lives-left", (int)((double)this.attackerDeathLimit - this.defenderScore)).raw("start", TimeFormatter.of(this.start)).raw("duration", TimeFormatter.of(this.duration)).raw("time_passed", TimeFormatter.of(this.getTimePassed())).raw("time_left", TimeFormatter.of(this.duration - this.getTimePassed()));
        if (this.champion != null) {
            PlaceholderContextBuilder championContext = new PlaceholderContextBuilder();
            PlaceholderContextProviders.provide(championContext, (Entity)this.champion);
            invasionContext.addChild("champion", championContext);
        }
        builder.withContext(this.invaderPlayer).other(this.defender).addChild("invasion", invasionContext);
        builder.raw("start_location", KingdomsLang.LOCATIONS_NORMAL.parse(LocationUtils.getLocationEdits(builder, SimpleLocation.of(this.startLocation), "")));
    }

    public void updateProgress(BossBarSession bossBar, double progress) {
        bossBar.updateTitle(this.getMessageContext());
        bossBar.setProgress(progress);
    }

    public void addBossBarToAllMembers() {
        @NonNull List<Player> players = this.defender.getOnlineMembers();
        players.addAll(this.attacker.getOnlineMembers());
        for (Player player : players) {
            this.addPlayerToBossBar(player);
        }
    }

    void addPlayerToBossBar(Player player) {
        if (this.defenderProgress != null) {
            if (this.defender.isMember((OfflinePlayer)player)) {
                this.defenderProgress.addPlayer(player);
            } else if (this.attackerProgress != null) {
                this.attackerProgress.addPlayer(player);
            }
        } else if (this.attackerProgress != null) {
            this.attackerProgress.addPlayer(player);
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.addPlayer(player);
        }
    }

    static void discardPlayers(BossBarSession bossBar, Set<Player> keptPlayers) {
        if (bossBar != null) {
            bossBar.getPlayers().stream().filter(x -> !keptPlayers.contains(x)).forEach(bossBar::removePlayer);
        }
    }

    public void updateRangedBossBar(double range, Location location) {
        Collection nearBy = location == null ? this.champion.getNearbyEntities(range, range, range) : location.getWorld().getNearbyEntities(location, range, range, range);
        HashSet<Player> keep = new HashSet<Player>(nearBy.size());
        for (Entity entity2 : nearBy) {
            if (!(entity2 instanceof Player)) continue;
            keep.add((Player)entity2);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            Invasion.discardPlayers(this.attackerProgress, keep);
            Invasion.discardPlayers(this.defenderProgress, keep);
            Invasion.discardPlayers(this.timeLimitProgress, keep);
            for (Player player : keep) {
                this.addPlayerToBossBar(player);
            }
        });
    }

    public void setTask(BukkitTask task) {
        this.task = task;
    }

    public boolean showBossBarToAllPlayers() {
        return this.showBossBarToAllPlayers;
    }

    public void removeBossBar(Player player) {
        if (this.attackerProgress != null) {
            this.attackerProgress.removePlayer(player);
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.removePlayer(player);
        }
        if (this.defenderProgress != null) {
            this.defenderProgress.removePlayer(player);
        }
    }

    public void addBossBar(Player player, boolean attacker) {
        if (attacker) {
            if (this.attackerProgress != null) {
                this.attackerProgress.addPlayer(player);
            }
        } else if (this.defenderProgress != null) {
            this.defenderProgress.addPlayer(player);
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.addPlayer(player);
        }
    }

    public BossBarSession getDefenderProgress() {
        return this.defenderProgress;
    }

    public void championAbilitiesTick() {
        for (ChampionAbility ability : ChampionAbility.getAbilities().values()) {
            if (!ability.canTriggerInstantly() || !ability.canUse(this.defender) || ability.isInCooldown(this)) continue;
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> ability.trigger(this));
        }
    }

    protected double getVisualRange() {
        return KingdomsConfig.Invasions.VISUAL_RANGE.getManager().getDouble();
    }

    public BukkitTask useStandardTask() {
        final double range = this.getVisualRange();
        if (range <= 0.0) {
            this.addBossBarToAllMembers();
            this.showBossBarToAllPlayers = true;
        }
        this.task = new BukkitRunnable(){
            int nearbyCheck = 100;

            public void run() {
                long timePassed = Invasion.this.getTimePassed();
                if (Invasion.this.duration != 0L && timePassed >= Invasion.this.duration) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Invasion.this.end(Result.TIMES_UP));
                    this.cancel();
                    return;
                }
                if (Invasion.this.champion.isValid()) {
                    Invasion.this.championAbilitiesTick();
                }
                if (Invasion.this.attackerProgress != null || Invasion.this.timeLimitProgress != null) {
                    double health = Invasion.this.champion.getHealth();
                    double maxHealth = Invasion.this.champion.getAttribute((Attribute)XAttribute.MAX_HEALTH.get()).getValue();
                    if (Invasion.this.attackerProgress != null) {
                        double percent = (Invasion.this.reverseProgress ? health : maxHealth - health) / maxHealth;
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Invasion.this.updateProgress(Invasion.this.attackerProgress, percent));
                    }
                    Invasion.this.updateTimeLimitBossBar(timePassed, Invasion.this.defender, null);
                    if (range > 0.0 && this.nearbyCheck++ == 100) {
                        this.nearbyCheck = 0;
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Invasion.this.updateRangedBossBar(range, null));
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 1L);
        return this.task;
    }

    public long getDefaultDuration() {
        KingdomsConfig.Invasions timeLimit = this.affectedLands.stream().anyMatch(x -> x.getLand().isNexusLand()) ? KingdomsConfig.Invasions.TIME_LIMIT_NEXUS : KingdomsConfig.Invasions.TIME_LIMIT_DEFAULT;
        Long limitOpt = timeLimit.getManager().getTimeMillis();
        return limitOpt == null ? 0L : limitOpt;
    }

    public BossBarSession getAttackerProgress() {
        return this.attackerProgress;
    }

    public BossBarSession getTimeLimitProgress() {
        return this.timeLimitProgress;
    }

    public Result getResult() {
        return this.result == null ? null : this.result.getObject();
    }

    protected void cleanup() {
        this.invaderPlayer.removeMetadata(METADATA, (Plugin)Kingdoms.get());
        this.invader.setInvasion(null);
        this.affectedLands.stream().map(SimpleChunkLocation::getLand).forEach(x -> x.removeInvasion(this.attacker));
        if (this.champion != null) {
            this.champion.removeMetadata(METADATA, (Plugin)Kingdoms.get());
            KingdomEntityRegistry.remove((LivingEntity)this.champion);
            this.champion.remove();
        }
        if (KingdomsConfig.Invasions.ALLOW_BUILDING_OWN_ONLY.getManager().getBoolean()) {
            BlockLogManager.dontTrack(this.invaderPlayer);
        }
        if (this.attackerProgress != null) {
            this.attackerProgress.removeAll();
        }
        if (this.defenderProgress != null) {
            this.defenderProgress.removeAll();
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.removeAll();
        }
        if (this.visualizer != null && this.visualizer.getState() == VisualComponent.State.STARTED) {
            this.visualizer.close();
        }
    }

    public boolean hasEnded() {
        return this.result != null;
    }

    public void end(Result result) {
        Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> this.end0(result));
    }

    /*
     * WARNING - void declaration
     */
    private KingdomInvadeEndEvent end0(Result result) {
        void var6_17;
        org.kingdoms.server.location.Location home;
        void var6_15;
        Objects.requireNonNull(result, "Invasion result cannot be null");
        if (this.result != null) {
            throw this.result.getException();
        }
        this.result = new TracedObject<Result>(result, new IllegalStateException("This invasions has already ended"));
        KingdomInvadeEndEvent invadeEvent = new KingdomInvadeEndEvent(this);
        Bukkit.getPluginManager().callEvent((Event)invadeEvent);
        if (invadeEvent.isCancelled()) {
            this.result = null;
            return invadeEvent;
        }
        KLogger logger = new KLogger(KingdomsDebug.INVASION_END);
        logger.log(() -> "Invasion ended result=" + (Object)((Object)result) + ", attacker=" + this.attacker.getName() + ", defender=" + this.defender.getName() + ", player=" + this.invaderPlayer.getName() + ", class=" + this.getClass().getName() + ", ransack=" + this.ransackMode + ", champion=" + this.champion + ", scores=" + this.attackerScore + '-' + this.defenderScore + ", deathlimits=" + this.attackerDeathLimit + '-' + this.defenderDeathLimit + ", task=" + this.task + ", preparationTask=" + this.preparationTask + ", affectedLands=" + this.affectedLands);
        if (this.task != null) {
            this.task.cancel();
        }
        this.cleanup();
        if (result == Result.ATTACKER_SURRENDERED) {
            boolean refundRp = KingdomsConfig.Invasions.SURRENDER_REFUND_RESOURCE_POINTS.getManager().getBoolean();
            boolean refundMoney = KingdomsConfig.Invasions.SURRENDER_REFUND_MOENY.getManager().getBoolean();
            if (refundRp || refundMoney) {
                Pair<Long, Double> pair = InvasionFactory.getInvasionCosts(this.invaderPlayer, this.defender, this.ransackMode);
                if (refundRp) {
                    this.attacker.getResourcePoints().add(pair.getKey());
                }
                if (refundMoney) {
                    this.attacker.getBank().add(pair.getValue());
                }
            }
        }
        Object[] invaderEdits = new Object[]{"kingdom", this.defender.getName(), "invader", this.invaderPlayer.getName()};
        for (Player player : this.attacker.getOnlineMembers()) {
            KingdomsLang.valueOf("INVASION_END_ATTACKERS_" + result.name()).sendMessage((CommandSender)player, invaderEdits);
        }
        Object[] defenderEdits = new Object[]{"kingdom", this.attacker.getName(), "invader", this.invaderPlayer.getName()};
        for (Player member : this.defender.getOnlineMembers()) {
            KingdomsLang.valueOf("INVASION_END_DEFENDERS_" + result.name()).sendMessage((CommandSender)member, defenderEdits);
        }
        if (this.isPreparing()) {
            this.preparationTask.cancel();
            this.preparationTask = null;
            return invadeEvent;
        }
        MiscUpgradeManager.invaded(this.attacker);
        ServiceHandler.announce(result.isSuccessful() ? KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_INVASION_END_SUCCESS : KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_INVASION_END_FAIL, (com.google.common.base.Supplier<MessagePlaceholderProvider>)((com.google.common.base.Supplier)() -> this.getMessageContext().ignoreColors()));
        if (!this.isPreparing()) {
            long l = (result.isSuccessful() ? KingdomsConfig.Invasions.COOLDOWNS_SUCCESSFUL : KingdomsConfig.Invasions.COOLDOWNS_FAILED).getManager().getTimeMillis(TimeUnit.MINUTES);
            if (l > 0L) {
                (result.isSuccessful() ? SUCCESSFUL : FAILED).add(this.attacker.getId(), this.defender.getId(), l);
            }
            logger.log("Invasion Cooldown: " + l);
        }
        Strings.performCommands((OfflinePlayer)this.invaderPlayer, (result.isSuccessful() ? KingdomsConfig.Invasions.COMMANDS_EXECUTE_AFTER_SUCCESSFUL : KingdomsConfig.Invasions.COMMANDS_EXECUTE_AFTER_FAIL).getManager().getStringList());
        if (!result.isSuccessful()) {
            return invadeEvent;
        }
        Object var6_13 = null;
        Optional<Structure> nexus = this.affectedLands.stream().map(x -> Land.getLand(x).getStructure(struct -> ((StructureStyle)struct.getStyle()).getType() instanceof StructureTypeKingdomNexus)).filter(Objects::nonNull).findFirst();
        nexus.ifPresent(structure -> logger.log("A nexus chunk which is at: " + structure.getOrigin() + " - " + ((StructureStyle)structure.getStyle()).getName()));
        if (nexus.isPresent()) {
            Location location = nexus.get().getOrigin().toBukkitLocation();
        }
        if (var6_15 == null && (home = this.defender.getHome()) != null && this.affectedLands.contains(SimpleChunkLocation.of(home))) {
            Location location = BukkitAdapter.adapt(home);
        }
        double rp = MathUtils.eval((var6_17 != null ? KingdomsConfig.Invasions.ON_NEXUS_LOSS_RESOURCE_POINTS : KingdomsConfig.Invasions.BONUS_RESOURCE_POINTS).getManager().getString(), this.defender, "ransack", this.ransackMode);
        double bank = MathUtils.eval((var6_17 != null ? KingdomsConfig.Invasions.ON_NEXUS_LOSS_MONEY : KingdomsConfig.Invasions.BONUS_BANK).getManager().getString(), this.defender, "ransack", this.ransackMode);
        if (!this.defender.getResourcePoints().has(rp)) {
            rp = this.defender.getResourcePoints().get();
        }
        if (!this.defender.getBank().has(bank)) {
            bank = this.defender.getBank().get();
        }
        this.defender.getResourcePoints().add(-rp);
        this.defender.getBank().add(-bank);
        this.attacker.getResourcePoints().add(rp);
        this.attacker.getBank().add(bank);
        logger.log("Money bonus: " + bank + ", rp bonus: " + rp);
        this.generateChestBonuses();
        boolean disbanded = false;
        if (!this.ransackMode && var6_17 != null) {
            CAPITAL_PROTECTION.add(this.defender.getId(), KingdomsConfig.Invasions.NATIONS_CAPITAL_PROTECTION_NEXUS_INVASION_COOLDOWN.getManager().getTimeMillis());
            void loc = var6_17;
            final World world = loc.getWorld();
            for (int i = 0; i < 4; ++i) {
                world.strikeLightningEffect((Location)loc);
            }
            if (KingdomsConfig.Invasions.ON_NEXUS_LOSS_DROP_NEXUS_CHEST_ITEMS.getManager().getBoolean()) {
                for (ItemStack item : this.defender.getNexusChest().getOriginal().getContents()) {
                    if (item == null) continue;
                    world.dropItemNaturally((Location)loc, item);
                }
                this.defender.getNexusChest().getOriginal().clear();
            }
            new BukkitRunnable((Location)loc){
                final int amount = KingdomsConfig.Invasions.ON_NEXUS_LOSS_LIGHTNING_AMOUNT.getManager().getInt();
                int times = KingdomsConfig.Invasions.ON_NEXUS_LOSS_LIGHTNING_TIMES.getManager().getInt();
                final /* synthetic */ Location val$loc;
                {
                    this.val$loc = location;
                }

                public void run() {
                    for (int i = 0; i < this.amount; ++i) {
                        world.strikeLightningEffect(this.val$loc);
                    }
                    if (--this.times <= 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)Kingdoms.get(), 0L, (long)KingdomsConfig.Invasions.ON_NEXUS_LOSS_LIGHTNING_INTERVAL.getManager().getInt());
            if (KingdomsConfig.Invasions.ON_NEXUS_LOSS_DISBAND.getManager().getBoolean()) {
                disbanded = true;
                this.defender.disband(GroupDisband.Reason.INVASION);
            } else if (KingdomsConfig.Invasions.ON_NEXUS_LOSS_UNCLAIM_ALL.getManager().getBoolean()) {
                CommandUnclaimAll.unclaimAll(this.invader, UnclaimLandEvent.Reason.INVASION, this.defender);
            }
        }
        if (disbanded) {
            logger.log("The defender is marked to be disbanded");
        }
        if (!this.ransackMode) {
            for (SimpleChunkLocation chunk : this.affectedLands) {
                Land land = Land.getLand(chunk);
                if (land.isHomeLand()) {
                    SimpleChunkLocation farthest;
                    if (KingdomsConfig.Invasions.HOME_REMOVE.getManager().getBoolean()) {
                        this.defender.setHome(null, null);
                    } else if (KingdomsConfig.Invasions.HOME_MOVE.getManager().getBoolean() && (farthest = land.getLocation().findFarthestChunk(this.defender.getLandLocations(), false)) != null) {
                        Location newHome = farthest.getCenterLocation();
                        this.defender.setHome(BukkitAdapter.adapt(newHome), null);
                        this.defender.getOnlineMembers().forEach(x -> KingdomsLang.INVASION_HOME_MOVED.sendError((CommandSender)x, "new-home", LocationUtils.parseLocation(newHome)));
                    }
                }
                boolean unclaimed = true;
                if (!disbanded) {
                    boolean bl = unclaimed = !land.unclaim(this.invader, UnclaimLandEvent.Reason.INVASION).isCancelled();
                }
                if (unclaimed && !this.attacker.claim(land.getLocation(), this.invader, ClaimLandEvent.Reason.INVASION).isCancelled()) {
                    Long cd = KingdomsConfig.Invasions.UNCLAIM_COOLDOWN.getManager().getTimeMillis();
                    if (cd != null && cd > 0L) {
                        UnclaimProcessor.getUnclaimCooldown().add(land.getLocation(), cd);
                    }
                    logger.log(() -> "Claimed land for attacker: " + land.getLocation() + " with unclaim cd of " + TimeFormatter.of(cd));
                    continue;
                }
                logger.log("Unclaiming not successful for: " + land.getLocation());
            }
        }
        logger.end();
        return invadeEvent;
    }

    public void generateChestBonuses() {
        YamlConfigAccessor itemBonuses = KingdomsConfig.Invasions.BONUS_ITEM_REWARDS.getManager().getSection().noDefault();
        if (itemBonuses.getSection() == null) {
            return;
        }
        if (!itemBonuses.getBoolean("enabled")) {
            return;
        }
        ChestGenerator chestGenerator = new ChestGenerator(this.startLocation.getWorld(), Collections.singleton(BukkitAdapter.adapt(this.startLocation).toBlockVector()));
        MessagePlaceholderProvider context = this.getMessageContext();
        Collection<GeneratedChest> generated = chestGenerator.generate(itemBonuses, context);
        generated = new ArrayList<GeneratedChest>(generated);
        ((List)generated).sort(Comparator.comparingDouble(a -> a.getSettings().getChance()).thenComparing(x -> x.getSettings().getName()));
        MultiMessenger messenger = new MultiMessenger(this.attacker.getOnlineMembers(), context);
        messenger.sendMessage(KingdomsLang.INVASION_BONUSES_CHEST_SPAWNED, new Object[0]);
        for (GeneratedChest chest : generated) {
            ChestVisualizer visualizer = new ChestVisualizer(context, this, chest);
            visualizer.start();
            GeneratedChestManager.CHESTS.put(SimpleLocation.of(chest.getChestBlock().getLocation()), new GeneratedChestHandle(chest, visualizer));
            chest.addMessageContextEdits(messenger.getMessageContext());
            messenger.sendMessage(KingdomsLang.INVASION_BONUSES_CHEST_ENTRY, new Object[0]);
        }
    }

    public KingdomPlayer getInvader() {
        return this.invader;
    }

    @Deprecated
    public Land getOriginLand() {
        return this.originLand;
    }

    public List<LivingEntity> getEntitiesInArea() {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>(this.affectedLands.size() * 10);
        for (SimpleChunkLocation chunk : this.affectedLands) {
            for (Entity entity2 : chunk.toChunk().getEntities()) {
                if (!(entity2 instanceof LivingEntity)) continue;
                entities.add((LivingEntity)entity2);
            }
        }
        return entities;
    }

    public boolean isAffected(SimpleChunkLocation chunk) {
        return this.affectedLands.contains(chunk);
    }

    public Kingdom getDefender() {
        return this.defender;
    }

    public @Nullable Creature getChampion() {
        return this.champion;
    }

    public long getStart() {
        return this.start;
    }

    public long getTimePassed() {
        return System.currentTimeMillis() - this.start;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public double getDefenderScore() {
        return this.defenderScore;
    }

    public Set<SimpleChunkLocation> getAffectedLands() {
        return this.affectedLands;
    }

    public void setDefenderScore(double defenderScore) {
        this.defenderScore = defenderScore;
    }

    public double getAttackerScore() {
        return this.attackerScore;
    }

    public void setAttackerScore(double attackerScore) {
        this.attackerScore = attackerScore;
    }

    public void addDefenderScore(double amount) {
        this.defenderScore += amount;
        int limit = this.attackerDeathLimit;
        if (limit > 0 && this.defenderScore >= (double)limit) {
            this.end(Result.ATTACKER_DEATH_LIMIT);
        }
    }

    public void addAttackerScore(double amount) {
        this.attackerScore += amount;
        int limit = this.defenderDeathLimit;
        if (limit > 0 && this.attackerScore >= (double)limit) {
            this.end(Result.DEFENDER_DEATH_LIMIT);
        }
    }

    public boolean isPreparing() {
        return this.preparationTask != null;
    }

    public Player getInvaderPlayer() {
        return this.invaderPlayer;
    }

    public Kingdom getAttacker() {
        return this.attacker;
    }

    public int getAttackerDeathLimit() {
        return this.attackerDeathLimit;
    }

    public void setAttackerDeathLimit(int attackerDeathLimit) {
        this.attackerDeathLimit = attackerDeathLimit;
    }

    public int getDefenderDeathLimit() {
        return this.defenderDeathLimit;
    }

    public void setDefenderDeathLimit(int defenderDeathLimit) {
        this.defenderDeathLimit = defenderDeathLimit;
    }

    @Override
    public NamespacedMap<Object> getMetadata() {
        return this.metadata;
    }

    public static enum Result {
        SUCCESS(true),
        ATTACKER_SURRENDERED,
        DEFENDER_SURRENDERED(true),
        LOGOUT,
        DIED,
        TIMES_UP,
        DEFENDER_DEATH_LIMIT(true),
        ATTACKER_DEATH_LIMIT,
        UNCLAIMED(true),
        ATTACKER_NO_LONGER_IN_KINGDOM;

        private final boolean successful;

        private Result(boolean successful) {
            this.successful = successful;
        }

        private Result() {
            this(false);
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

