/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.internals;

import java.util.Timer;
import java.util.TimerTask;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

public final class EmergencyMode {
    private static DEFCON EMERGENCY = DEFCON.DEFCON_5;
    private static final EmergencyLogger KLOGGER = KLogger::error;
    private static final EmergencyLogger JAVA_LOGGER = msg -> Kingdoms.get().getLogger().severe(msg);
    private static final EmergencyLogger SYSTEM_LOGGER = System.err::println;
    private static final EmergencyLogger STACK_TRACE_LOGGER = msg -> {
        RuntimeException ex = new RuntimeException(msg);
        ex.setStackTrace(new StackTraceElement[0]);
        ex.printStackTrace();
    };

    public static DEFCON getEmergencyState() {
        return EMERGENCY;
    }

    public static boolean isAt(DEFCON defcon) {
        return EMERGENCY != null && EMERGENCY.ordinal() <= defcon.ordinal();
    }

    public static void alert(DEFCON defcon, String message) {
        EMERGENCY = defcon;
        try {
            final AdaptiveLogger logger = AdaptiveLogger.INSTANCE;
            final String finalMessage = "[Emergency-" + defcon.name() + "] " + message;
            logger.log(finalMessage);
            final Timer timer = new Timer(true);
            timer.scheduleAtFixedRate(new TimerTask(){
                int times = 0;

                @Override
                public void run() {
                    logger.log("");
                    logger.log(finalMessage);
                    logger.log("");
                    if (this.times++ >= 10) {
                        timer.cancel();
                    }
                }
            }, 0L, 5000L);
        }
        catch (Throwable ex) {
            EMERGENCY = DEFCON.DEFCON_1;
            throw ex;
        }
    }

    static /* synthetic */ EmergencyLogger access$000() {
        return KLOGGER;
    }

    static /* synthetic */ EmergencyLogger access$100() {
        return JAVA_LOGGER;
    }

    static /* synthetic */ EmergencyLogger access$200() {
        return SYSTEM_LOGGER;
    }

    static /* synthetic */ EmergencyLogger access$300() {
        return STACK_TRACE_LOGGER;
    }

    private static interface EmergencyLogger {
        public void log(String var1);
    }

    public static enum DEFCON {
        DEFCON_1,
        DEFCON_2,
        DEFCON_3,
        DEFCON_4,
        DEFCON_5;

    }

    private static final class AdaptiveLogger
    implements EmergencyLogger {
        private static final AdaptiveLogger INSTANCE = new AdaptiveLogger();
        private static final EmergencyLogger[] LOGGERS = new EmergencyLogger[]{EmergencyMode.access$000(), EmergencyMode.access$100(), EmergencyMode.access$200(), EmergencyMode.access$300()};
        private static EmergencyLogger SUCCESSFUL;

        private AdaptiveLogger() {
        }

        @Override
        public void log(String message) {
            if (SUCCESSFUL != null) {
                SUCCESSFUL.log(message);
                return;
            }
            RuntimeException errors = new RuntimeException("None of the loggers could log the message " + message);
            for (EmergencyLogger logger : LOGGERS) {
                try {
                    logger.log(message);
                    SUCCESSFUL = logger;
                    return;
                }
                catch (Throwable ex) {
                    errors.addSuppressed(new RuntimeException("Couldn't use logger " + logger, ex));
                }
            }
            throw errors;
        }
    }
}

