/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.entity.types;

import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Illager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Zombie;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.time.stopwatch.Stopwatch;

public class KingdomEntity {
    private final @NonNull Entity entity;
    private @Nullable Entity target;
    private final Cache<LivingEntity, Double> damages = CacheHandler.newBuilder().weakKeys().build();
    private final Stopwatch targetCheckup = Stopwatch.withMillisAccuracy().start();

    public KingdomEntity(@NonNull Entity entity2, @Nullable LivingEntity target) {
        this.entity = Objects.requireNonNull(entity2, "Kingdom entity cannot be null");
        this.target = target;
        this.protect();
    }

    public void damage(LivingEntity damager, double damage) {
        if (this.entity == damager) {
            throw new IllegalArgumentException("Entity damager cannot be the entity itself");
        }
        Double present = (Double)this.damages.getIfPresent((Object)damager);
        present = present == null ? Double.valueOf(damage) : Double.valueOf(present + damage);
        this.damages.put((Object)damager, (Object)present);
        this.handleTarget();
    }

    private void handleTarget() {
        if (!(this.entity instanceof Mob)) {
            return;
        }
        if (this.targetCheckup.getElapsed().getSeconds() < 30L) {
            return;
        }
        this.targetCheckup.reset().start();
        LivingEntity newTarget = this.getHighestDamagingEntity();
        if (newTarget == null || newTarget == this.target) {
            return;
        }
        this.target = newTarget;
        ((Mob)this.entity).setTarget(newTarget);
    }

    public @Nullable LivingEntity getHighestDamagingEntity() {
        LivingEntity highestEntity = null;
        double highestDamage = 0.0;
        for (Map.Entry entities : this.damages.asMap().entrySet()) {
            LivingEntity entity2 = (LivingEntity)entities.getKey();
            double damage = (Double)entities.getValue();
            if (!entity2.isValid() || entity2.isDead() || highestEntity != null && !(highestDamage < damage)) continue;
            highestEntity = entity2;
            highestDamage = damage;
        }
        return highestEntity;
    }

    public @NonNull Entity getEntity() {
        return this.entity;
    }

    public @Nullable Entity getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable Entity target) {
        this.target = target;
    }

    void protect() {
        if (XReflection.supports((int)13)) {
            if (this.entity instanceof Illager) {
                ((Illager)this.entity).setPatrolLeader(false);
            }
            if (this.entity instanceof Zombie) {
                ((Zombie)this.entity).setConversionTime(Integer.MAX_VALUE);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.entity + ')';
    }
}

