/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.entity;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.utils.internal.reflection.Reflect;

public final class KingdomEntityManager
implements Listener {
    private static final ParticleDisplay DEATH_DISPLAY = ParticleDisplay.of((XParticle)XParticle.CLOUD).offset(1.0).withCount(50);

    public KingdomEntityManager(Kingdoms plugin) {
        if (Reflect.classExists("org.bukkit.event.entity.EntityPickupItemEvent")) {
            plugin.registerEvent(new PickupEvent());
        }
        if (Reflect.classExists("org.bukkit.event.entity.EntityDropItemEvent")) {
            plugin.registerEvent(new DropEvent());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onKingdomMobDeath(EntityDeathEvent event) {
        if (KingdomEntityRegistry.isKingdomEntity(event.getEntity())) {
            event.getDrops().clear();
            event.setDroppedExp(0);
            DEATH_DISPLAY.spawn(event.getEntity().getLocation());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onKingdomMobBurn(EntityCombustEvent event) {
        if (event.getEntity() instanceof LivingEntity && KingdomEntityRegistry.isKingdomEntity((LivingEntity)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomSlimeSplit(SlimeSplitEvent event) {
        KingdomEntityManager.checkEntity(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPortalTeleport(EntityPortalEvent event) {
        KingdomEntityManager.checkEntity(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageByEntityEvent event) {
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        Player damager = PvPManager.getDamager(event.getDamager());
        if (damager == null) {
            return;
        }
        KingdomEntity kEntity = KingdomEntityRegistry.get(entity2);
        if (kEntity == null) {
            return;
        }
        kEntity.damage((LivingEntity)damager, event.getFinalDamage());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTame(EntityTameEvent event) {
        KingdomEntityManager.checkEntity(event);
    }

    static <T extends EntityEvent> void checkEntity(T event) {
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        if (KingdomEntityRegistry.isKingdomEntity((LivingEntity)entity2)) {
            ((Cancellable)event).setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTarget(EntityTargetEvent event) {
        Entity rightTarget;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity guard = (LivingEntity)event.getEntity();
        KingdomEntity kingdomEntity = KingdomEntityRegistry.get((Entity)guard);
        if (kingdomEntity == null) {
            return;
        }
        Entity target = event.getTarget();
        if (target != (rightTarget = kingdomEntity.getTarget())) {
            event.setTarget(rightTarget);
        }
    }

    private static final class PickupEvent
    implements Listener {
        private PickupEvent() {
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onPickupItem(EntityPickupItemEvent event) {
            KingdomEntityManager.checkEntity(event);
        }
    }

    private static final class DropEvent
    implements Listener {
        private DropEvent() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onLootDrop(EntityDropItemEvent event) {
            KingdomEntityManager.checkEntity(event);
        }
    }
}

