/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.entity;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XEntity;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.services.ServiceMythicMobs;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.string.ConfigPrinter;

public final class KingdomEntityBuilder {
    private static final Function<LivingEntity, KingdomEntity> DELAYED_REGISTRAR = x -> null;
    private Location location;
    private ConfigSection settings;
    @Nullable
    private MessagePlaceholderProvider context;
    private Integer forceLevel;
    private String entityType = "Unknown";
    private boolean nullable;
    private Function<LivingEntity, KingdomEntity> registrar;

    public KingdomEntityBuilder location(Location location) {
        this.location = location;
        return this;
    }

    public KingdomEntityBuilder settings(ConfigSection settings) {
        this.settings = settings;
        return this;
    }

    public KingdomEntityBuilder context(@Nullable MessagePlaceholderProvider context) {
        this.context = context;
        return this;
    }

    public KingdomEntityBuilder forceLevel(Integer forceLevel) {
        this.forceLevel = forceLevel;
        return this;
    }

    public KingdomEntityBuilder entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    public KingdomEntityBuilder nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public KingdomEntityBuilder registrar(Function<LivingEntity, KingdomEntity> registrar) {
        this.registrar = registrar;
        return this;
    }

    public KingdomEntityBuilder delayedRegistry() {
        this.registrar = DELAYED_REGISTRAR;
        return this;
    }

    @NotNull
    public CompletableFuture<LivingEntity> threadSafeSpawn() {
        this.verify();
        CompletableFuture<LivingEntity> entity2 = new CompletableFuture<LivingEntity>();
        Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> entity2.complete(this.spawn0()));
        return entity2;
    }

    @Nullable
    public LivingEntity spawn() {
        this.verify();
        return this.spawn0();
    }

    @Nullable
    private LivingEntity spawn0() {
        String mm = this.settings.getString("mythicmob");
        boolean isCustom = mm != null && SoftService.MYTHIC_MOBS.isAvailable();
        int lvl = this.forceLevel == null ? this.settings.getInt("lvl") : this.forceLevel.intValue();
        LivingEntity kEntity = (LivingEntity)(isCustom ? ((ServiceMythicMobs)SoftService.MYTHIC_MOBS.getService()).spawnMythicMob(this.location, mm, lvl) : XEntity.spawn((Location)this.location, (ConfigurationSection)this.settings.getSection(new String[0]).toBukkitConfigurationSection()));
        if (kEntity == null) {
            if (this.nullable) {
                return null;
            }
            MessageHandler.sendConsolePluginMessage("&4Unable to parse kingdom entity " + this.entityType + "&8:");
            ConfigPrinter.printConfig(this.settings);
            return null;
        }
        if (this.context != null) {
            kEntity.setCustomName(MessageCompiler.compile(this.settings.getString("name")).buildPlain(this.context));
        }
        KLogger.debug((DebugNS)KingdomsDebug.ENTITY_SPAWN, () -> "Spawning kingdom entity '" + this.entityType + "': MM=" + mm + ", level=" + lvl);
        if (this.registrar != DELAYED_REGISTRAR) {
            KingdomEntity created = Objects.requireNonNull(this.registrar.apply(kEntity), "Entity builder registrar returned null for kingdom entity: " + this);
            KingdomEntityRegistry.add(created);
        }
        return kEntity;
    }

    private void verify() {
        Objects.requireNonNull(this.location, "Cannot spawn entity with null location");
        Objects.requireNonNull(this.settings, "No settings provided");
        if (this.registrar != DELAYED_REGISTRAR) {
            Objects.requireNonNull(this.registrar, "Registrar must be set");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "nullable=" + this.nullable + ", entityType='" + this.entityType + '\'' + ", forceLevel=" + this.forceLevel + ", context=" + this.context + ", settings=" + this.settings + ", location=" + this.location + ')';
    }
}

