/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily.elections;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.ElectionResult;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.utils.MathUtils;

public final class KingdomsElectionsManager
extends ElectionsManager {
    protected KingdomsElectionsManager() {
        super("kingdoms");
    }

    @Override
    protected Messenger getJoinNotification() {
        return KingdomsLang.ELECTIONS_JOIN_NOTIFY;
    }

    @Override
    public void conclude() {
        HashMap<UUID, ElectionResult> topVotes = new HashMap<UUID, ElectionResult>();
        for (ElectionCandidate electionCandidate : this.candidates.values()) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(electionCandidate.getId());
            if (!kp.hasKingdom()) continue;
            ElectionResult result = (ElectionResult)topVotes.get(kp.getKingdomId());
            if (result == null) {
                topVotes.put(kp.getKingdomId(), new ElectionResult(electionCandidate, kp.getKingdomId()));
                continue;
            }
            if (electionCandidate.getVotes().size() > result.getTopCandidate().getVotes().size()) {
                result.change(electionCandidate);
            }
            result.getTotalVotes().addAll(electionCandidate.getVotes());
        }
        for (Map.Entry entry : topVotes.entrySet()) {
            OfflinePlayer chosenCandidate = Bukkit.getOfflinePlayer((UUID)((ElectionResult)entry.getValue()).getTopCandidate().getId());
            ElectionCandidate candidateDetails = ((ElectionResult)entry.getValue()).getTopCandidate();
            Kingdom kingdom = Kingdom.getKingdom((UUID)entry.getKey());
            double votePercentage = this.getOption("vote-percentage").getDouble();
            double percent = MathUtils.getPercent(((ElectionResult)entry.getValue()).getTotalVotes().size(), kingdom.getMembers().size());
            KingdomsLang lang = percent < votePercentage ? KingdomsLang.ELECTIONS_RESULTS : KingdomsLang.ELECTIONS_NOT_ENOUGH_DATA;
            if (!chosenCandidate.getUniqueId().equals(kingdom.getOwnerId()) && kingdom.setKing(KingdomPlayer.getKingdomPlayer(chosenCandidate), KingdomKingChangeEvent.Reason.ELECTIONS).isCancelled()) {
                return;
            }
            for (Player member : kingdom.getOnlineMembers()) {
                lang.sendMessage((CommandSender)member, "candidate", chosenCandidate.getName(), "votes", candidateDetails.getVotes().size(), "statement", candidateDetails.getStatement());
            }
        }
    }
}

