/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.utils.time.TimeUtils;

public final class TimeZoneHandler {
    private static final DateTimeFormatter PARSER_FORMAT = DateTimeFormatter.ofPattern("H:m[:s]");
    public static final ZoneId SERVER_TIME_ZONE;
    public static final LocalTime DAILY_CHECKS;

    public static LocalTime parseLocalTime(String time) {
        return LocalTime.parse(time, PARSER_FORMAT);
    }

    public static long convert(ChronoUnit fromUnit, TimeUnit toUnit, long amount) {
        Objects.requireNonNull(toUnit);
        Objects.requireNonNull(fromUnit);
        switch (fromUnit) {
            case DAYS: {
                return toUnit.toDays(amount);
            }
            case HOURS: {
                return toUnit.toHours(amount);
            }
            case MINUTES: {
                return toUnit.toMinutes(amount);
            }
            case SECONDS: {
                return toUnit.toSeconds(amount);
            }
            case MICROS: {
                return toUnit.toMicros(amount);
            }
            case MILLIS: {
                return toUnit.toMillis(amount);
            }
            case NANOS: {
                return toUnit.toNanos(amount);
            }
        }
        throw new UnsupportedOperationException("Cannot convert ChronoUnit to TimeUnit: " + fromUnit);
    }

    static {
        String timezone = KingdomsConfig.DAILY_CHECKS_TIMEZONE.getString();
        if (timezone == null) {
            MessageHandler.sendConsolePluginMessage("&4Server timezone is not specified in the config. Using the default local timezone.");
            timezone = "local";
        }
        TimeUtils.TIME_ZONE = SERVER_TIME_ZONE = timezone.equalsIgnoreCase("local") ? ZoneId.systemDefault() : ZoneId.of(timezone);
        String time = KingdomsConfig.DAILY_CHECKS_TIME.getString();
        if (time == null) {
            MessageHandler.sendConsolePluginMessage("&4Server daily checks time is not specified in the config. Using the default 12:00 time.");
            time = "12:00";
        }
        DAILY_CHECKS = LocalTime.parse(time, PARSER_FORMAT);
    }
}

