/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.OfflinePlayer;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;

public final class InactivityManager {
    protected static boolean disband(Kingdom kingdom) {
        ConditionalExpression kingdomExcludeCond = KingdomsConfig.INACTIVITY_KINGDOM_EXCLUDE_CONDITION.getManager().getCondition();
        boolean result = ConditionProcessor.process(kingdomExcludeCond, new PlaceholderContextBuilder().withContext(kingdom));
        if (result) {
            return false;
        }
        AtomicBoolean disbanded = new AtomicBoolean(false);
        Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> {
            disbanded.set(!kingdom.disband(GroupDisband.Reason.INACTIVITY).isCancelled());
            if (disbanded.get() && KingdomsConfig.INACTIVITY_KINGDOM_ANNOUNCE.getBoolean()) {
                KingdomsLang.INACTIVITY_ANNOUNCE_KINGDOM.sendEveryoneMessage("kingdom", kingdom.getName());
            }
        });
        return disbanded.get();
    }

    protected static void handleInactiveMember(Kingdom kingdom, OfflinePlayer member) {
        ConditionalExpression kingdomExcludeCond = KingdomsConfig.INACTIVITY_MEMBER_EXCLUDE_CONDITION.getManager().getCondition();
        boolean result = ConditionProcessor.process(kingdomExcludeCond, new PlaceholderContextBuilder().withContext(member));
        if (result) {
            return;
        }
        Kingdoms.taskScheduler().sync().execute(() -> {
            KingdomPlayer kp;
            if (member.getUniqueId().equals(kingdom.getKingId())) {
                if (KingdomsConfig.INACTIVITY_MEMBER_DISBAND_KINGDOM_IF_KING.getBoolean()) {
                    InactivityManager.disband(kingdom);
                } else {
                    List<KingdomPlayer> members = kingdom.getKingdomPlayers();
                    if (members.isEmpty()) {
                        InactivityManager.disband(kingdom);
                    } else {
                        KingdomPlayer highestAfterKing = Rank.determineNextKing(members, true);
                        if (kingdom.setKing(highestAfterKing, KingdomKingChangeEvent.Reason.INACTIVITY).isCancelled()) {
                            return;
                        }
                    }
                }
            }
            if (!(kp = KingdomPlayer.getKingdomPlayer(member)).hasKingdom()) {
                MessageHandler.sendConsolePluginMessage("&4Unknown kingdom for player &e" + PlayerUtils.name(member) + " &4while kicking them due to inactivity &e" + kingdom.getName() + " &4kingdom. Removing them...");
                kingdom.unsafeGetMembers().remove(member.getUniqueId());
                return;
            }
            kp.leaveKingdom(LeaveReason.INACTIVITY);
            if (KingdomsConfig.INACTIVITY_MEMBER_ANNOUNCE.getBoolean()) {
                KingdomsLang.INACTIVITY_ANNOUNCE_PLAYER.sendEveryoneMessage("player", PlayerUtils.name(member));
            }
        });
    }
}

